/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BaseSSHUser;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameSSHKeyCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ConjurSecretUsernameSSHKeyCredentialsImpl
extends BaseSSHUser
implements ConjurSecretUsernameSSHKeyCredentials {
    private static final long serialVersionUID = 1L;
    private String credentialID;
    private ConjurConfiguration conjurConfiguration;
    private Secret passphrase;
    transient ModelObject context;
    transient ModelObject storeContext;

    @DataBoundConstructor
    public ConjurSecretUsernameSSHKeyCredentialsImpl(CredentialsScope scope, String id, String username, String credentialID, ConjurConfiguration conjurConfiguration, Secret passphrase, String description) {
        super(scope, id, username, description);
        this.credentialID = credentialID;
        this.passphrase = passphrase;
        this.conjurConfiguration = conjurConfiguration;
    }

    public String getCredentialID() {
        return this.credentialID;
    }

    @DataBoundSetter
    public void setCredentialID(String credentialID) {
        this.credentialID = credentialID;
    }

    public ConjurConfiguration getConjurConfiguration() {
        return this.conjurConfiguration;
    }

    @Override
    @DataBoundSetter
    public void setConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        ConjurAPI.logConjurConfiguration(conjurConfiguration);
        this.conjurConfiguration = conjurConfiguration;
        ConjurSecretCredentials.setConjurConfigurationForCredentialWithID(this.getCredentialID(), conjurConfiguration, this.context);
    }

    public Secret getPassphrase() {
        return this.passphrase;
    }

    @DataBoundSetter
    public void setPassphrase(Secret passphrase) {
        this.passphrase = passphrase;
    }

    public static String getDescriptorDisplayName() {
        return "Conjur Secret Username SSHKey Credential";
    }

    @Override
    public String getDisplayName() {
        return "ConjurSecretUsernameSSHKey:" + this.username;
    }

    @Override
    public void setContext(ModelObject context) {
        if (context != null) {
            this.context = context;
        }
    }

    @Override
    public void setStoreContext(ModelObject storeContext) {
        this.storeContext = storeContext;
    }

    @Override
    public String getPrivateKey() {
        Secret secret = ConjurSecretCredentials.getSecretFromCredentialIDWithConfigAndContext(this.getCredentialID(), this.conjurConfiguration, this.context, this.storeContext);
        return secret.getPlainText();
    }

    public List<String> getPrivateKeys() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getPrivateKey());
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return ConjurSecretUsernameSSHKeyCredentialsImpl.getDescriptorDisplayName();
        }

        public ListBoxModel doFillCredentialIDItems(@AncestorInPath Item item, @QueryParameter String uri) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return new StandardListBoxModel().includeAs(ACL.SYSTEM, item, ConjurSecretCredentials.class, URIRequirementBuilder.fromUri((String)uri).build());
        }
    }
}

