/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameSSHKeyCredentials;
import org.conjur.jenkins.credentials.ConjurCredentialStore;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurSecretUsernameSSHKeyCredentialsBinding
extends MultiBinding<ConjurSecretUsernameSSHKeyCredentials> {
    private static final Logger LOGGER = Logger.getLogger(ConjurSecretUsernameSSHKeyCredentialsBinding.class.getName());
    private String usernameVariable;
    private String secretVariable;

    @DataBoundConstructor
    public ConjurSecretUsernameSSHKeyCredentialsBinding(String credentialsId) {
        super(credentialsId);
    }

    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workSpace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, "Start of bind()");
        ConjurCredentialStore store = (ConjurCredentialStore)((Object)ConjurCredentialStore.getAllStores().get(String.valueOf(build.getParent().hashCode())));
        if (store != null) {
            store.getProvider().getStore(build);
        }
        ConjurSecretUsernameSSHKeyCredentials conjurSecretCredential = (ConjurSecretUsernameSSHKeyCredentials)this.getCredentials(build);
        conjurSecretCredential.setContext((ModelObject)build);
        HashMap<String, String> m = new HashMap<String, String>();
        String usernameValue = conjurSecretCredential.getUsername();
        String secretValue = conjurSecretCredential.getPrivateKey();
        m.put(this.usernameVariable, usernameValue);
        m.put(this.secretVariable, secretValue);
        LOGGER.log(Level.FINE, "End of bind()");
        return new MultiBinding.MultiEnvironment(m);
    }

    public String getSecretVariable() {
        return this.secretVariable;
    }

    public String getUsernameVariable() {
        return this.usernameVariable;
    }

    @DataBoundSetter
    public void setSecretVariable(String secretVariable) {
        this.secretVariable = secretVariable;
    }

    @DataBoundSetter
    public void setUsernameVariable(String usernameVariable) {
        this.usernameVariable = usernameVariable;
    }

    protected Class<ConjurSecretUsernameSSHKeyCredentials> type() {
        return ConjurSecretUsernameSSHKeyCredentials.class;
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.usernameVariable, this.secretVariable));
    }

    @Symbol(value={"conjurSecretUsernameSSHKey"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<ConjurSecretUsernameSSHKeyCredentials> {
        public String getDisplayName() {
            return "Conjur Secret Username SSHKey credentials";
        }

        public boolean requiresWorkspace() {
            return false;
        }

        protected Class<ConjurSecretUsernameSSHKeyCredentials> type() {
            return ConjurSecretUsernameSSHKeyCredentials.class;
        }
    }
}

