/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@NameWith(value=ConjurSecretCredentials.NameProvider.class, priority=1)
public class ConjurSecretUsernameCredentialsImpl
extends BaseStandardCredentials
implements ConjurSecretUsernameCredentials {
    private String username;
    private String credentialID;
    private ConjurConfiguration conjurConfiguration;
    private transient ModelObject context;
    private transient ModelObject storeContext;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ConjurSecretUsernameCredentialsImpl(CredentialsScope scope, String id, String username, String credentialID, ConjurConfiguration conjurConfiguration, String description) {
        super(scope, id, description);
        this.username = username;
        this.credentialID = credentialID;
        this.conjurConfiguration = conjurConfiguration;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUserName(String username) {
        this.username = username;
    }

    public String getCredentialID() {
        return this.credentialID;
    }

    @DataBoundSetter
    public void setCredentialID(String credentialID) {
        this.credentialID = credentialID;
    }

    public ConjurConfiguration getConjurConfiguration() {
        return this.conjurConfiguration;
    }

    @Override
    @DataBoundSetter
    public void setConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        ConjurAPI.logConjurConfiguration(conjurConfiguration);
        this.conjurConfiguration = conjurConfiguration;
        ConjurSecretCredentials.setConjurConfigurationForCredentialWithID(this.getCredentialID(), conjurConfiguration, this.context);
    }

    public static String getDescriptorDisplayName() {
        return "Conjur Secret Username Credential";
    }

    @Override
    public String getDisplayName() {
        return "ConjurSecretUsername:" + this.getCredentialID();
    }

    @Override
    public void setContext(ModelObject context) {
        if (context != null) {
            this.context = context;
        }
    }

    @Override
    public void setStoreContext(ModelObject storeContext) {
        if (storeContext != null) {
            this.storeContext = storeContext;
        }
    }

    @Override
    public Secret getSecret() {
        return this.getPassword();
    }

    public Secret getPassword() {
        return ConjurSecretCredentials.getSecretFromCredentialIDWithConfigAndContext(this.getCredentialID(), this.conjurConfiguration, this.context, this.storeContext);
    }

    @Override
    public String getNameTag() {
        return "";
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return ConjurSecretUsernameCredentialsImpl.getDescriptorDisplayName();
        }

        public ListBoxModel doFillCredentialIDItems(@AncestorInPath Item item, @QueryParameter String uri) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return new StandardListBoxModel().includeAs(ACL.SYSTEM, item, ConjurSecretCredentials.class, URIRequirementBuilder.fromUri((String)uri).build());
        }
    }
}

