/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameCredentials;
import org.conjur.jenkins.credentials.ConjurCredentialStore;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurSecretUsernameCredentialsBinding
extends MultiBinding<ConjurSecretUsernameCredentials> {
    private static final Logger LOGGER = Logger.getLogger(ConjurSecretUsernameCredentialsBinding.class.getName());
    private String usernameVariable;
    private String passwordVariable;

    @DataBoundConstructor
    public ConjurSecretUsernameCredentialsBinding(String credentialsId) {
        super(credentialsId);
    }

    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workSpace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, "Start of bind()");
        LOGGER.log(Level.FINE, "Binding UserName and Password");
        ConjurCredentialStore store = (ConjurCredentialStore)((Object)ConjurCredentialStore.getAllStores().get(String.valueOf(build.getParent().hashCode())));
        if (store != null) {
            store.getProvider().getStore(build);
        }
        ConjurSecretUsernameCredentials conjurSecretCredential = (ConjurSecretUsernameCredentials)this.getCredentials(build);
        conjurSecretCredential.setContext((ModelObject)build);
        HashMap<String, String> m = new HashMap<String, String>();
        if (conjurSecretCredential.getPassword() == null) {
            throw new CredentialNotFoundException("Could not find Conjur Secret Username Credentials entry is null or invalid.");
        }
        m.put(this.usernameVariable, conjurSecretCredential.getUsername());
        m.put(this.passwordVariable, conjurSecretCredential.getPassword().getPlainText());
        return new MultiBinding.MultiEnvironment(m);
    }

    public String getPasswordVariable() {
        return this.passwordVariable;
    }

    public String getUsernameVariable() {
        return this.usernameVariable;
    }

    @DataBoundSetter
    public void setPasswordVariable(String passwordVariable) {
        LOGGER.log(Level.FINE, "Setting Password variable to {0}", passwordVariable);
        this.passwordVariable = passwordVariable;
    }

    @DataBoundSetter
    public void setUsernameVariable(String usernameVariable) {
        LOGGER.log(Level.FINE, "Setting Username variable to {0}", usernameVariable);
        this.usernameVariable = usernameVariable;
    }

    protected Class<ConjurSecretUsernameCredentials> type() {
        return ConjurSecretUsernameCredentials.class;
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.usernameVariable, this.passwordVariable));
    }

    @Symbol(value={"conjurSecretUsername"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<ConjurSecretUsernameCredentials> {
        public String getDisplayName() {
            return "Conjur Secret Username credentials";
        }

        public boolean requiresWorkspace() {
            return false;
        }

        protected Class<ConjurSecretUsernameCredentials> type() {
            return ConjurSecretUsernameCredentials.class;
        }
    }
}

