/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.ModelObject;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import okhttp3.OkHttpClient;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.exceptions.InvalidConjurSecretException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurSecretCredentialsImpl
extends BaseStandardCredentials
implements ConjurSecretCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ConjurSecretCredentialsImpl.class.getName());
    private String variablePath;
    private ConjurConfiguration conjurConfiguration;
    private transient ModelObject context;
    private transient ModelObject storeContext;

    @DataBoundConstructor
    public ConjurSecretCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String variablePath, @CheckForNull String description) {
        super(scope, id, description);
        this.variablePath = variablePath;
    }

    @Override
    public String getDisplayName() {
        return "ConjurSecret:" + this.variablePath;
    }

    static Secret secretFromString(String secretString) {
        return Secret.fromString((String)secretString);
    }

    @Override
    public Secret getSecret() {
        LOGGER.log(Level.FINE, "Start of Class ConjurSecretCredentialsImpl *****getSecret()*****");
        String result = "";
        try {
            OkHttpClient client = ConjurAPIUtils.getHttpClient(this.conjurConfiguration);
            ModelObject effectiveContext = this.storeContext != null ? this.storeContext : this.context;
            LOGGER.log(Level.FINE, "Start of getSecret() *****this.context*****: " + this.context);
            LOGGER.log(Level.FINE, "Start of getSecret() *****storeContext*****: " + this.storeContext);
            LOGGER.log(Level.FINE, "Start of getSecret() *****effectiveContext*****: " + effectiveContext);
            if (effectiveContext != null) {
                String secretString;
                String authToken = ConjurAPI.getAuthorizationToken(client, this.conjurConfiguration, effectiveContext);
                result = secretString = ConjurAPI.getSecret(client, this.conjurConfiguration, authToken, this.variablePath);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "EXCEPTION: " + e.getMessage());
            throw new InvalidConjurSecretException(e.getMessage(), e);
        }
        LOGGER.log(Level.FINE, "End of getSecret()");
        return ConjurSecretCredentialsImpl.secretFromString(result);
    }

    public String getVariablePath() {
        return this.variablePath;
    }

    @Override
    public void setConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        if (conjurConfiguration != null) {
            this.conjurConfiguration = conjurConfiguration;
        }
    }

    @Override
    public void setContext(ModelObject context) {
        LOGGER.log(Level.FINEST, "Setting context -->" + context + " storeContext::" + this.storeContext);
        this.context = context;
        this.setConjurConfiguration(ConjurAPI.getConfigurationFromContext(context, this.storeContext));
    }

    @Override
    public void setStoreContext(ModelObject storeContext) {
        LOGGER.log(Level.FINEST, "Setting store context");
        this.storeContext = storeContext;
        this.setConjurConfiguration(ConjurAPI.getConfigurationFromContext(this.context, storeContext));
    }

    @DataBoundSetter
    public void setVariablePath(String variablePath) {
        this.variablePath = variablePath;
    }

    @Override
    public String getNameTag() {
        return "";
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return "Conjur Secret Credential";
        }
    }
}

