/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.credentials.ConjurCredentialStore;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurSecretCredentialsBinding
extends MultiBinding<ConjurSecretCredentials> {
    private static final Logger LOGGER = Logger.getLogger(ConjurSecretCredentialsBinding.class.getName());
    private String variable;
    private String credentialsId;
    private boolean isParent;

    public boolean isParent() {
        return this.isParent;
    }

    public void setParent(boolean isParent) {
        this.isParent = isParent;
    }

    @DataBoundConstructor
    public ConjurSecretCredentialsBinding(String credentialsId) {
        super(credentialsId);
        this.credentialsId = credentialsId;
    }

    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workSpace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        long start = System.nanoTime();
        LOGGER.log(Level.FINE, "**** binding **** : " + build);
        ConjurCredentialStore store = (ConjurCredentialStore)((Object)ConjurCredentialStore.getAllStores().get(String.valueOf(build.getParent().hashCode())));
        if (store != null) {
            LOGGER.log(Level.FINE, "Store details" + (Object)((Object)store));
            store.getProvider().getStore(build);
        }
        ConjurSecretCredentials conjurSecretCredential = (ConjurSecretCredentials)this.getCredentialsFor(build);
        LOGGER.log(Level.FINE, "Get Parent flage status", this.isParent);
        if (!this.isParent) {
            LOGGER.log(Level.FINE, "Context Set");
            conjurSecretCredential.setContext((ModelObject)build);
        } else {
            Item item;
            LOGGER.log(Level.FINE, "Context Set not for parent" + conjurSecretCredential.getDescription());
            if (conjurSecretCredential != null && (item = Jenkins.get().getItemByFullName(conjurSecretCredential.getDescription())) != null) {
                conjurSecretCredential.setContext((ModelObject)item);
                LOGGER.log(Level.FINE, "Context Set not for parent" + item.getDisplayName());
            }
        }
        long end = System.nanoTime();
        long execution = end - start;
        LOGGER.log(Level.OFF, "Execution of Class ConjurSecretCredentialsBinding -->Method bind() time: " + (double)execution / 1000000.0 + " milliseconds");
        return new MultiBinding.MultiEnvironment(Collections.singletonMap(this.variable, conjurSecretCredential.getSecret().getPlainText()));
    }

    @Nonnull
    private final <C> C getCredentialsFor(@Nonnull Run<?, ?> build) throws IOException, InterruptedException {
        long start = System.nanoTime();
        Object cred = CredentialsProvider.findCredentialById((String)this.credentialsId, IdCredentials.class, build, (DomainRequirement[])new DomainRequirement[0]);
        LOGGER.log(Level.FINE, "Calling getCredential For1" + build.getFullDisplayName());
        String newCredentialId = "";
        if (cred == null) {
            this.setParent(true);
            Job item = build.getParent();
            if (item != null) {
                LOGGER.log(Level.FINE, "Item Name" + item.getParent().getDisplayName());
                newCredentialId = this.credentialsId.replaceAll("([${}])", "");
                LOGGER.log(Level.FINE, "CredentialId after removing ${}" + newCredentialId);
                ConjurSecretCredentials conjurSecretCredential = null;
                conjurSecretCredential = ConjurSecretCredentials.credentialWithID(newCredentialId, (ModelObject)item);
                LOGGER.log(Level.FINE, "From Binding Credential" + conjurSecretCredential);
                cred = conjurSecretCredential;
                if (cred == null) {
                    throw new CredentialNotFoundException("Could not find credentials entry with ID '" + this.credentialsId + "'");
                }
            }
        }
        if (this.type().isInstance(cred)) {
            CredentialsProvider.track(build, (Credentials)cred);
            return (C)this.type().cast(cred);
        }
        Descriptor expected = Jenkins.getActiveInstance().getDescriptor(this.type());
        long end = System.nanoTime();
        long execution = end - start;
        LOGGER.log(Level.OFF, "Execution of Class ConjurSecretCredentialsBinding -->Method getCredentialsFor() time: " + (double)execution / 1000000.0 + " milliseconds");
        throw new CredentialNotFoundException("Credentials '" + this.credentialsId + "' not found '" + cred + "' where '" + (expected != null ? expected.getDisplayName() : this.type().getName()) + "' was expected");
    }

    public String getVariable() {
        return this.variable;
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        LOGGER.log(Level.FINE, "Setting variable to {0}", variable);
        this.variable = variable;
    }

    protected Class<ConjurSecretCredentials> type() {
        return ConjurSecretCredentials.class;
    }

    public Set<String> variables() {
        return Collections.singleton(this.variable);
    }

    @Symbol(value={"conjurSecretCredential"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<ConjurSecretCredentials> {
        public String getDisplayName() {
            return "Conjur Secret credentials";
        }

        public boolean requiresWorkspace() {
            return false;
        }

        protected Class<ConjurSecretCredentials> type() {
            return ConjurSecretCredentials.class;
        }
    }
}

