/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.security.ACL;
import hudson.util.Secret;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.conjur.jenkins.configuration.ConjurConfiguration;

@NameWith(value=NameProvider.class, priority=1)
public interface ConjurSecretCredentials
extends StandardCredentials {
    public static final Logger LOGGER = Logger.getLogger(ConjurSecretCredentials.class.getName());

    public String getDisplayName();

    public String getNameTag();

    public Secret getSecret();

    default public Secret secretWithConjurConfigAndContext(ConjurConfiguration conjurConfiguration, ModelObject context) {
        this.setConjurConfiguration(conjurConfiguration);
        this.setContext(context);
        return this.getSecret();
    }

    public void setConjurConfiguration(ConjurConfiguration var1);

    public void setStoreContext(ModelObject var1);

    public void setContext(ModelObject var1);

    public static ConjurSecretCredentials credentialFromContextIfNeeded(ConjurSecretCredentials credential, String credentialID, ModelObject context) {
        LOGGER.log(Level.FINE, "Start of credentialFromContextIfNeeded()");
        if (credential == null && context != null) {
            LOGGER.log(Level.FINE, "NOT FOUND at Jenkins Instance Level!");
            Item folder = null;
            if (context instanceof Run) {
                folder = Jenkins.get().getItemByFullName(((Run)context).getParent().getParent().getFullName());
                LOGGER.log(Level.FINE, "Context is a Run: {0}", folder);
            } else if (context instanceof AbstractItem) {
                AbstractItem item = (AbstractItem)context;
                String folderName = item.getFullName();
                if (folderName == null || folderName.isEmpty()) {
                    folderName = item.getParent().getFullName();
                }
                LOGGER.log(Level.FINE, "Resolving folder by name >> {0}", folderName);
                folder = Jenkins.get().getItemByFullName(folderName);
            }
            if (folder != null) {
                credential = (ConjurSecretCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(ConjurSecretCredentials.class, (Item)folder, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialID));
            }
            return credential;
        }
        LOGGER.log(Level.FINE, "End  of credentialFromContextIfNeeded()... returning credentails");
        return credential;
    }

    public static ConjurSecretCredentials credentialWithID(String credentialID, ModelObject context) {
        LOGGER.log(Level.FINE, "Start of credentialWithID()");
        ConjurSecretCredentials conjurSecretCredential = null;
        ConjurSecretCredentials credential = (ConjurSecretCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(ConjurSecretCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialID));
        if (credential == null && context != null) {
            LOGGER.log(Level.FINE, "Credentials not found at Jenkins instance level >> {0}", context);
            String[] multiFolder = context.toString().split("/");
            Item parentFolder = null;
            if (context.getDisplayName().equalsIgnoreCase("Jenkins")) {
                LOGGER.log(Level.FINE, "Inside not Context Jenkins" + context.getDisplayName());
                return null;
            }
            if (context instanceof Run) {
                parentFolder = Jenkins.get().getItemByFullName(((Run)context).getParent().getParent().getFullName());
                LOGGER.log(Level.FINE, "Context is a Run, fetching parent folder:{0}" + parentFolder);
            } else if (context instanceof Job) {
                parentFolder = Jenkins.get().getItemByFullName(context.getDisplayName());
                LOGGER.log(Level.FINE, "Context is a Job, fetching parent folder: {0}" + parentFolder);
                if (parentFolder == null) {
                    parentFolder = Jenkins.get().getItemByFullName(((AbstractItem)((AbstractItem)context).getParent()).getFullName());
                    LOGGER.log(Level.FINE, "Job has folder level>>{0}", parentFolder);
                }
            } else {
                parentFolder = Jenkins.get().getItemByFullName(((AbstractItem)((AbstractItem)context).getParent()).getFullName());
                LOGGER.log(Level.FINE, "Inside not Context is a Job, fetching parent folder: {0}", parentFolder);
            }
            for (int i = 0; i < multiFolder.length - 1; ++i) {
                if (parentFolder == null) continue;
                credential = ConjurSecretCredentials.credentialFromContextIfNeeded(conjurSecretCredential, credentialID, (ModelObject)parentFolder);
                if (credential != null) break;
                if (!(parentFolder.getParent() instanceof Item)) continue;
                parentFolder = (Item)parentFolder.getParent();
                LOGGER.log(Level.FINE, "Moving up to parent folder: {0}", parentFolder);
            }
        }
        LOGGER.log(Level.FINE, "End of credentialWithID()");
        return credential;
    }

    public static void setConjurConfigurationForCredentialWithID(String credentialID, ConjurConfiguration conjurConfiguration, ModelObject context) {
        LOGGER.log(Level.FINE, "Start of setConjurConfigurationForCredentialWithID()");
        ConjurSecretCredentials credential = ConjurSecretCredentials.credentialWithID(credentialID, context);
        if (credential != null) {
            credential.setConjurConfiguration(conjurConfiguration);
        }
        LOGGER.log(Level.FINE, "End of setConjurConfigurationForCredentialWithID()");
    }

    public static Secret getSecretFromCredentialIDWithConfigAndContext(String credentialID, ConjurConfiguration conjurConfiguration, ModelObject context, ModelObject storeContext) {
        LOGGER.log(Level.FINE, "Start of  the getSecretFromCredentialIDWithConfigAndContext()");
        Secret secret = null;
        ModelObject effectiveContext = context != null ? context : storeContext;
        LOGGER.log(Level.FINE, "Getting Secret with CredentialID: {0},{1}", new Object[]{context, credentialID});
        ConjurSecretCredentials credential = ConjurSecretCredentials.credentialWithID(credentialID, effectiveContext);
        if (credential != null) {
            LOGGER.log(Level.FINE, "Getting Secret Inside If with CredentialID: " + credential.getId());
            secret = credential.secretWithConjurConfigAndContext(conjurConfiguration, effectiveContext);
        }
        LOGGER.log(Level.FINE, "End of  the getSecretFromCredentialIDWithConfigAndContext()");
        return secret;
    }

    public static class NameProvider
    extends CredentialsNameProvider<ConjurSecretCredentials> {
        public String getName(ConjurSecretCredentials c) {
            return c.getDisplayName() + c.getNameTag() + " (" + c.getDescription() + ")";
        }
    }
}

