/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.configuration;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class GlobalConjurConfiguration
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConjurConfiguration conjurConfiguration;
    private Boolean enableJWKS = false;
    private String authWebServiceId = "";
    private String jwtAudience = "cyberark-conjur";
    private long keyLifetimeInMinutes = 60L;
    private long tokenDurarionInSeconds = 120L;
    private Boolean enableContextAwareCredentialStore = false;
    private Boolean enableIdentityFormatFieldsFromToken = false;
    private String identityFormatFieldsFromToken = "jenkins_full_name";
    private String selectIdentityFormatToken = "jenkins_full_name";
    private String selectIdentityFieldsSeparator = "-";
    private String identityFieldName = "sub";
    private static final Logger LOGGER = Logger.getLogger(GlobalConjurConfiguration.class.getName());

    public FormValidation doCheckTokenDurarionInSeconds(@AncestorInPath AbstractItem anc, @QueryParameter(value="tokenDurarionInSeconds") String tokenDurarionInSeconds, @QueryParameter(value="keyLifetimeInMinutes") String keyLifetimeInMinutes, @QueryParameter(value="enableJWKS") Boolean enableJWKS) {
        LOGGER.log(Level.FINE, "Inside of doCheckTokenDurarionInSeconds()");
        if (!enableJWKS.booleanValue()) {
            return FormValidation.ok();
        }
        try {
            int tokenttl = Integer.parseInt(tokenDurarionInSeconds);
            int keyttl = Integer.parseInt(keyLifetimeInMinutes);
            if (tokenttl > keyttl * 60) {
                LOGGER.log(Level.FINE, "Token cannot last longer than key");
                return FormValidation.error((String)"Token cannot last longer than key");
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Key lifetime and token duration must be numbers");
            return FormValidation.error((String)"Key lifetime and token duration must be numbers");
        }
    }

    public FormValidation doCheckAuthWebServiceId(@AncestorInPath AbstractItem anc, @QueryParameter(value="authWebServiceId") String authWebServiceId, @QueryParameter(value="enableJWKS") Boolean enableJWKS) {
        LOGGER.log(Level.FINE, "Inside of doCheckAuthWebServiceId()");
        if (enableJWKS.booleanValue()) {
            if (StringUtils.isEmpty((String)authWebServiceId) || StringUtils.isBlank((String)authWebServiceId)) {
                LOGGER.log(Level.FINE, "Auth WebService Id should not be empty");
                return FormValidation.error((String)"Auth WebService Id should not be empty");
            }
            return FormValidation.ok();
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckJwtAudience(@AncestorInPath AbstractItem anc, @QueryParameter(value="jwtAudience") String jwtAudience, @QueryParameter(value="enableJWKS") Boolean enableJWKS) {
        LOGGER.log(Level.FINE, "Inside of doCheckJwtAudience()");
        if (enableJWKS.booleanValue()) {
            if (StringUtils.isEmpty((String)jwtAudience) || StringUtils.isBlank((String)jwtAudience)) {
                LOGGER.log(Level.FINE, "JWT Audience field value defaults to: cyberark-conjur");
                return FormValidation.warning((String)"JWT Audience field value defaults to: cyberark-conjur ");
            }
            return FormValidation.ok();
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckIdentityFieldName(@AncestorInPath AbstractItem anc, @QueryParameter(value="identityFieldName") String identityFieldName, @QueryParameter(value="enableJWKS") Boolean enableJWKS) {
        if (enableJWKS.booleanValue()) {
            String alphanumericRegex = "^[a-zA-Z0-9\\-_\"]*$";
            if (StringUtils.isEmpty((String)identityFieldName) || StringUtils.isBlank((String)identityFieldName)) {
                LOGGER.log(Level.FINE, "Identity Field Name should not be empty");
                return FormValidation.error((String)"Identity Field Name should not be empty");
            }
            if (!identityFieldName.matches(alphanumericRegex)) {
                LOGGER.log(Level.FINE, "Identity Field Name should contain only alphanumeric characters including \"-\", \"_\", and \" \"");
                return FormValidation.error((String)"Identity Field Name should contain only alphanumeric characters including \"-\", \"_\", and \" \"");
            }
            return FormValidation.ok();
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckIdentityFormatFieldsFromToken(@AncestorInPath AbstractItem anc, @QueryParameter(value="identityFormatFieldsFromToken") String identityFormatFieldsFromToken, @QueryParameter(value="enableJWKS") Boolean enableJWKS) {
        LOGGER.log(Level.FINE, "Inside of doCheckIdentityFormatField()");
        List<String> identityFields = Arrays.asList(identityFormatFieldsFromToken.split(","));
        if (enableJWKS.booleanValue()) {
            if (StringUtils.isEmpty((String)identityFormatFieldsFromToken) || StringUtils.isBlank((String)identityFormatFieldsFromToken)) {
                LOGGER.log(Level.FINE, "Identity Format Fields should not be empty");
                return FormValidation.error((String)"Identity Format Fields should not be empty");
            }
            return this.validateIdentityFormatFields(identityFields);
        }
        return FormValidation.ok();
    }

    private FormValidation validateIdentityFormatFields(List<String> identityFields) {
        boolean jenkinsFullNameExists = identityFields.contains("jenkins_full_name");
        boolean jenkinsParentFullNameExists = identityFields.contains("jenkins_parent_full_name");
        boolean jenkinsNameExists = identityFields.contains("jenkins_name");
        if (jenkinsFullNameExists) {
            return FormValidation.ok();
        }
        if (jenkinsParentFullNameExists && jenkinsNameExists) {
            return FormValidation.ok();
        }
        return this.handleValidationError("jenkins_full_name or a combination of jenkins_parent_full_name and jenkins_name");
    }

    private FormValidation handleValidationError(String tokens) {
        LOGGER.log(Level.WARNING, "Identity Format Fields must contain at least one of the  " + tokens);
        return FormValidation.error((String)("Identity Format Fields must contain at least one of the " + tokens));
    }

    public static GlobalConjurConfiguration get() {
        LOGGER.log(Level.FINE, "GlobalConjurConfiguration get()");
        GlobalConjurConfiguration result = null;
        try {
            result = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
            LOGGER.log(Level.FINE, "Inside GlobalConjurConfiguration get() result:  " + result);
            if (result == null) {
                throw new IllegalStateException();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public GlobalConjurConfiguration() {
        LOGGER.log(Level.FINE, "GlobalConjurConfiguration load()");
        this.load();
    }

    public ConjurConfiguration getConjurConfiguration() {
        return this.conjurConfiguration;
    }

    public Boolean getEnableJWKS() {
        return this.enableJWKS;
    }

    public Boolean getEnableContextAwareCredentialStore() {
        return this.enableContextAwareCredentialStore;
    }

    public String getAuthWebServiceId() {
        return this.authWebServiceId;
    }

    @DataBoundSetter
    public void setAuthWebServiceId(String authWebServiceId) {
        this.authWebServiceId = authWebServiceId;
        this.save();
    }

    public String getidentityFieldName() {
        return this.identityFieldName;
    }

    @DataBoundSetter
    public void setIdentityFieldName(String identityFieldName) {
        this.identityFieldName = !identityFieldName.isEmpty() ? identityFieldName : "sub";
        this.save();
    }

    public String getIdentityFormatFieldsFromToken() {
        return this.identityFormatFieldsFromToken;
    }

    @DataBoundSetter
    public void setIdentityFormatFieldsFromToken(String identityFormatFieldsFromToken) {
        LOGGER.log(Level.FINE, "GlobalConjurConfiguration get() #identityFormatFieldsFromToken " + identityFormatFieldsFromToken);
        this.identityFormatFieldsFromToken = identityFormatFieldsFromToken;
        this.save();
    }

    public String getJwtAudience() {
        return this.jwtAudience;
    }

    @DataBoundSetter
    public void setJwtAudience(String jwtAudience) {
        this.jwtAudience = !jwtAudience.isEmpty() ? jwtAudience : "cyberark-conjur";
        this.save();
    }

    public long getKeyLifetimeInMinutes() {
        return this.keyLifetimeInMinutes;
    }

    @DataBoundSetter
    public void setKeyLifetimeInMinutes(long keyLifetimeInMinutes) {
        this.keyLifetimeInMinutes = keyLifetimeInMinutes;
        this.save();
    }

    public long getTokenDurarionInSeconds() {
        return this.tokenDurarionInSeconds;
    }

    @DataBoundSetter
    public void setTokenDurarionInSeconds(long tokenDurarionInSeconds) {
        this.tokenDurarionInSeconds = tokenDurarionInSeconds;
        this.save();
    }

    @DataBoundSetter
    public void setConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        this.conjurConfiguration = conjurConfiguration;
        this.save();
    }

    @DataBoundSetter
    public void setEnableJWKS(Boolean enableJWKS) {
        this.enableJWKS = enableJWKS;
        this.save();
    }

    @DataBoundSetter
    public void setEnableContextAwareCredentialStore(Boolean enableContextAwareCredentialStore) {
        this.enableContextAwareCredentialStore = enableContextAwareCredentialStore;
        this.save();
    }

    public Boolean getEnableIdentityFormatFieldsFromToken() {
        return this.enableIdentityFormatFieldsFromToken;
    }

    @DataBoundSetter
    public void setEnableIdentityFormatFieldsFromToken(Boolean enableIdentityFormatFieldsFromToken) {
        LOGGER.log(Level.FINE, "GlobalConjurConfiguration get() #enableIdentityFormatFieldsFromToken " + enableIdentityFormatFieldsFromToken);
        this.enableIdentityFormatFieldsFromToken = enableIdentityFormatFieldsFromToken;
        this.save();
    }

    public String getSelectIdentityFormatToken() {
        return this.selectIdentityFormatToken;
    }

    @DataBoundSetter
    public void setSelectIdentityFormatToken(String selectIdentityFormatToken) {
        LOGGER.log(Level.FINE, "GlobalConjurConfiguration get() #selectIdentityFormatToken " + selectIdentityFormatToken);
        this.selectIdentityFormatToken = selectIdentityFormatToken;
        this.save();
    }

    public String getSelectIdentityFieldsSeparator() {
        return this.selectIdentityFieldsSeparator;
    }

    @DataBoundSetter
    public void setSelectIdentityFieldsSeparator(String selectIdentityFieldsSeparator) {
        this.selectIdentityFieldsSeparator = selectIdentityFieldsSeparator;
        this.save();
    }
}

