/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.configuration;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import jenkins.model.Jenkins;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConjurJITJobProperty<T extends Job<?, ?>>
extends JobProperty<T> {
    private static final String DISPLAY_NAME = "Conjur Just-In-Time Access";
    private Boolean inheritFromParent = true;
    private Boolean useJustInTime = false;
    private String authWebServiceId = "";
    private String hostPrefix = "";
    private ConjurConfiguration conjurConfiguration;

    @DataBoundConstructor
    public ConjurJITJobProperty(ConjurConfiguration conjurConfiguration) {
        this.conjurConfiguration = conjurConfiguration;
    }

    public ConjurConfiguration getConjurConfiguration() {
        return this.conjurConfiguration;
    }

    @DataBoundSetter
    public void setConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        this.conjurConfiguration = conjurConfiguration;
    }

    public Boolean getInheritFromParent() {
        return this.inheritFromParent;
    }

    @DataBoundSetter
    public void setInheritFromParent(Boolean inheritFromParent) {
        this.inheritFromParent = inheritFromParent;
    }

    public Boolean getUseJustInTime() {
        return this.useJustInTime;
    }

    @DataBoundSetter
    public void setUseJustInTime(Boolean useJustInTime) {
        this.useJustInTime = useJustInTime;
    }

    public String getAuthWebServiceId() {
        return this.authWebServiceId;
    }

    @DataBoundSetter
    public void setAuthWebServiceId(String authWebServiceId) {
        this.authWebServiceId = authWebServiceId;
    }

    public String getHostPrefix() {
        return this.hostPrefix;
    }

    public Item getItem() {
        return Jenkins.get().getItemByFullName(this.owner.getFullName());
    }

    @DataBoundSetter
    public void setHostPrefix(String hostPrefix) {
        this.hostPrefix = hostPrefix;
    }

    @Extension
    public static final class ConjurJITJobPropertyDescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return ConjurJITJobProperty.DISPLAY_NAME;
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }
    }
}

