/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.configuration;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.conjur.jenkins.configuration.GlobalConjurConfiguration;
import org.conjur.jenkins.credentials.ConjurCredentialProvider;
import org.conjur.jenkins.credentials.ConjurCredentialStore;
import org.conjur.jenkins.credentials.CredentialsSupplier;
import org.conjur.jenkins.jwtauth.impl.JwtToken;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ConjurConfiguration
extends AbstractDescribableImpl<ConjurConfiguration>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ConjurConfiguration.class.getName());
    private static final long serialVersionUID = 1L;
    private String applianceURL;
    private String account;
    private String credentialID;
    private String certificateCredentialID;
    private String ownerFullName;

    public ConjurConfiguration() {
    }

    @DataBoundConstructor
    public ConjurConfiguration(String applianceURL, String account) {
        this.applianceURL = applianceURL.endsWith("/") ? applianceURL.substring(0, applianceURL.length() - 1) : applianceURL;
        this.account = account;
    }

    public FormValidation doCheckAccount(@QueryParameter String value) {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.warning((String)"Please specify Account.");
        }
        return FormValidation.ok();
    }

    public String getAccount() {
        return this.account;
    }

    public String getApplianceURL() {
        return this.applianceURL;
    }

    public String getCertificateCredentialID() {
        return this.certificateCredentialID;
    }

    public String getCredentialID() {
        return this.credentialID;
    }

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    @DataBoundSetter
    public void setAccount(String account) {
        this.account = account;
    }

    @DataBoundSetter
    public void setApplianceURL(String applianceURL) {
        this.applianceURL = applianceURL;
    }

    @DataBoundSetter
    public void setCertificateCredentialID(String certificateCredentialID) {
        this.certificateCredentialID = certificateCredentialID;
    }

    @DataBoundSetter
    public void setCredentialID(String credentialID) {
        this.credentialID = credentialID;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    private static ListBoxModel fillCredentialIDItemsWithClass(Item item, String credentialsId, Class<? extends StandardCredentials> credentialClass) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return result.includeCurrentValue(credentialsId);
        }
        if (item != null && !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeAs(ACL.SYSTEM, item, credentialClass, URIRequirementBuilder.fromUri((String)credentialsId).build()).includeCurrentValue(credentialsId);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ConjurConfiguration> {
        public ListBoxModel doFillCertificateCredentialIDItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            LOGGER.log(Level.FINE, "Inside doFillCertificateCredentialIDItems()");
            return ConjurConfiguration.fillCredentialIDItemsWithClass(item, credentialsId, StandardCertificateCredentials.class);
        }

        public ListBoxModel doFillCredentialIDItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            LOGGER.log(Level.FINE, "Inside doFillCredentialIDItems()");
            return ConjurConfiguration.fillCredentialIDItemsWithClass(item, credentialsId, StandardUsernamePasswordCredentials.class);
        }

        public String getDisplayName() {
            LOGGER.log(Level.FINE, "Inside getDisplayName()");
            return "Conjur Configuration";
        }

        @POST
        public FormValidation doObtainJwtToken(@AncestorInPath Item item) {
            LOGGER.log(Level.FINE, "Inside doObtainJwtToken()");
            String error = this.doValidateIdentityFormatField();
            if (error.length() != 0) {
                return FormValidation.error((String)error);
            }
            JwtToken token = JwtToken.getUnsignedToken("pluginAction", item);
            return FormValidation.ok((String)("JWT Token: \n" + token.claim.toString(4)));
        }

        @POST
        public FormValidation doRefreshCredentialSupplier(@AncestorInPath Item item) throws IOException, ServletException {
            String error = this.doValidateIdentityFormatField();
            if (error.length() != 0) {
                return FormValidation.error((String)error);
            }
            if (item != null) {
                String key = String.valueOf(item.hashCode());
                if (ConjurCredentialStore.getAllStores().containsKey(key)) {
                    LOGGER.log(Level.FINE, "Resetting Credential Supplier : {0},{1},{2}", new Object[]{item.getClass().getName(), item, item.hashCode()});
                    Supplier<Collection<StandardCredentials>> supplier = ConjurCredentialProvider.memoizeWithExpiration(CredentialsSupplier.standard((ModelObject)item), Duration.ofSeconds(120L));
                    ConjurCredentialProvider.getAllCredentialSuppliers().put(key, supplier);
                }
                return FormValidation.ok((String)"Refreshed");
            }
            return FormValidation.ok();
        }

        private String doValidateIdentityFormatField() {
            GlobalConjurConfiguration globalConfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
            String errorMsg = "";
            if (globalConfig != null && !globalConfig.getEnableIdentityFormatFieldsFromToken().booleanValue()) {
                LOGGER.log(Level.FINE, "Simplified JWT is disabled.");
                List<String> identityFields = Arrays.asList(globalConfig.getIdentityFormatFieldsFromToken().split(","));
                LOGGER.log(Level.FINE, "IdentityFields value >>" + identityFields);
                if (!(identityFields.contains("jenkins_full_name") || identityFields.contains("jenkins_parent_full_name") && identityFields.contains("jenkins_name"))) {
                    errorMsg = "Invalid configuration on conjur jenkins plugin. Ensure Identity format fields are configured correctly.";
                }
            }
            LOGGER.log(Level.FINE, "Returning error Msg" + errorMsg);
            return errorMsg;
        }
    }
}

