/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.api;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import okhttp3.OkHttpClient;
import org.acegisecurity.Authentication;
import org.conjur.jenkins.configuration.ConjurConfiguration;

public class ConjurAPIUtils {
    private static final Logger LOGGER = Logger.getLogger(ConjurAPIUtils.class.getName());

    static synchronized CertificateCredentials certificateFromConfiguration(ConjurConfiguration configuration) {
        LOGGER.log(Level.FINE, "Start of certificateFromConfiguration()");
        CertificateCredentials certificate = null;
        if (configuration.getCertificateCredentialID() == null) {
            LOGGER.log(Level.FINE, "Return null, as CertificationID is null");
            return null;
        }
        certificate = (CertificateCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(CertificateCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)configuration.getCertificateCredentialID()));
        LOGGER.log(Level.FINE, "Return CertificateCredential for CertificationCredentialID");
        return certificate;
    }

    static synchronized OkHttpClient httpClientWithCertificate(CertificateCredentials certificate) {
        LOGGER.log(Level.FINE, "Start of httpClientWithCertificate()");
        OkHttpClient client = null;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(certificate.getKeyStore(), certificate.getPassword().getPlainText().toCharArray());
            KeyManager[] kms = kmf.getKeyManagers();
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, null);
            Enumeration<String> e = certificate.getKeyStore().aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                trustStore.setCertificateEntry(alias, certificate.getKeyStore().getCertificate(alias));
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            SSLContext sslContext = null;
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kms, tms, new SecureRandom());
            client = new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tms[0]).build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error configuring server certificates.", e);
        }
        LOGGER.log(Level.FINE, "End of httpClientWithCertificate()");
        return client;
    }

    public static synchronized OkHttpClient getHttpClient(ConjurConfiguration configuration) {
        LOGGER.log(Level.FINE, "Start of getHttpClient()");
        CertificateCredentials certificate = ConjurAPIUtils.certificateFromConfiguration(configuration);
        if (certificate != null) {
            return ConjurAPIUtils.httpClientWithCertificate(certificate);
        }
        LOGGER.log(Level.FINE, "End of getHttpClient()");
        return new OkHttpClient.Builder().build();
    }
}

