/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.api;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.security.ACL;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.acegisecurity.Authentication;
import org.conjur.jenkins.configuration.ConjurConfiguration;
import org.conjur.jenkins.configuration.ConjurJITJobProperty;
import org.conjur.jenkins.configuration.FolderConjurConfiguration;
import org.conjur.jenkins.configuration.GlobalConjurConfiguration;
import org.conjur.jenkins.jwtauth.impl.JwtToken;

public class ConjurAPI {
    private static final Logger LOGGER = Logger.getLogger(ConjurAPI.class.getName());

    private static void defaultToEnvironment(ConjurAuthnInfo conjurAuthn) {
        LOGGER.log(Level.FINE, "Start of defaultToEnvironment()");
        Map<String, String> env = System.getenv();
        if (conjurAuthn.applianceUrl == null && env.containsKey("CONJUR_APPLIANCE_URL")) {
            conjurAuthn.applianceUrl = env.get("CONJUR_APPLIANCE_URL");
        }
        if (conjurAuthn.account == null && env.containsKey("CONJUR_ACCOUNT")) {
            conjurAuthn.account = env.get("CONJUR_ACCOUNT");
        }
        if (conjurAuthn.login == null && env.containsKey("CONJUR_AUTHN_LOGIN")) {
            conjurAuthn.login = env.get("CONJUR_AUTHN_LOGIN");
        }
        if (conjurAuthn.apiKey == null && env.containsKey("CONJUR_AUTHN_API_KEY")) {
            conjurAuthn.apiKey = env.get("CONJUR_AUTHN_API_KEY");
        }
        LOGGER.log(Level.FINE, "End of defaultToEnvironment()");
    }

    @SuppressFBWarnings
    public static String getAuthorizationToken(OkHttpClient client, ConjurConfiguration configuration, ModelObject context) throws IOException {
        LOGGER.log(Level.FINE, "Start of getAuthorizationToken()");
        LOGGER.log(Level.INFO, "getAuthorizationToken input paramsClient:" + client + "Configuration:" + configuration);
        String resultingToken = null;
        List availableCredentials = null;
        availableCredentials = CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        if (context != null) {
            if (context instanceof Run) {
                availableCredentials.addAll(CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (Item)((Run)context).getParent(), (Authentication)ACL.SYSTEM, Collections.emptyList()));
            } else if (context instanceof AbstractItem) {
                availableCredentials.addAll(CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (Item)((AbstractItem)context), (Authentication)ACL.SYSTEM, Collections.emptyList()));
            }
        }
        ConjurAuthnInfo conjurAuthn = ConjurAPI.getConjurAuthnInfo(configuration, availableCredentials, context);
        GlobalConjurConfiguration globalConfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
        if (globalConfig != null) {
            ConjurConfiguration globalConjurConfig = globalConfig.getConjurConfiguration();
            if (conjurAuthn.account == null || conjurAuthn.account.isEmpty()) {
                conjurAuthn.account = globalConjurConfig.getAccount();
            }
            if (conjurAuthn.applianceUrl == null || conjurAuthn.applianceUrl.isEmpty()) {
                conjurAuthn.applianceUrl = globalConjurConfig.getApplianceURL();
            }
        }
        if (globalConfig != null && globalConfig.getEnableJWKS().booleanValue()) {
            LOGGER.log(Level.FINE, "JWT is enabled.");
            if (!globalConfig.getEnableIdentityFormatFieldsFromToken().booleanValue()) {
                LOGGER.log(Level.FINE, "Simplified JWT is disabled.");
                List<String> identityFields = Arrays.asList(globalConfig.getIdentityFormatFieldsFromToken().split(","));
                if (!(identityFields.contains("jenkins_full_name") || identityFields.contains("jenkins_parent_full_name") && identityFields.contains("jenkins_name"))) {
                    throw new RuntimeException("Invalid configuration on conjur jenkins plugin. Ensure Identity format fields are configured correctly.");
                }
            }
        }
        Request request = null;
        if (conjurAuthn.login != null && conjurAuthn.apiKey != null) {
            LOGGER.log(Level.FINE, "Creating authentication request for API Key authentication with Conjur");
            request = new Request.Builder().url(String.format("%s/%s/%s/%s/authenticate", conjurAuthn.applianceUrl, conjurAuthn.authnPath, conjurAuthn.account, URLEncoder.encode(conjurAuthn.login, "utf-8"))).post(RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)conjurAuthn.apiKey)).build();
        } else if (conjurAuthn.authnPath != null && conjurAuthn.apiKey != null) {
            LOGGER.log(Level.FINE, "Creating authentication request for JWT authentication with Conjur");
            String authnPath = conjurAuthn.authnPath.indexOf("/") == -1 ? "authn-jwt/" + conjurAuthn.authnPath : conjurAuthn.authnPath;
            LOGGER.log(Level.FINE, "Authenticating with Conjur (JWT) authnPath={0}", authnPath);
            request = new Request.Builder().url(String.format("%s/%s/%s/authenticate", conjurAuthn.applianceUrl, authnPath, conjurAuthn.account)).post(RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)conjurAuthn.apiKey)).build();
        }
        if (request != null) {
            Response response = client.newCall(request).execute();
            resultingToken = Base64.getEncoder().withoutPadding().encodeToString(response.body().string().getBytes("UTF-8"));
            LOGGER.log(Level.FINEST, () -> "Conjur Authenticate response " + response.code() + " - " + response.message());
            if (response.code() != 200) {
                throw new IOException("Error authenticating to Conjur [" + response.code() + " - " + response.message() + "\n" + resultingToken);
            }
        } else {
            LOGGER.log(Level.FINE, "Failed to authenticate with conjur server");
        }
        return resultingToken;
    }

    public static ConjurAuthnInfo getConjurAuthnInfo(ConjurConfiguration configuration, List<UsernamePasswordCredentials> availableCredentials, ModelObject context) {
        LOGGER.log(Level.FINE, "Start of getConjurAuthnInfo()");
        ConjurAuthnInfo conjurAuthn = new ConjurAuthnInfo();
        if (configuration != null) {
            String account;
            String applianceUrl;
            if (availableCredentials != null) {
                ConjurAPI.initializeWithCredential(conjurAuthn, configuration.getCredentialID(), availableCredentials);
            }
            if ((applianceUrl = configuration.getApplianceURL()) != null && !applianceUrl.isEmpty()) {
                conjurAuthn.applianceUrl = applianceUrl;
            }
            if ((account = configuration.getAccount()) != null && !account.isEmpty()) {
                conjurAuthn.account = account;
            }
            conjurAuthn.authnPath = "authn";
        }
        LOGGER.log(Level.FINE, "getConjurAuthnInfo() calling defaultToEnvironment");
        ConjurAPI.defaultToEnvironment(conjurAuthn);
        LOGGER.log(Level.FINE, "Check for Just-In-time Credential Access if no login and apikey {0}", conjurAuthn);
        if (conjurAuthn.login == null && conjurAuthn.apiKey == null && context != null) {
            ConjurAPI.setConjurAuthnForJITCredentialAccess(context, conjurAuthn);
        }
        LOGGER.log(Level.FINE, "End of getConjurAuthnInfo()");
        return conjurAuthn;
    }

    private static void setConjurAuthnForJITCredentialAccess(ModelObject context, ConjurAuthnInfo conjurAuthn) {
        LOGGER.log(Level.FINE, "Start of setConjurAuthnForJITCredentialAccess()");
        String token = JwtToken.getToken(context);
        GlobalConjurConfiguration globalconfig = (GlobalConjurConfiguration)GlobalConfiguration.all().get(GlobalConjurConfiguration.class);
        if (token != null && globalconfig != null) {
            conjurAuthn.login = null;
            conjurAuthn.authnPath = globalconfig.getAuthWebServiceId();
            conjurAuthn.apiKey = "jwt=" + token;
        }
        LOGGER.log(Level.FINE, "End of setConjurAuthnForJITCredentialAccess()");
    }

    @SuppressFBWarnings
    public static String getSecret(OkHttpClient client, ConjurConfiguration configuration, String authToken, String variablePath) throws IOException {
        LOGGER.log(Level.FINE, "Start of getSecret()");
        ConjurAuthnInfo conjurAuthn = ConjurAPI.getConjurAuthnInfo(configuration, null, null);
        LOGGER.log(Level.FINEST, "Fetching secret from Conjur Server");
        Request request = new Request.Builder().url(String.format("%s/secrets/%s/variable/%s", conjurAuthn.applianceUrl, conjurAuthn.account, variablePath)).get().addHeader("Authorization", "Token token=\"" + authToken + "\"").build();
        Response response = client.newCall(request).execute();
        String result = response.body().string();
        LOGGER.log(Level.FINEST, () -> "Fetch secret [" + variablePath + "] from Conjur response " + response.code() + " - " + response.message());
        if (response.code() != 200) {
            throw new IOException("Error fetching secret from Conjur [" + response.code() + " - " + response.message() + "\n" + result);
        }
        LOGGER.log(Level.FINE, "End of getSecret()");
        return result;
    }

    public static ConjurConfiguration logConjurConfiguration(ConjurConfiguration conjurConfiguration) {
        LOGGER.log(Level.FINE, "Start of logConjurConfiguration()");
        if (conjurConfiguration != null) {
            LOGGER.log(Level.FINEST, "Conjur configuration provided");
            LOGGER.log(Level.FINEST, "Conjur Configuration Appliance Url:{0} ", conjurConfiguration.getApplianceURL());
            LOGGER.log(Level.FINEST, "Conjur Configuration Account: {0}", conjurConfiguration.getAccount());
            LOGGER.log(Level.FINEST, "Conjur Configuration credential ID:{0} ", conjurConfiguration.getCredentialID());
        }
        LOGGER.log(Level.FINE, "End of logConjurConfiguration()");
        return conjurConfiguration;
    }

    private static void initializeWithCredential(ConjurAuthnInfo conjurAuthn, String credentialID, List<UsernamePasswordCredentials> availableCredentials) {
        LOGGER.log(Level.FINE, "Start of initializeWithCredential()");
        if (credentialID != null && !credentialID.isEmpty()) {
            LOGGER.log(Level.FINEST, "Retrieving Conjur credential stored in Jenkins");
            UsernamePasswordCredentials credential = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull(availableCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialID));
            if (credential != null) {
                conjurAuthn.login = credential.getUsername();
                conjurAuthn.apiKey = credential.getPassword().getPlainText();
            }
        }
        LOGGER.log(Level.FINE, "End of initializeWithCredential()");
    }

    public static ConjurConfiguration getConfigurationFromContext(ModelObject context, ModelObject storeContext) {
        LOGGER.log(Level.FINE, "Start of getConfigurationFromContext()");
        ModelObject effectiveContext = context != null ? context : storeContext;
        Item contextObject = null;
        ConjurJITJobProperty conjurJobConfig = null;
        if (effectiveContext instanceof Run) {
            LOGGER.log(Level.FINE, "getConfigurationFromContext():instanceOf Run");
            Run run = (Run)effectiveContext;
            conjurJobConfig = (ConjurJITJobProperty)run.getParent().getProperty(ConjurJITJobProperty.class);
            contextObject = run.getParent();
        } else if (effectiveContext instanceof AbstractItem) {
            LOGGER.log(Level.FINE, "getConfigurationFromContext():instanceOf AbstractItem");
            contextObject = (Item)effectiveContext;
        }
        ConjurConfiguration conjurConfig = GlobalConjurConfiguration.get().getConjurConfiguration();
        if (effectiveContext == null) {
            LOGGER.log(Level.FINE, "getConfigurationFromContext():Context null,logging the configuration");
            return ConjurAPI.logConjurConfiguration(conjurConfig);
        }
        if (conjurJobConfig != null && !conjurJobConfig.getInheritFromParent().booleanValue()) {
            LOGGER.log(Level.FINE, "getConfigurationFromContext():Configuration from Job and inheritedParent");
            return ConjurAPI.logConjurConfiguration(conjurJobConfig.getConjurConfiguration());
        }
        ConjurConfiguration inheritedConfig = ConjurAPI.inheritedConjurConfiguration(contextObject);
        if (inheritedConfig != null) {
            return ConjurAPI.logConjurConfiguration(inheritedConfig);
        }
        LOGGER.log(Level.FINE, "End of getConfigurationFromContext()");
        return ConjurAPI.logConjurConfiguration(conjurConfig);
    }

    private static ConjurConfiguration inheritedConjurConfiguration(Item job) {
        ItemGroup g;
        LOGGER.log(Level.FINE, "Start of inheritedConjurConfiguration()");
        ItemGroup itemGroup = g = job != null ? job.getParent() : null;
        while (g instanceof AbstractFolder) {
            FolderConjurConfiguration fconf = (FolderConjurConfiguration)((AbstractFolder)g).getProperties().get(FolderConjurConfiguration.class);
            if (fconf != null && !fconf.getInheritFromParent().booleanValue()) {
                return fconf.getConjurConfiguration();
            }
            g = ((AbstractFolder)g).getParent();
        }
        LOGGER.log(Level.FINE, "End of inheritedConjurConfiguration()");
        return null;
    }

    private ConjurAPI() {
    }

    public static class ConjurAuthnInfo {
        public String applianceUrl;
        public String authnPath;
        public String account;
        public String login;
        public String apiKey;
    }
}

