/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.jenkins;

import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import net.masterthought.cucumber.sorting.SortingMethod;
import net.masterthought.jenkins.Messages;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class CucumberReportDescriptor
extends BuildStepDescriptor<Publisher> {
    public String getDisplayName() {
        return Messages.Plugin_DisplayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    @POST
    public ListBoxModel doFillBuildStatusItems() {
        return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option(Messages.BuildStatus_unchanged(), "UNCHANGED"), new ListBoxModel.Option(Messages.BuildStatus_FAILURE(), Result.FAILURE.toString()), new ListBoxModel.Option(Messages.BuildStatus_UNSTABLE(), Result.UNSTABLE.toString())});
    }

    @POST
    public FormValidation doCheckTrendsLimit(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidInteger(value);
    }

    @POST
    public FormValidation doCheckFailedStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidInteger(value);
    }

    @POST
    public FormValidation doCheckSkippedStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidInteger(value);
    }

    @POST
    public FormValidation doCheckPendingStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidInteger(value);
    }

    @POST
    public FormValidation doCheckUndefinedStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidInteger(value);
    }

    @POST
    public FormValidation doCheckFailedScenariosNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidInteger(value);
    }

    @POST
    public FormValidation doCheckFailedFeaturesNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidInteger(value);
    }

    private static FormValidation isValidInteger(String value) {
        try {
            int intValue = Integer.parseInt(value);
            if (intValue == -1) {
                return FormValidation.warning((String)Messages.Configuration_skipValidation());
            }
            if (intValue >= 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.Configuration_notValidNumber());
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.Configuration_notValidInteger());
        }
    }

    @POST
    public FormValidation doCheckFailedStepsPercentage(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidPercentage(value);
    }

    @POST
    public FormValidation doCheckSkippedStepsPercentage(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidPercentage(value);
    }

    @POST
    public FormValidation doCheckPendingStepsPercentage(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidPercentage(value);
    }

    @POST
    public FormValidation doCheckUndefinedStepsPercentage(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidPercentage(value);
    }

    @POST
    public FormValidation doCheckFailedScenariosPercentage(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidPercentage(value);
    }

    @POST
    public FormValidation doCheckFailedFeaturesPercentage(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidPercentage(value);
    }

    private static FormValidation isValidPercentage(String value) {
        try {
            double doubleValue = Double.parseDouble(value);
            if (doubleValue >= 0.0 && doubleValue <= 100.0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.Configuration_notValidInteger());
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.Configuration_notValidPercentage());
        }
    }

    @POST
    public ListBoxModel doFillSortingMethodItems() {
        return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option(Messages.SortingMethod_ALPHABETICAL(), SortingMethod.ALPHABETICAL.name()), new ListBoxModel.Option(Messages.SortingMethod_NATURAL(), SortingMethod.NATURAL.name())});
    }
}

