/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins.workflow;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.snyk.jenkins.Severity;
import io.snyk.jenkins.SnykContext;
import io.snyk.jenkins.SnykStepBuilder;
import io.snyk.jenkins.SnykStepFlow;
import io.snyk.jenkins.config.SnykConfig;
import io.snyk.jenkins.exception.SnykErrorException;
import io.snyk.jenkins.exception.SnykIssueException;
import io.snyk.jenkins.tools.SnykInstallation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SnykSecurityStep
extends Step
implements SnykConfig {
    private boolean failOnIssues = true;
    private boolean failOnError = true;
    private boolean monitorProjectOnBuild = true;
    private Severity severity = Severity.LOW;
    private String snykTokenId;
    private String targetFile;
    private String organisation;
    private String projectName;
    private String snykInstallation;
    private String additionalArguments;

    @DataBoundConstructor
    public SnykSecurityStep() {
    }

    @Override
    public boolean isFailOnIssues() {
        return this.failOnIssues;
    }

    @DataBoundSetter
    public void setFailOnIssues(boolean failOnIssues) {
        this.failOnIssues = failOnIssues;
    }

    @Override
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean isMonitorProjectOnBuild() {
        return this.monitorProjectOnBuild;
    }

    @DataBoundSetter
    public void setMonitorProjectOnBuild(boolean monitorProjectOnBuild) {
        this.monitorProjectOnBuild = monitorProjectOnBuild;
    }

    @Override
    public String getSeverity() {
        return this.severity != null ? this.severity.getSeverity() : null;
    }

    @DataBoundSetter
    public void setSeverity(String severity) {
        this.severity = Severity.getIfPresent(severity);
    }

    @Override
    public String getSnykTokenId() {
        return this.snykTokenId;
    }

    @DataBoundSetter
    public void setSnykTokenId(String snykTokenId) {
        this.snykTokenId = snykTokenId;
    }

    @Override
    public String getTargetFile() {
        return this.targetFile;
    }

    @DataBoundSetter
    public void setTargetFile(@CheckForNull String targetFile) {
        this.targetFile = Util.fixEmptyAndTrim((String)targetFile);
    }

    @Override
    public String getOrganisation() {
        return this.organisation;
    }

    @DataBoundSetter
    public void setOrganisation(@CheckForNull String organisation) {
        this.organisation = Util.fixEmptyAndTrim((String)organisation);
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(@CheckForNull String projectName) {
        this.projectName = Util.fixEmptyAndTrim((String)projectName);
    }

    @Override
    public String getSnykInstallation() {
        return this.snykInstallation;
    }

    @DataBoundSetter
    public void setSnykInstallation(String snykInstallation) {
        this.snykInstallation = snykInstallation;
    }

    @Override
    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @DataBoundSetter
    public void setAdditionalArguments(@CheckForNull String additionalArguments) {
        this.additionalArguments = Util.fixEmptyAndTrim((String)additionalArguments);
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient SnykConfig config;

        public Execution(@Nonnull SnykConfig config, @Nonnull StepContext context) {
            super(context);
            this.config = config;
        }

        protected Void run() throws SnykIssueException, SnykErrorException {
            SnykStepFlow.perform(this.config, () -> SnykContext.forPipelineProject(this.getContext()));
            return null;
        }
    }

    @Extension
    @Symbol(value={"snykSecurity"})
    public static class SnykSecurityStepDescriptor
    extends StepDescriptor {
        private final SnykStepBuilder.SnykStepBuilderDescriptor builderDescriptor = new SnykStepBuilder.SnykStepBuilderDescriptor();

        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(EnvVars.class, FilePath.class, Launcher.class, Run.class, TaskListener.class));
        }

        public String getFunctionName() {
            return "snykSecurity";
        }

        @Nonnull
        public String getDisplayName() {
            return "Invoke Snyk Security task";
        }

        public String getConfigPage() {
            return this.getViewPage(SnykStepBuilder.class, "config.jelly");
        }

        public SnykInstallation[] getInstallations() {
            return this.builderDescriptor.getInstallations();
        }

        public boolean hasInstallationsAvailable() {
            return this.builderDescriptor.hasInstallationsAvailable();
        }

        public ListBoxModel doFillSeverityItems() {
            return this.builderDescriptor.doFillSeverityItems();
        }

        public ListBoxModel doFillSnykTokenIdItems(@AncestorInPath Item item, @QueryParameter String snykTokenId) {
            return this.builderDescriptor.doFillSnykTokenIdItems(item, snykTokenId);
        }

        public FormValidation doCheckSeverity(@QueryParameter String value, @QueryParameter String additionalArguments) {
            return this.builderDescriptor.doCheckSeverity(value, additionalArguments);
        }

        public FormValidation doCheckSnykTokenId(@AncestorInPath Item item, @QueryParameter String value) {
            return this.builderDescriptor.doCheckSnykTokenId(item, value);
        }

        public FormValidation doCheckTargetFile(@QueryParameter String value, @QueryParameter String additionalArguments) {
            return this.builderDescriptor.doCheckTargetFile(value, additionalArguments);
        }

        public FormValidation doCheckOrganisation(@QueryParameter String value, @QueryParameter String additionalArguments) {
            return this.builderDescriptor.doCheckOrganisation(value, additionalArguments);
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter String monitorProjectOnBuild, @QueryParameter String additionalArguments) {
            return this.builderDescriptor.doCheckProjectName(value, monitorProjectOnBuild, additionalArguments);
        }
    }
}

