/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins.tools.internal;

import io.snyk.jenkins.PluginMetadata;
import io.snyk.jenkins.tools.Platform;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class DownloadService {
    private static final String SNYK_DOWNLOAD_PRIMARY = "https://downloads.snyk.io/%s/%s/%s";
    private static final String SNYK_DOWNLOAD_SECONDARY = "https://static.snyk.io/%s/%s/%s";
    public static final List<String> SNYK_CLI_DOWNLOAD_URLS = Collections.unmodifiableList(Arrays.asList("https://downloads.snyk.io/%s/%s/%s", "https://static.snyk.io/%s/%s/%s"));

    private DownloadService() {
    }

    public static URL constructDownloadUrlForSnyk(@Nonnull String urlTemplate, @Nonnull String product, @Nonnull String version, @Nonnull Platform platform) throws IOException {
        URL urlNoUtm = product.equals("cli") ? new URL(String.format(urlTemplate, product, version, platform.snykWrapperFileName)) : new URL(String.format(urlTemplate, product, version, platform.snykToHtmlWrapperFileName));
        return new URL(urlNoUtm.toString() + "?utm_source=" + PluginMetadata.getIntegrationName());
    }
}

