/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins.tools;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.InstallSourceProperty;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.DescribableList;
import io.snyk.jenkins.SnykContext;
import io.snyk.jenkins.SnykStepBuilder;
import io.snyk.jenkins.tools.Platform;
import io.snyk.jenkins.tools.PlatformItem;
import io.snyk.jenkins.tools.SnykInstaller;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnykInstallation
extends ToolInstallation
implements EnvironmentSpecific<SnykInstallation>,
NodeSpecific<SnykInstallation> {
    private static final Logger LOG = LoggerFactory.getLogger(SnykInstallation.class);

    @DataBoundConstructor
    public SnykInstallation(@Nonnull String name, @Nullable String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public SnykInstallation forEnvironment(EnvVars environment) {
        return new SnykInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public SnykInstallation forNode(@Nonnull Node node, TaskListener log) throws IOException, InterruptedException {
        return new SnykInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public String getSnykExecutable(@Nonnull Launcher launcher) throws IOException, InterruptedException {
        return this.resolveExecutable(launcher, "snyk");
    }

    public String getReportExecutable(@Nonnull Launcher launcher) throws IOException, InterruptedException {
        return this.resolveExecutable(launcher, "snyk-to-html");
    }

    private String resolveExecutable(Launcher launcher, String executableName) throws IOException, InterruptedException {
        String home = Optional.ofNullable(this.getHome()).orElseThrow(() -> new RuntimeException("Failed to find Snyk Executable. Installation Home is not configured."));
        Platform platform = null;
        SnykStepBuilder.SnykStepBuilderDescriptor descriptor = (SnykStepBuilder.SnykStepBuilderDescriptor)Jenkins.get().getDescriptorByType(SnykStepBuilder.SnykStepBuilderDescriptor.class);
        SnykInstallation snykInstallation = Stream.of(descriptor.getInstallations()).filter(installation -> installation.getName().equals(this.getName())).findFirst().orElse(null);
        if (snykInstallation != null) {
            PlatformItem installerPlatform = this.getSnykInstallerPlatformIfDefined(snykInstallation);
            platform = PlatformItem.convert(installerPlatform);
        }
        return (String)Optional.ofNullable(launcher.getChannel()).orElseThrow(() -> new RuntimeException("Failed to find Snyk Executable. Build Node does not support channels.")).call((Callable)new ResolveExecutable(home, executableName, platform));
    }

    @Nonnull
    private PlatformItem getSnykInstallerPlatformIfDefined(SnykInstallation installation) {
        DescribableList properties = installation.getProperties();
        try {
            DescribableList installers;
            if (properties.size() == 1 && properties.get(0) instanceof InstallSourceProperty && (installers = ((InstallSourceProperty)properties.get((int)0)).installers).size() == 1 && installers.get(0) instanceof SnykInstaller) {
                return ((SnykInstaller)((Object)installers.get(0))).getPlatform();
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not read properties from Snyk installation", (Throwable)ex);
        }
        LOG.warn("Could not find defined installer architecture, will return 'AUTO'");
        return PlatformItem.AUTO;
    }

    public static SnykInstallation install(SnykContext context, String name) throws IOException, InterruptedException {
        Node node = Optional.ofNullable(context.getWorkspace().toComputer()).map(Computer::getNode).orElseThrow(() -> new RuntimeException("Failed to install Snyk. Snyk can only be installed on a Build Node."));
        SnykStepBuilder.SnykStepBuilderDescriptor descriptor = (SnykStepBuilder.SnykStepBuilderDescriptor)Jenkins.get().getDescriptorByType(SnykStepBuilder.SnykStepBuilderDescriptor.class);
        return Stream.of(descriptor.getInstallations()).filter(installation -> installation.getName().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("Failed to install Snyk. Installation named '" + name + "' was not found. Please make sure it's configured in Jenkins under Global Tool Configuration.")).forNode(node, context.getTaskListener()).forEnvironment(context.getEnvVars());
    }

    private static class ResolveExecutable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private static final Logger LOG = LoggerFactory.getLogger(ResolveExecutable.class);
        private final String home;
        private final String executableName;
        private final Platform executablePlatform;

        public ResolveExecutable(String home, String executableName, Platform executablePlatform) {
            this.home = home;
            this.executableName = executableName;
            this.executablePlatform = executablePlatform;
        }

        public String call() {
            Platform platform = this.executablePlatform;
            if (platform == null) {
                LOG.info("Installer architecture is not configured or use AUTO mode");
                platform = Platform.current();
            }
            LOG.info("'{}' platform will be used by resolving Snyk Executable", (Object)platform);
            String filename = "snyk".equals(this.executableName) ? platform.snykWrapperFileName : platform.snykToHtmlWrapperFileName;
            Path executable = Paths.get(this.home, new String[0]).resolve(filename).toAbsolutePath();
            if (!executable.toFile().exists()) {
                throw new RuntimeException("Failed to find Snyk Executable. Executable does not exist. (" + executable.toAbsolutePath() + ")");
            }
            return executable.toString();
        }
    }

    @Extension
    @Symbol(value={"snyk"})
    public static class SnykInstallationDescriptor
    extends ToolDescriptor<SnykInstallation> {
        @Nonnull
        public String getDisplayName() {
            return "Snyk";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new SnykInstaller(null, null, null, null));
        }

        public SnykInstallation[] getInstallations() {
            return ((SnykStepBuilder.SnykStepBuilderDescriptor)Jenkins.get().getDescriptorByType(SnykStepBuilder.SnykStepBuilderDescriptor.class)).getInstallations();
        }

        public void setInstallations(SnykInstallation ... installations) {
            ((SnykStepBuilder.SnykStepBuilderDescriptor)Jenkins.get().getDescriptorByType(SnykStepBuilder.SnykStepBuilderDescriptor.class)).setInstallations(installations);
        }
    }
}

