/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins.tools;

import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public enum Platform {
    LINUX("snyk-linux", "snyk-to-html-linux"),
    LINUX_ALPINE("snyk-alpine", "snyk-to-html-alpine"),
    MAC_OS("snyk-macos", "snyk-to-html-macos"),
    WINDOWS("snyk-win.exe", "snyk-to-html-win.exe");

    public final String snykWrapperFileName;
    public final String snykToHtmlWrapperFileName;

    private Platform(String snykWrapperFileName, String snykToHtmlWrapperFileName) {
        this.snykWrapperFileName = snykWrapperFileName;
        this.snykToHtmlWrapperFileName = snykToHtmlWrapperFileName;
    }

    @Nonnull
    public static Platform current() {
        return Platform.detect(System.getProperties());
    }

    @Nonnull
    private static Platform detect(@Nonnull Map<Object, Object> systemProperties) {
        String osName = ((String)systemProperties.get("os.name")).toLowerCase(Locale.ENGLISH);
        String osArch = ((String)systemProperties.get("os.arch")).toLowerCase(Locale.ENGLISH);
        if (osName.contains("linux")) {
            if (osArch.contains("amd64") || osArch.contains("86_64")) {
                return LINUX;
            }
            return LINUX_ALPINE;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx")) {
            return MAC_OS;
        }
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        throw new RuntimeException("Unsupported platform. (OS: " + osName + ", Arch: " + osArch + ")");
    }
}

