/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.snyk.jenkins.model.SnykTestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectMapperHelper {
    private static final JsonFactory JSON_FACTORY = new MappingJsonFactory();

    private ObjectMapperHelper() {
    }

    public static SnykTestResult unmarshallTestResult(String content) throws IOException {
        if (content == null || content.isEmpty()) {
            return null;
        }
        try (JsonParser parser = JSON_FACTORY.createParser(content);){
            JsonToken token = parser.nextToken();
            if (token == null) {
                SnykTestResult snykTestResult = null;
                return snykTestResult;
            }
            if (token == JsonToken.START_ARRAY) {
                ArrayList<SnykTestResult> testStatuses = new ArrayList<SnykTestResult>();
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    testStatuses.add(ObjectMapperHelper.readTestResult(parser));
                }
                SnykTestResult snykTestResult = ObjectMapperHelper.aggregateTestResults(testStatuses);
                return snykTestResult;
            }
            if (token == JsonToken.START_OBJECT) {
                SnykTestResult snykTestResult = ObjectMapperHelper.readTestResult(parser);
                return snykTestResult;
            }
            SnykTestResult snykTestResult = null;
            return snykTestResult;
        }
    }

    private static SnykTestResult readTestResult(JsonParser parser) throws IOException {
        SnykTestResult snykTestResult = new SnykTestResult();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            if ("ok".equals(fieldName)) {
                parser.nextToken();
                snykTestResult.ok = parser.getBooleanValue();
                continue;
            }
            if ("error".equals(fieldName)) {
                parser.nextToken();
                snykTestResult.error = parser.getText();
                continue;
            }
            if ("uniqueCount".equals(fieldName)) {
                parser.nextToken();
                snykTestResult.uniqueCount = parser.getIntValue();
                continue;
            }
            if ("dependencyCount".equals(fieldName)) {
                parser.nextToken();
                snykTestResult.dependencyCount = parser.getIntValue();
                continue;
            }
            parser.skipChildren();
        }
        return snykTestResult;
    }

    private static SnykTestResult aggregateTestResults(List<SnykTestResult> testResults) {
        SnykTestResult aggregatedTestResult = new SnykTestResult();
        testResults.forEach(entity -> {
            aggregatedTestResult.ok = aggregatedTestResult.ok && entity.ok;
            aggregatedTestResult.error = entity.error != null && !entity.error.isEmpty() ? String.join((CharSequence)". ", aggregatedTestResult.error, entity.error) : aggregatedTestResult.error;
            aggregatedTestResult.dependencyCount += entity.dependencyCount;
            aggregatedTestResult.uniqueCount += entity.uniqueCount;
        });
        return aggregatedTestResult;
    }
}

