/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins.credentials;

import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.Util;
import hudson.util.Secret;
import io.snyk.jenkins.SnykContext;
import java.util.Optional;
import javax.annotation.Nonnull;

@NameWith(value=NameProvider.class, priority=1)
public interface SnykApiToken
extends StandardCredentials {
    public static final String SNYK_TOKEN_ENV_KEY = "SNYK_TOKEN";

    @Nonnull
    public Secret getToken();

    public static String getToken(SnykContext context, String snykTokenId) {
        return (String)Optional.ofNullable(snykTokenId).map(Util::fixEmptyAndTrim).map(id -> Optional.ofNullable((SnykApiToken)CredentialsProvider.findCredentialById((String)id, SnykApiToken.class, context.getRun())).orElseThrow(() -> new RuntimeException("Snyk API token with Credential ID '" + snykTokenId + "' was not found."))).map(SnykApiToken::getToken).map(Secret::getPlainText).map(Util::fixEmptyAndTrim).map(Optional::of).orElseGet(() -> Optional.ofNullable((String)context.getEnvVars().get((Object)SNYK_TOKEN_ENV_KEY))).orElseThrow(() -> new RuntimeException("Snyk API token not provided. Please assign your credentials to 'snykTokenId' in your build configuration or assign the token to a 'SNYK_TOKEN' build environment variable"));
    }

    public static class NameProvider
    extends CredentialsNameProvider<SnykApiToken> {
        @Nonnull
        public String getName(@Nonnull SnykApiToken credentials) {
            String description = Util.fixEmptyAndTrim((String)credentials.getDescription());
            return description != null ? description : credentials.getId();
        }
    }
}

