/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.snyk.jenkins.Severity;
import io.snyk.jenkins.SnykContext;
import io.snyk.jenkins.SnykStepFlow;
import io.snyk.jenkins.config.SnykConfig;
import io.snyk.jenkins.credentials.SnykApiToken;
import io.snyk.jenkins.exception.SnykErrorException;
import io.snyk.jenkins.exception.SnykIssueException;
import io.snyk.jenkins.tools.SnykInstallation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnykStepBuilder
extends Builder
implements SimpleBuildStep,
SnykConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)SnykStepBuilder.class.getName());
    private boolean failOnIssues = true;
    private boolean failOnError = true;
    private boolean monitorProjectOnBuild = true;
    private Severity severity = Severity.LOW;
    private String snykTokenId;
    private String targetFile;
    private String organisation;
    private String projectName;
    private String snykInstallation;
    private String additionalArguments;

    @DataBoundConstructor
    public SnykStepBuilder() {
    }

    @Override
    public boolean isFailOnIssues() {
        return this.failOnIssues;
    }

    @DataBoundSetter
    public void setFailOnIssues(boolean failOnIssues) {
        this.failOnIssues = failOnIssues;
    }

    @Override
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean isMonitorProjectOnBuild() {
        return this.monitorProjectOnBuild;
    }

    @DataBoundSetter
    public void setMonitorProjectOnBuild(boolean monitorProjectOnBuild) {
        this.monitorProjectOnBuild = monitorProjectOnBuild;
    }

    @Override
    public String getSeverity() {
        return this.severity != null ? this.severity.getSeverity() : null;
    }

    @DataBoundSetter
    public void setSeverity(String severity) {
        this.severity = Severity.getIfPresent(severity);
    }

    @Override
    public String getSnykTokenId() {
        return this.snykTokenId;
    }

    @DataBoundSetter
    public void setSnykTokenId(String snykTokenId) {
        this.snykTokenId = snykTokenId;
    }

    @Override
    public String getTargetFile() {
        return this.targetFile;
    }

    @DataBoundSetter
    public void setTargetFile(@CheckForNull String targetFile) {
        this.targetFile = Util.fixEmptyAndTrim((String)targetFile);
    }

    @Override
    public String getOrganisation() {
        return this.organisation;
    }

    @DataBoundSetter
    public void setOrganisation(@CheckForNull String organisation) {
        this.organisation = Util.fixEmptyAndTrim((String)organisation);
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(@CheckForNull String projectName) {
        this.projectName = Util.fixEmptyAndTrim((String)projectName);
    }

    @Override
    public String getSnykInstallation() {
        return this.snykInstallation;
    }

    @DataBoundSetter
    public void setSnykInstallation(String snykInstallation) {
        this.snykInstallation = snykInstallation;
    }

    @Override
    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @DataBoundSetter
    public void setAdditionalArguments(@CheckForNull String additionalArguments) {
        this.additionalArguments = Util.fixEmptyAndTrim((String)additionalArguments);
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener log) throws SnykIssueException, SnykErrorException {
        SnykStepFlow.perform(this, () -> SnykContext.forFreestyleProject(build, workspace, launcher, log));
    }

    @Extension
    public static class SnykStepBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        private volatile SnykInstallation[] installations = new SnykInstallation[0];

        public SnykStepBuilderDescriptor() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return "Invoke Snyk Security task";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public SnykInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(SnykInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public boolean hasInstallationsAvailable() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Available Snyk installations: {}", (Object)Arrays.stream(this.installations).map(ToolInstallation::getName).collect(Collectors.joining(",", "[", "]")));
            }
            return this.installations.length > 0;
        }

        public ListBoxModel doFillSeverityItems() {
            ListBoxModel model = new ListBoxModel();
            Stream.of(Severity.values()).map(Severity::getSeverity).forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            return model;
        }

        public ListBoxModel doFillSnykTokenIdItems(@AncestorInPath Item item, @QueryParameter String snykTokenId) {
            Jenkins jenkins;
            StandardListBoxModel model = new StandardListBoxModel();
            if (item == null ? !(jenkins = Jenkins.get()).hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return model.includeCurrentValue(snykTokenId);
            }
            return model.includeEmptyValue().includeAs(ACL.SYSTEM, item, SnykApiToken.class).includeCurrentValue(snykTokenId);
        }

        public FormValidation doCheckSeverity(@QueryParameter String value, @QueryParameter String additionalArguments) {
            if (Util.fixEmptyAndTrim((String)value) == null || Util.fixEmptyAndTrim((String)additionalArguments) == null) {
                return FormValidation.ok();
            }
            if (additionalArguments.contains("--severity-threshold")) {
                return FormValidation.warning((String)"Option '--severity-threshold' is overridden in additional arguments text area below.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSnykTokenId(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.warningWithMarkup((String)"A Snyk API token is required. If you do not provide credentials, make sure to provide a <code>SNYK_TOKEN</code> build environment variable.");
            }
            if (null == CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(SnykApiToken.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)value), CredentialsMatchers.instanceOf(SnykApiToken.class)}))) {
                return FormValidation.error((String)"Cannot find currently selected Snyk API token.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTargetFile(@QueryParameter String value, @QueryParameter String additionalArguments) {
            if (Util.fixEmptyAndTrim((String)value) == null || Util.fixEmptyAndTrim((String)additionalArguments) == null) {
                return FormValidation.ok();
            }
            if (additionalArguments.contains("--file")) {
                return FormValidation.warning((String)"Option '--file' is overridden in additional arguments text area below.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrganisation(@QueryParameter String value, @QueryParameter String additionalArguments) {
            if (Util.fixEmptyAndTrim((String)value) == null || Util.fixEmptyAndTrim((String)additionalArguments) == null) {
                return FormValidation.ok();
            }
            if (additionalArguments.contains("--org")) {
                return FormValidation.warning((String)"Option '--org' is overridden in additional arguments text area below.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter String monitorProjectOnBuild, @QueryParameter String additionalArguments) {
            if (Util.fixEmptyAndTrim((String)value) == null || Util.fixEmptyAndTrim((String)monitorProjectOnBuild) == null) {
                return FormValidation.ok();
            }
            ArrayList<FormValidation> findings = new ArrayList<FormValidation>(2);
            if ("false".equals(Util.fixEmptyAndTrim((String)monitorProjectOnBuild))) {
                findings.add(FormValidation.warning((String)"Project name will be ignored, because the project is not monitored on build."));
            }
            if (Util.fixNull((String)additionalArguments).contains("--project-name")) {
                findings.add(FormValidation.warning((String)"Option '--project-name' is overridden in additional arguments text area below."));
            }
            return FormValidation.aggregate(findings);
        }
    }
}

