/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class SnykContext {
    private final FilePath workspace;
    private final Launcher launcher;
    private final EnvVars envVars;
    private final Run<?, ?> run;
    private final TaskListener taskListener;

    private SnykContext(FilePath workspace, Launcher launcher, EnvVars envVars, Run<?, ?> run, TaskListener taskListener) {
        this.workspace = workspace;
        this.launcher = launcher;
        this.envVars = envVars;
        this.run = run;
        this.taskListener = taskListener;
    }

    public FilePath getWorkspace() {
        return this.workspace;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public EnvVars getEnvVars() {
        return this.envVars;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public TaskListener getTaskListener() {
        return this.taskListener;
    }

    public PrintStream getLogger() {
        return this.taskListener.getLogger();
    }

    public static SnykContext forFreestyleProject(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        try {
            return new SnykContext(workspace, launcher, build.getEnvironment(listener), build, listener);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static SnykContext forPipelineProject(StepContext context) {
        try {
            TaskListener listener = Optional.ofNullable((TaskListener)context.get(TaskListener.class)).orElseThrow(() -> new RuntimeException("Required context parameter 'TaskListener' is missing."));
            EnvVars envVars = Optional.ofNullable((EnvVars)context.get(EnvVars.class)).orElseThrow(() -> new RuntimeException("Required context parameter 'EnvVars' is missing."));
            FilePath workspace = Optional.ofNullable((FilePath)context.get(FilePath.class)).orElseThrow(() -> new RuntimeException("Required context parameter 'FilePath' (workspace) is missing."));
            Launcher launcher = Optional.ofNullable((Launcher)context.get(Launcher.class)).orElseThrow(() -> new RuntimeException("Required context parameter 'Launcher' is missing."));
            Run build = Optional.ofNullable((Run)context.get(Run.class)).orElseThrow(() -> new RuntimeException("Required context parameter 'Run' is missing."));
            return new SnykContext(workspace, launcher, envVars, build, listener);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

