/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.jenkins;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomBuildToolPathCallable
implements FilePath.FileCallable<String> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)CustomBuildToolPathCallable.class.getName());
    private static final String TOOLS_DIRECTORY = "tools";

    CustomBuildToolPathCallable() {
    }

    public String invoke(File snykToolDirectory, VirtualChannel channel) {
        String string;
        block9: {
            String oldPath = System.getenv("PATH");
            String home = snykToolDirectory.getAbsolutePath();
            if (!home.contains(TOOLS_DIRECTORY)) {
                LOG.info("env.PATH will be not modified, because there are no configured global tools");
                return oldPath;
            }
            String toolsDirectory = home.substring(0, home.indexOf(TOOLS_DIRECTORY) - 1) + File.separator + TOOLS_DIRECTORY;
            Stream<Path> toolsSubDirectories = Files.walk(Paths.get(toolsDirectory, new String[0]), new FileVisitOption[0]);
            try {
                ArrayList toolsPaths = new ArrayList();
                toolsSubDirectories.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.toString().contains("SnykInstallation")).filter(path -> path.toString().endsWith("bin")).forEach(entry -> toolsPaths.add(StringUtils.chomp((String)entry.toAbsolutePath().toString())));
                String customBuildToolPath = String.join((CharSequence)File.pathSeparator, toolsPaths);
                string = oldPath + File.pathSeparator + customBuildToolPath;
                if (toolsSubDirectories == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (toolsSubDirectories != null) {
                        try {
                            toolsSubDirectories.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.error("Could not iterate sub-directories in tools directory", (Throwable)ex);
                    return oldPath;
                }
            }
            toolsSubDirectories.close();
        }
        return string;
    }

    public void checkRoles(RoleChecker roleChecker) {
    }
}

