/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.teamscale.jenkins.upload;

import eu.cqse.teamscale.jenkins.upload.TeamscaleUploadPluginResult;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
public class TeamscaleUploadPluginConfiguration
extends GlobalConfiguration {
    private TeamscaleUploadPluginResult resultNoReports = TeamscaleUploadPluginResult.IGNORE;
    private TeamscaleUploadPluginResult resultOnUploadFailure = TeamscaleUploadPluginResult.IGNORE;

    public static TeamscaleUploadPluginConfiguration get() {
        return (TeamscaleUploadPluginConfiguration)((Object)ExtensionList.lookupSingleton(TeamscaleUploadPluginConfiguration.class));
    }

    public TeamscaleUploadPluginConfiguration() {
        this.load();
    }

    public String getResultOnUploadFailure() {
        return this.resultOnUploadFailure.toString();
    }

    public TeamscaleUploadPluginResult getResultOnUploadFailureEnum() {
        return this.resultOnUploadFailure;
    }

    @DataBoundSetter
    public void setResultOnUploadFailure(String resultOnUploadFailure) {
        this.resultOnUploadFailure = TeamscaleUploadPluginResult.valueOf(resultOnUploadFailure);
        this.save();
    }

    @POST
    public ListBoxModel doFillResultOnUploadFailureItems() {
        return new ListBoxModel((Collection)Arrays.stream(TeamscaleUploadPluginResult.values()).map(e -> new ListBoxModel.Option(e.toString())).collect(Collectors.toList()));
    }

    @POST
    public FormValidation doCheckResultOnUploadFailure(@QueryParameter String value) {
        if (Arrays.stream(TeamscaleUploadPluginResult.values()).noneMatch(a -> a.name().equals(value))) {
            return FormValidation.error((String)"Please specify a correct result on upload failure.");
        }
        return FormValidation.ok();
    }

    public String getResultNoReports() {
        return this.resultNoReports.toString();
    }

    public TeamscaleUploadPluginResult getResultNoReportsEnum() {
        return this.resultNoReports;
    }

    @DataBoundSetter
    public void setResultNoReports(String resultOnNoReports) {
        this.resultNoReports = TeamscaleUploadPluginResult.valueOf(resultOnNoReports);
        this.save();
    }

    @POST
    public ListBoxModel doFillResultNoReportsItems() {
        return new ListBoxModel((Collection)Arrays.stream(TeamscaleUploadPluginResult.values()).map(e -> new ListBoxModel.Option(e.toString())).collect(Collectors.toList()));
    }

    @POST
    public FormValidation doCheckResultNoReports(@QueryParameter String value) {
        if (Arrays.stream(TeamscaleUploadPluginResult.values()).noneMatch(a -> a.name().equals(value))) {
            return FormValidation.error((String)"Please specify a correct result when no reports.");
        }
        return FormValidation.ok();
    }
}

