/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.monitoring;

public class NodeInfo {
    private String id;
    private String hostname;
    private String state;
    private String role;
    private String availability;
    private long memoryBytes;
    private long cpuNanos;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public long getMemoryBytes() {
        return this.memoryBytes;
    }

    public void setMemoryBytes(long memoryBytes) {
        this.memoryBytes = memoryBytes;
    }

    public long getCpuNanos() {
        return this.cpuNanos;
    }

    public void setCpuNanos(long cpuNanos) {
        this.cpuNanos = cpuNanos;
    }

    public double getCpuCores() {
        return (double)this.cpuNanos / 1.0E9;
    }

    public String getFormattedMemory() {
        if (this.memoryBytes < 1024L) {
            return this.memoryBytes + " B";
        }
        if (this.memoryBytes < 0x100000L) {
            return String.format("%.1f KB", (double)this.memoryBytes / 1024.0);
        }
        if (this.memoryBytes < 0x40000000L) {
            return String.format("%.1f MB", (double)this.memoryBytes / 1048576.0);
        }
        return String.format("%.1f GB", (double)this.memoryBytes / 1.073741824E9);
    }

    public String getStateClass() {
        if ("READY".equalsIgnoreCase(this.state)) {
            return "success";
        }
        if ("DOWN".equalsIgnoreCase(this.state)) {
            return "error";
        }
        return "warning";
    }

    public boolean isReady() {
        return "READY".equalsIgnoreCase(this.state);
    }

    public boolean isManager() {
        return "MANAGER".equalsIgnoreCase(this.role);
    }
}

