/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.RootAction;
import hudson.slaves.Cloud;
import io.jenkins.plugins.swarmcloud.SwarmAgent;
import io.jenkins.plugins.swarmcloud.SwarmAgentTemplate;
import io.jenkins.plugins.swarmcloud.SwarmCloud;
import io.jenkins.plugins.swarmcloud.monitoring.ClusterMonitor;
import io.jenkins.plugins.swarmcloud.monitoring.ClusterStatus;
import io.jenkins.plugins.swarmcloud.monitoring.SwarmAuditLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;
import org.kohsuke.stapler.verb.PUT;

@Extension
public class SwarmRestApi
implements RootAction {
    private static final String JSON_CONTENT_TYPE = "application/json;charset=UTF-8";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Swarm REST API";
    }

    public String getUrlName() {
        return "swarm-api";
    }

    @GET
    public void doClouds(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONArray clouds = new JSONArray();
        for (SwarmCloud cloud : this.getSwarmClouds()) {
            JSONObject c = new JSONObject();
            c.put("name", (Object)cloud.name);
            c.put("dockerHost", (Object)cloud.getDockerHost());
            c.put("maxConcurrentAgents", (Object)cloud.getMaxConcurrentAgents());
            c.put("currentAgents", (Object)cloud.countCurrentAgents());
            c.put("templateCount", (Object)cloud.getTemplates().size());
            clouds.add((Object)c);
        }
        this.writeJsonResponse(rsp, 200, clouds.toString());
    }

    @GET
    public void doCloud(StaplerRequest req, StaplerResponse rsp, @QueryParameter String name) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (name == null || name.isBlank()) {
            this.writeJsonError(rsp, 400, "Cloud name is required");
            return;
        }
        SwarmCloud cloud = this.findCloud(name);
        if (cloud == null) {
            this.writeJsonError(rsp, 404, "Cloud not found: " + name);
            return;
        }
        JSONObject result = new JSONObject();
        result.put("name", (Object)cloud.name);
        result.put("dockerHost", (Object)cloud.getDockerHost());
        result.put("jenkinsUrl", (Object)cloud.getJenkinsUrl());
        result.put("swarmNetwork", (Object)cloud.getSwarmNetwork());
        result.put("maxConcurrentAgents", (Object)cloud.getMaxConcurrentAgents());
        result.put("currentAgents", (Object)cloud.countCurrentAgents());
        result.put("canProvision", (Object)cloud.canProvision());
        JSONArray templates = new JSONArray();
        for (SwarmAgentTemplate template : cloud.getTemplates()) {
            templates.add((Object)this.templateToJson(template));
        }
        result.put("templates", (Object)templates);
        this.writeJsonResponse(rsp, 200, result.toString());
    }

    @GET
    public void doTemplates(StaplerRequest req, StaplerResponse rsp, @QueryParameter String cloud) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONArray templates = new JSONArray();
        if (cloud != null && !cloud.isBlank()) {
            SwarmCloud swarmCloud = this.findCloud(cloud);
            if (swarmCloud == null) {
                this.writeJsonError(rsp, 404, "Cloud not found: " + cloud);
                return;
            }
            for (SwarmAgentTemplate template : swarmCloud.getTemplates()) {
                JSONObject t = this.templateToJson(template);
                t.put("cloudName", (Object)swarmCloud.name);
                templates.add((Object)t);
            }
        } else {
            for (SwarmCloud swarmCloud : this.getSwarmClouds()) {
                for (SwarmAgentTemplate template : swarmCloud.getTemplates()) {
                    JSONObject t = this.templateToJson(template);
                    t.put("cloudName", (Object)swarmCloud.name);
                    templates.add((Object)t);
                }
            }
        }
        this.writeJsonResponse(rsp, 200, templates.toString());
    }

    @GET
    public void doAgents(StaplerRequest req, StaplerResponse rsp, @QueryParameter String cloud) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONArray agents = new JSONArray();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            for (Node node : jenkins.getNodes()) {
                if (!(node instanceof SwarmAgent)) continue;
                SwarmAgent agent = (SwarmAgent)node;
                if (cloud != null && !cloud.isBlank() && !cloud.equals(agent.getCloudName())) continue;
                JSONObject a = new JSONObject();
                a.put("name", (Object)agent.getNodeName());
                a.put("cloudName", (Object)agent.getCloudName());
                a.put("serviceId", (Object)agent.getServiceId());
                a.put("templateName", (Object)agent.getTemplateName());
                a.put("remoteFS", (Object)agent.getRemoteFS());
                a.put("numExecutors", (Object)agent.getNumExecutors());
                a.put("labelString", (Object)agent.getLabelString());
                Computer computer = agent.toComputer();
                if (computer != null) {
                    a.put("online", (Object)computer.isOnline());
                    a.put("idle", (Object)computer.isIdle());
                    a.put("connecting", (Object)computer.isConnecting());
                }
                agents.add((Object)a);
            }
        }
        this.writeJsonResponse(rsp, 200, agents.toString());
    }

    @GET
    public void doMetrics(StaplerRequest req, StaplerResponse rsp, @QueryParameter String cloud) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (cloud != null && !cloud.isBlank()) {
            ClusterStatus status = ClusterMonitor.getStatus(cloud);
            this.writeJsonResponse(rsp, 200, this.statusToJson(status).toString());
            return;
        }
        JSONObject result = new JSONObject();
        JSONArray clouds = new JSONArray();
        for (Map.Entry<String, ClusterStatus> entry : ClusterMonitor.getAllStatuses().entrySet()) {
            clouds.add((Object)this.statusToJson(entry.getValue()));
        }
        result.put("clouds", (Object)clouds);
        result.put("lastUpdate", (Object)ClusterMonitor.getLastUpdate());
        this.writeJsonResponse(rsp, 200, result.toString());
    }

    @POST
    public void doProvision(StaplerRequest req, StaplerResponse rsp, @QueryParameter String cloud, @QueryParameter String template) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (cloud == null || cloud.isBlank() || template == null || template.isBlank()) {
            this.writeJsonError(rsp, 400, "Cloud name and template name are required");
            return;
        }
        SwarmCloud swarmCloud = this.findCloud(cloud);
        if (swarmCloud == null) {
            this.writeJsonError(rsp, 404, "Cloud not found: " + cloud);
            return;
        }
        SwarmAgentTemplate tmpl = null;
        for (SwarmAgentTemplate t : swarmCloud.getTemplates()) {
            if (!t.getName().equals(template)) continue;
            tmpl = t;
            break;
        }
        if (tmpl == null) {
            this.writeJsonError(rsp, 404, "Template not found: " + template);
            return;
        }
        if (!swarmCloud.canProvision()) {
            this.writeJsonError(rsp, 400, "Cannot provision: max agents reached");
            return;
        }
        if (tmpl.getAvailableCapacity() <= 0) {
            this.writeJsonError(rsp, 400, "Cannot provision: template max instances reached");
            return;
        }
        try {
            String agentName = tmpl.generateAgentName();
            String serviceId = swarmCloud.getDockerClient().createService(agentName, tmpl, swarmCloud.getEffectiveJenkinsUrl(), swarmCloud.getSwarmNetwork());
            SwarmAgent agent = new SwarmAgent(agentName, tmpl, swarmCloud.name, serviceId);
            Jenkins.get().addNode((Node)agent);
            JSONObject result = new JSONObject();
            result.put("agentName", (Object)agentName);
            result.put("serviceId", (Object)serviceId);
            result.put("status", (Object)"provisioning");
            this.writeJsonResponse(rsp, 200, result.toString());
        }
        catch (IOException e) {
            this.writeJsonError(rsp, 500, "Failed to provision: " + e.getMessage());
        }
        catch (Descriptor.FormException e) {
            this.writeJsonError(rsp, 400, "Invalid configuration: " + e.getMessage());
        }
        catch (RuntimeException e) {
            this.writeJsonError(rsp, 500, "Unexpected error: " + e.getMessage());
        }
    }

    @PUT
    @POST
    public void doTemplate(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String newImage;
        JSONObject body;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = req.getReader();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            body = JSONObject.fromObject((Object)sb.toString());
        }
        catch (Exception e) {
            this.writeJsonError(rsp, 400, "Invalid JSON body: " + e.getMessage());
            return;
        }
        String cloudName = body.optString("cloud", null);
        String templateName = body.optString("template", null);
        if (cloudName == null || cloudName.isBlank() || templateName == null || templateName.isBlank()) {
            this.writeJsonError(rsp, 400, "Cloud name and template name are required");
            return;
        }
        SwarmCloud cloud = this.findCloud(cloudName);
        if (cloud == null) {
            this.writeJsonError(rsp, 404, "Cloud not found: " + cloudName);
            return;
        }
        SwarmAgentTemplate template = null;
        for (SwarmAgentTemplate t : cloud.getTemplates()) {
            if (!t.getName().equals(templateName)) continue;
            template = t;
            break;
        }
        if (template == null) {
            this.writeJsonError(rsp, 404, "Template not found: " + templateName);
            return;
        }
        boolean updated = false;
        if (body.has("image") && (newImage = body.getString("image")) != null && !newImage.isBlank()) {
            template.setImage(newImage);
            updated = true;
        }
        if (body.has("labelString")) {
            template.setLabelString(body.getString("labelString"));
            updated = true;
        }
        if (body.has("maxInstances")) {
            template.setMaxInstances(body.getInt("maxInstances"));
            updated = true;
        }
        if (body.has("cpuLimit")) {
            template.setCpuLimit(body.getString("cpuLimit"));
            updated = true;
        }
        if (body.has("memoryLimit")) {
            template.setMemoryLimit(body.getString("memoryLimit"));
            updated = true;
        }
        if (body.has("numExecutors")) {
            template.setNumExecutors(body.getInt("numExecutors"));
            updated = true;
        }
        if (body.has("remoteFs")) {
            template.setRemoteFs(body.getString("remoteFs"));
            updated = true;
        }
        if (!updated) {
            this.writeJsonError(rsp, 400, "No fields to update provided");
            return;
        }
        try {
            Jenkins.get().save();
        }
        catch (Exception e) {
            this.writeJsonError(rsp, 500, "Failed to save configuration: " + e.getMessage());
            return;
        }
        JSONObject result = new JSONObject();
        result.put("status", (Object)"updated");
        result.put("template", (Object)this.templateToJson(template));
        this.writeJsonResponse(rsp, 200, result.toString());
    }

    @GET
    public void doTemplateGet(StaplerRequest req, StaplerResponse rsp, @QueryParameter String cloud, @QueryParameter String name) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (cloud == null || cloud.isBlank() || name == null || name.isBlank()) {
            this.writeJsonError(rsp, 400, "Cloud name and template name are required");
            return;
        }
        SwarmCloud swarmCloud = this.findCloud(cloud);
        if (swarmCloud == null) {
            this.writeJsonError(rsp, 404, "Cloud not found: " + cloud);
            return;
        }
        for (SwarmAgentTemplate template : swarmCloud.getTemplates()) {
            if (!template.getName().equals(name)) continue;
            JSONObject result = this.templateToJson(template);
            result.put("cloudName", (Object)cloud);
            this.writeJsonResponse(rsp, 200, result.toString());
            return;
        }
        this.writeJsonError(rsp, 404, "Template not found: " + name);
    }

    private void writeJsonResponse(StaplerResponse rsp, int status, String json) throws IOException {
        rsp.setStatus(status);
        rsp.setContentType(JSON_CONTENT_TYPE);
        try (PrintWriter writer = rsp.getWriter();){
            writer.write(json);
        }
    }

    private void writeJsonError(StaplerResponse rsp, int status, String message) throws IOException {
        JSONObject error = new JSONObject();
        error.put("error", (Object)message);
        this.writeJsonResponse(rsp, status, error.toString());
    }

    @NonNull
    private List<SwarmCloud> getSwarmClouds() {
        ArrayList<SwarmCloud> clouds = new ArrayList<SwarmCloud>();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof SwarmCloud)) continue;
                clouds.add((SwarmCloud)cloud);
            }
        }
        return clouds;
    }

    private SwarmCloud findCloud(String name) {
        for (SwarmCloud cloud : this.getSwarmClouds()) {
            if (!cloud.name.equals(name)) continue;
            return cloud;
        }
        return null;
    }

    private JSONObject templateToJson(SwarmAgentTemplate template) {
        JSONObject t = new JSONObject();
        t.put("name", (Object)template.getName());
        t.put("image", (Object)template.getImage());
        t.put("labelString", (Object)template.getLabelString());
        t.put("remoteFs", (Object)template.getRemoteFs());
        t.put("numExecutors", (Object)template.getNumExecutors());
        t.put("maxInstances", (Object)template.getMaxInstances());
        t.put("currentInstances", (Object)template.getCurrentInstances());
        t.put("availableCapacity", (Object)template.getAvailableCapacity());
        t.put("cpuLimit", (Object)template.getCpuLimit());
        t.put("memoryLimit", (Object)template.getMemoryLimit());
        return t;
    }

    @GET
    public void doPrometheus(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Jenkins.get().checkPermission(Jenkins.READ);
        StringBuilder sb = new StringBuilder();
        sb.append("# HELP swarm_clouds_total Total number of configured Swarm clouds\n");
        sb.append("# TYPE swarm_clouds_total gauge\n");
        sb.append("swarm_clouds_total ").append(this.getSwarmClouds().size()).append("\n\n");
        long totalAgents = 0L;
        long totalProvisioned = 0L;
        for (SwarmCloud cloud : this.getSwarmClouds()) {
            String cloudName = this.sanitizeMetricLabel(cloud.name);
            ClusterStatus status = ClusterMonitor.getStatus(cloud.name);
            sb.append("# HELP swarm_cloud_healthy Whether the cloud is healthy (1) or not (0)\n");
            sb.append("# TYPE swarm_cloud_healthy gauge\n");
            sb.append("swarm_cloud_healthy{cloud=\"").append(cloudName).append("\"} ").append(status.isHealthy() ? 1 : 0).append("\n\n");
            sb.append("# HELP swarm_agents_max Maximum agents allowed for this cloud\n");
            sb.append("# TYPE swarm_agents_max gauge\n");
            sb.append("swarm_agents_max{cloud=\"").append(cloudName).append("\"} ").append(cloud.getMaxConcurrentAgents()).append("\n");
            sb.append("# HELP swarm_agents_current Current number of agents\n");
            sb.append("# TYPE swarm_agents_current gauge\n");
            sb.append("swarm_agents_current{cloud=\"").append(cloudName).append("\"} ").append(status.getCurrentAgents()).append("\n\n");
            totalAgents += (long)status.getCurrentAgents();
            sb.append("# HELP swarm_nodes_total Total nodes in the Swarm cluster\n");
            sb.append("# TYPE swarm_nodes_total gauge\n");
            sb.append("swarm_nodes_total{cloud=\"").append(cloudName).append("\"} ").append(status.getTotalNodes()).append("\n");
            sb.append("# HELP swarm_nodes_ready Ready nodes in the Swarm cluster\n");
            sb.append("# TYPE swarm_nodes_ready gauge\n");
            sb.append("swarm_nodes_ready{cloud=\"").append(cloudName).append("\"} ").append(status.getReadyNodes()).append("\n\n");
            sb.append("# HELP swarm_tasks_running Running tasks in the cluster\n");
            sb.append("# TYPE swarm_tasks_running gauge\n");
            sb.append("swarm_tasks_running{cloud=\"").append(cloudName).append("\"} ").append(status.getRunningTasks()).append("\n");
            sb.append("# HELP swarm_tasks_pending Pending tasks in the cluster\n");
            sb.append("# TYPE swarm_tasks_pending gauge\n");
            sb.append("swarm_tasks_pending{cloud=\"").append(cloudName).append("\"} ").append(status.getPendingTasks()).append("\n");
            sb.append("# HELP swarm_tasks_failed Failed tasks in the cluster\n");
            sb.append("# TYPE swarm_tasks_failed gauge\n");
            sb.append("swarm_tasks_failed{cloud=\"").append(cloudName).append("\"} ").append(status.getFailedTasks()).append("\n\n");
            sb.append("# HELP swarm_memory_total_bytes Total memory in the cluster\n");
            sb.append("# TYPE swarm_memory_total_bytes gauge\n");
            sb.append("swarm_memory_total_bytes{cloud=\"").append(cloudName).append("\"} ").append(status.getTotalMemory()).append("\n");
            sb.append("# HELP swarm_memory_used_bytes Used memory in the cluster\n");
            sb.append("# TYPE swarm_memory_used_bytes gauge\n");
            sb.append("swarm_memory_used_bytes{cloud=\"").append(cloudName).append("\"} ").append(status.getUsedMemory()).append("\n");
            sb.append("# HELP swarm_cpu_total Total CPU cores in the cluster\n");
            sb.append("# TYPE swarm_cpu_total gauge\n");
            sb.append("swarm_cpu_total{cloud=\"").append(cloudName).append("\"} ").append(String.format("%.2f", status.getTotalCpu())).append("\n");
            sb.append("# HELP swarm_cpu_used Used CPU cores in the cluster\n");
            sb.append("# TYPE swarm_cpu_used gauge\n");
            sb.append("swarm_cpu_used{cloud=\"").append(cloudName).append("\"} ").append(String.format("%.2f", status.getUsedCpu())).append("\n\n");
            sb.append("# HELP swarm_utilization_percent Agent utilization percentage\n");
            sb.append("# TYPE swarm_utilization_percent gauge\n");
            sb.append("swarm_utilization_percent{cloud=\"").append(cloudName).append("\"} ").append(String.format("%.2f", status.getUtilizationPercent())).append("\n\n");
            for (SwarmAgentTemplate template : cloud.getTemplates()) {
                String templateName = this.sanitizeMetricLabel(template.getName());
                sb.append("# HELP swarm_template_instances_max Max instances for template\n");
                sb.append("# TYPE swarm_template_instances_max gauge\n");
                sb.append("swarm_template_instances_max{cloud=\"").append(cloudName).append("\",template=\"").append(templateName).append("\"} ").append(template.getMaxInstances()).append("\n");
                sb.append("# HELP swarm_template_instances_current Current instances for template\n");
                sb.append("# TYPE swarm_template_instances_current gauge\n");
                sb.append("swarm_template_instances_current{cloud=\"").append(cloudName).append("\",template=\"").append(templateName).append("\"} ").append(template.getCurrentInstances()).append("\n");
                totalProvisioned += (long)template.getCurrentInstances();
            }
            sb.append("\n");
        }
        sb.append("# HELP swarm_agents_total_all Total agents across all clouds\n");
        sb.append("# TYPE swarm_agents_total_all gauge\n");
        sb.append("swarm_agents_total_all ").append(totalAgents).append("\n");
        rsp.setStatus(200);
        rsp.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (PrintWriter writer = rsp.getWriter();){
            writer.write(sb.toString());
        }
    }

    private String sanitizeMetricLabel(String value) {
        if (value == null) {
            return "unknown";
        }
        return value.replaceAll("[^a-zA-Z0-9_]", "_").replaceAll("_+", "_").replaceAll("^_|_$", "");
    }

    @GET
    public void doAudit(StaplerRequest req, StaplerResponse rsp, @QueryParameter String cloud, @QueryParameter(value="limit") Integer limitParam) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        int limit = limitParam != null && limitParam > 0 ? Math.min(limitParam, 500) : 100;
        List<SwarmAuditLog.AuditEntry> entries = cloud != null && !cloud.isBlank() ? SwarmAuditLog.getEntriesForCloud(cloud, limit) : SwarmAuditLog.getRecentEntries(limit);
        JSONArray result = new JSONArray();
        for (SwarmAuditLog.AuditEntry entry : entries) {
            JSONObject e = new JSONObject();
            e.put("timestamp", (Object)entry.getTimestamp());
            e.put("formattedTimestamp", (Object)entry.getFormattedTimestamp());
            e.put("event", (Object)entry.getEvent().name());
            e.put("cloudName", (Object)entry.getCloudName());
            e.put("templateName", (Object)entry.getTemplateName());
            e.put("agentName", (Object)entry.getAgentName());
            e.put("serviceId", (Object)entry.getServiceId());
            e.put("message", (Object)entry.getMessage());
            e.put("user", (Object)entry.getUser());
            result.add((Object)e);
        }
        this.writeJsonResponse(rsp, 200, result.toString());
    }

    private JSONObject statusToJson(ClusterStatus status) {
        JSONObject json = new JSONObject();
        json.put("cloudName", (Object)status.getCloudName());
        json.put("healthy", (Object)status.isHealthy());
        json.put("errorMessage", (Object)status.getErrorMessage());
        json.put("totalNodes", (Object)status.getTotalNodes());
        json.put("readyNodes", (Object)status.getReadyNodes());
        json.put("activeServices", (Object)status.getActiveServices());
        json.put("runningTasks", (Object)status.getRunningTasks());
        json.put("pendingTasks", (Object)status.getPendingTasks());
        json.put("failedTasks", (Object)status.getFailedTasks());
        json.put("maxAgents", (Object)status.getMaxAgents());
        json.put("currentAgents", (Object)status.getCurrentAgents());
        json.put("utilizationPercent", (Object)status.getUtilizationPercent());
        json.put("lastUpdate", (Object)status.getLastUpdate());
        return json;
    }
}

