/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.monitoring;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.swarmcloud.monitoring.NodeInfo;
import io.jenkins.plugins.swarmcloud.monitoring.ServiceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClusterStatus {
    private final String cloudName;
    private String swarmVersion;
    private int totalNodes;
    private int readyNodes;
    private int managerNodes;
    private long totalMemory;
    private long usedMemory;
    private long reservedMemory;
    private double totalCpu;
    private double usedCpu;
    private double reservedCpu;
    private int activeServices;
    private int runningTasks;
    private int pendingTasks;
    private int failedTasks;
    private int maxAgents;
    private int currentAgents;
    private int templateCount;
    private boolean healthy;
    private String errorMessage;
    private long lastUpdate;
    private final List<NodeInfo> nodes = new ArrayList<NodeInfo>();
    private final List<ServiceInfo> services = new ArrayList<ServiceInfo>();

    public ClusterStatus(@NonNull String cloudName) {
        this.cloudName = cloudName;
        this.lastUpdate = System.currentTimeMillis();
    }

    public static ClusterStatus error(String cloudName, String message) {
        ClusterStatus status = new ClusterStatus(cloudName);
        status.setHealthy(false);
        status.setErrorMessage(message);
        return status;
    }

    public static ClusterStatus unknown(String cloudName) {
        ClusterStatus status = new ClusterStatus(cloudName);
        status.setHealthy(false);
        status.setErrorMessage("Status not yet collected");
        return status;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String getSwarmVersion() {
        return this.swarmVersion;
    }

    public void setSwarmVersion(String swarmVersion) {
        this.swarmVersion = swarmVersion;
    }

    public int getTotalNodes() {
        return this.totalNodes;
    }

    public void setTotalNodes(int totalNodes) {
        this.totalNodes = totalNodes;
    }

    public int getReadyNodes() {
        return this.readyNodes;
    }

    public void setReadyNodes(int readyNodes) {
        this.readyNodes = readyNodes;
    }

    public int getManagerNodes() {
        return this.managerNodes;
    }

    public void setManagerNodes(int managerNodes) {
        this.managerNodes = managerNodes;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public void setUsedMemory(long usedMemory) {
        this.usedMemory = usedMemory;
    }

    public long getReservedMemory() {
        return this.reservedMemory;
    }

    public void setReservedMemory(long reservedMemory) {
        this.reservedMemory = reservedMemory;
    }

    public double getTotalCpu() {
        return this.totalCpu;
    }

    public void setTotalCpu(double totalCpu) {
        this.totalCpu = totalCpu;
    }

    public double getUsedCpu() {
        return this.usedCpu;
    }

    public void setUsedCpu(double usedCpu) {
        this.usedCpu = usedCpu;
    }

    public double getReservedCpu() {
        return this.reservedCpu;
    }

    public void setReservedCpu(double reservedCpu) {
        this.reservedCpu = reservedCpu;
    }

    public int getActiveServices() {
        return this.activeServices;
    }

    public void setActiveServices(int activeServices) {
        this.activeServices = activeServices;
    }

    public int getRunningTasks() {
        return this.runningTasks;
    }

    public void setRunningTasks(int runningTasks) {
        this.runningTasks = runningTasks;
    }

    public int getPendingTasks() {
        return this.pendingTasks;
    }

    public void setPendingTasks(int pendingTasks) {
        this.pendingTasks = pendingTasks;
    }

    public int getFailedTasks() {
        return this.failedTasks;
    }

    public void setFailedTasks(int failedTasks) {
        this.failedTasks = failedTasks;
    }

    public int getMaxAgents() {
        return this.maxAgents;
    }

    public void setMaxAgents(int maxAgents) {
        this.maxAgents = maxAgents;
    }

    public int getCurrentAgents() {
        return this.currentAgents;
    }

    public void setCurrentAgents(int currentAgents) {
        this.currentAgents = currentAgents;
    }

    public int getTemplateCount() {
        return this.templateCount;
    }

    public void setTemplateCount(int templateCount) {
        this.templateCount = templateCount;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public List<NodeInfo> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public void addNode(NodeInfo node) {
        this.nodes.add(node);
    }

    public List<ServiceInfo> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    public void addService(ServiceInfo service) {
        this.services.add(service);
    }

    public String getFormattedMemory() {
        return this.formatBytes(this.totalMemory);
    }

    public String getFormattedUsedMemory() {
        return this.formatBytes(this.usedMemory);
    }

    public String getFormattedReservedMemory() {
        return this.formatBytes(this.reservedMemory);
    }

    public String getFormattedTotalCpu() {
        return String.format("%.1f", this.totalCpu);
    }

    public String getFormattedUsedCpu() {
        return String.format("%.1f", this.usedCpu);
    }

    public double getMemoryUsagePercent() {
        if (this.totalMemory == 0L) {
            return 0.0;
        }
        return (double)this.usedMemory / (double)this.totalMemory * 100.0;
    }

    public double getMemoryReservedPercent() {
        if (this.totalMemory == 0L) {
            return 0.0;
        }
        return (double)this.reservedMemory / (double)this.totalMemory * 100.0;
    }

    public double getCpuUsagePercent() {
        if (this.totalCpu == 0.0) {
            return 0.0;
        }
        return this.usedCpu / this.totalCpu * 100.0;
    }

    public double getCpuReservedPercent() {
        if (this.totalCpu == 0.0) {
            return 0.0;
        }
        return this.reservedCpu / this.totalCpu * 100.0;
    }

    public int getAvailableCapacity() {
        return Math.max(0, this.maxAgents - this.currentAgents);
    }

    public double getUtilizationPercent() {
        if (this.maxAgents == 0) {
            return 0.0;
        }
        return (double)this.currentAgents / (double)this.maxAgents * 100.0;
    }

    public String getStatusClass() {
        if (!this.healthy) {
            return "error";
        }
        if (this.failedTasks > 0) {
            return "warning";
        }
        if (this.currentAgents >= this.maxAgents) {
            return "warning";
        }
        return "success";
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.1f GB", (double)bytes / 1.073741824E9);
    }
}

