/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SwarmSecretConfig
extends AbstractDescribableImpl<SwarmSecretConfig> {
    private final String secretName;
    private String targetPath;
    private String fileName;
    private String fileMode;
    private String uid;
    private String gid;
    private String credentialsId;

    @DataBoundConstructor
    public SwarmSecretConfig(@NonNull String secretName) {
        this.secretName = Util.fixEmptyAndTrim((String)secretName);
    }

    @NonNull
    public String getSecretName() {
        return this.secretName != null ? this.secretName : "";
    }

    @Nullable
    public String getTargetPath() {
        return this.targetPath;
    }

    @DataBoundSetter
    public void setTargetPath(String targetPath) {
        this.targetPath = Util.fixEmptyAndTrim((String)targetPath);
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @DataBoundSetter
    public void setFileName(String fileName) {
        this.fileName = Util.fixEmptyAndTrim((String)fileName);
    }

    @Nullable
    public String getFileMode() {
        return this.fileMode;
    }

    @DataBoundSetter
    public void setFileMode(String fileMode) {
        this.fileMode = Util.fixEmptyAndTrim((String)fileMode);
    }

    @Nullable
    public String getUid() {
        return this.uid;
    }

    @DataBoundSetter
    public void setUid(String uid) {
        this.uid = Util.fixEmptyAndTrim((String)uid);
    }

    @Nullable
    public String getGid() {
        return this.gid;
    }

    @DataBoundSetter
    public void setGid(String gid) {
        this.gid = Util.fixEmptyAndTrim((String)gid);
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    @NonNull
    public String getEffectiveTargetPath() {
        if (this.targetPath != null && !this.targetPath.isBlank()) {
            return this.targetPath;
        }
        return "/run/secrets/" + this.secretName;
    }

    @NonNull
    public String getEffectiveFileName() {
        if (this.fileName != null && !this.fileName.isBlank()) {
            return this.fileName;
        }
        return this.secretName;
    }

    @Nullable
    public Long getFileModeAsLong() {
        if (this.fileMode == null || this.fileMode.isBlank()) {
            return null;
        }
        try {
            return Long.parseLong(this.fileMode, 8);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean usesCredentials() {
        return this.credentialsId != null && !this.credentialsId.isBlank();
    }

    @Extension
    @Symbol(value={"swarmSecret"})
    public static class DescriptorImpl
    extends Descriptor<SwarmSecretConfig> {
        @NonNull
        public String getDisplayName() {
            return "Docker Swarm Secret";
        }

        @POST
        public FormValidation doCheckSecretName(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Secret name is required");
            }
            if (!value.matches("[a-zA-Z0-9_.-]+")) {
                return FormValidation.error((String)"Secret name can only contain letters, numbers, underscores, dots, and hyphens");
            }
            if (value.length() > 64) {
                return FormValidation.error((String)"Secret name must be 64 characters or less");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckFileMode(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            if (!value.matches("[0-7]{3,4}")) {
                return FormValidation.error((String)"File mode must be in octal format (e.g., 0400, 0644)");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTargetPath(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            if (!value.startsWith("/")) {
                return FormValidation.error((String)"Target path must be an absolute path");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            result.includeEmptyValue();
            result.includeMatchingAs(item instanceof Queue.Task ? ((Queue.Task)item).getDefaultAuthentication() : ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
            return result;
        }
    }
}

