/*
 * Decompiled with CFR 0.152.
 */
package com.simplifyqa.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.simplifyqa.model.ExecutionItems;
import com.simplifyqa.model.IExecution;
import com.simplifyqa.model.Metadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Execution
implements IExecution {
    private String _id;
    private int customerId;
    private boolean deleted;
    private int id;
    private int projectId;
    private String agentId;
    private boolean childExecution;
    private String cloudType;
    private String code;
    private String createdAt;
    private int createdBy;
    private String environmentType;
    private String executionCategory;
    private String executionOS;
    private String executionStyle;
    private String executionTime;
    private String executionType;
    private String executionTypeCode;
    private int executionTypeId;
    private String executionTypeName;
    private boolean fromAgent;
    private Map<String, Object> globalConfiguration;
    private int iterationId;
    private List<String> iterationsSelected;
    private String mode;
    private Integer moduleId;
    private Integer parentExecutionId;
    private int releaseId;
    private String result;
    private Map<String, Object> extraPreferences;
    private String status;
    private List<String> tags;
    private List<ExecutionItems> executionItems = new ArrayList<ExecutionItems>();
    private String type;
    private Integer userstoryId;
    private Metadata metadata;

    public Map<String, Object> getExtraPreferences() {
        return this.extraPreferences;
    }

    @Override
    public List<ExecutionItems> getExecutionItems() {
        return this.executionItems;
    }

    public void setExtraPreferences(Map<String, Object> extraPreferences) {
        this.extraPreferences = extraPreferences;
    }

    public Execution(IExecution data, Map<String, Object> options) {
        this._id = data.get_id();
        this.customerId = data.getCustomerId();
        this.deleted = data.isDeleted();
        this.id = data.getId();
        this.projectId = data.getProjectId();
        this.agentId = data.getAgentId();
        this.childExecution = data.isChildExecution();
        this.cloudType = data.getCloudType();
        this.code = data.getCode();
        this.createdAt = data.getCreatedAt();
        this.createdBy = data.getCreatedBy();
        this.environmentType = data.getEnvironmentType();
        this.executionCategory = data.getExecutionCategory();
        this.executionOS = data.getExecutionOS();
        this.executionStyle = data.getExecutionStyle();
        this.executionTime = data.getExecutionTime();
        this.executionType = data.getExecutionType();
        this.executionTypeCode = data.getExecutionTypeCode();
        this.executionTypeId = data.getExecutionTypeId();
        this.executionTypeName = data.getExecutionTypeName();
        this.fromAgent = data.isFromAgent();
        this.globalConfiguration = data.getGlobalConfiguration();
        this.iterationId = data.getIterationId();
        this.iterationsSelected = data.getIterationsSelected();
        this.mode = data.getMode();
        this.moduleId = data.getModuleId();
        this.parentExecutionId = data.getParentExecutionId();
        this.releaseId = data.getReleaseId();
        this.result = data.getResult();
        this.status = data.getStatus();
        this.tags = data.getTags();
        this.executionItems = data.getExecutionItems().stream().map(ExecutionItems::new).collect(Collectors.toList());
        this.type = data.getType();
        this.userstoryId = data.getUserstoryId();
        double threshold = options.containsKey("threshold") ? (Double)options.get("threshold") : Double.parseDouble(System.getenv().getOrDefault("INPUT_THRESHOLD", "100"));
        boolean verbose = options.containsKey("verbose") ? (Boolean)options.get("verbose") : Boolean.parseBoolean(System.getenv().getOrDefault("INPUT_VERBOSE", "false"));
        boolean isKilled = options.containsKey("isKilled") ? (Boolean)options.get("isKilled") : false;
        this.metadata = new Metadata(threshold, verbose, isKilled, this);
    }

    public Execution(Execution response, double threshold) {
        if (response != null) {
            this.status = response.getStatus();
            this.metadata = response.getMetadata();
            this.projectId = response.getProjectId();
            this.id = response.getId();
            this.executionItems = response.getExecutionItems();
            this.executionStyle = response.getExecutionStyle();
            this.mode = response.getMode();
        }
        assert (response != null);
        this.metadata = new Metadata(threshold, false, false, response);
    }

    public Execution() {
    }

    public Execution(String projectId, String execId) {
    }

    public Execution(IExecution response) {
        if (response != null) {
            this.status = response.getStatus();
            this.metadata = (Metadata)response.getMetadata();
            this.projectId = response.getProjectId();
            this.id = response.getId();
            this.executionItems = response.getExecutionItems();
            this.executionStyle = response.getExecutionStyle();
            this.mode = response.getMode();
        }
    }

    @Override
    public String get_id() {
        return this._id;
    }

    public void set_id(String _id) {
        this._id = _id;
    }

    @Override
    public int getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Override
    public boolean isChildExecution() {
        return this.childExecution;
    }

    public void setChildExecution(boolean childExecution) {
        this.childExecution = childExecution;
    }

    @Override
    public String getCloudType() {
        return this.cloudType;
    }

    public void setCloudType(String cloudType) {
        this.cloudType = cloudType;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public int getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(int createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public String getEnvironmentType() {
        return this.environmentType;
    }

    public void setEnvironmentType(String environmentType) {
        this.environmentType = environmentType;
    }

    @Override
    public String getExecutionCategory() {
        return this.executionCategory;
    }

    public void setExecutionCategory(String executionCategory) {
        this.executionCategory = executionCategory;
    }

    @Override
    public String getExecutionOS() {
        return this.executionOS;
    }

    public void setExecutionOS(String executionOS) {
        this.executionOS = executionOS;
    }

    @Override
    public String getExecutionStyle() {
        return this.executionStyle;
    }

    public void setExecutionStyle(String executionStyle) {
        this.executionStyle = executionStyle;
    }

    @Override
    public String getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }

    @Override
    public String getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(String executionType) {
        this.executionType = executionType;
    }

    @Override
    public String getExecutionTypeCode() {
        return this.executionTypeCode;
    }

    public void setExecutionTypeCode(String executionTypeCode) {
        this.executionTypeCode = executionTypeCode;
    }

    @Override
    public int getExecutionTypeId() {
        return this.executionTypeId;
    }

    public void setExecutionTypeId(int executionTypeId) {
        this.executionTypeId = executionTypeId;
    }

    @Override
    public String getExecutionTypeName() {
        return this.executionTypeName;
    }

    public void setExecutionTypeName(String executionTypeName) {
        this.executionTypeName = executionTypeName;
    }

    @Override
    public boolean isFromAgent() {
        return this.fromAgent;
    }

    public void setFromAgent(boolean fromAgent) {
        this.fromAgent = fromAgent;
    }

    @Override
    public Map<String, Object> getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(Map<String, Object> globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    @Override
    public int getIterationId() {
        return this.iterationId;
    }

    public void setIterationId(int iterationId) {
        this.iterationId = iterationId;
    }

    @Override
    public List<String> getIterationsSelected() {
        return this.iterationsSelected;
    }

    public void setIterationsSelected(List<String> iterationsSelected) {
        this.iterationsSelected = iterationsSelected;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public Integer getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Integer moduleId) {
        this.moduleId = moduleId;
    }

    @Override
    public Integer getParentExecutionId() {
        return this.parentExecutionId;
    }

    public void setParentExecutionId(Integer parentExecutionId) {
        this.parentExecutionId = parentExecutionId;
    }

    @Override
    public int getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(int releaseId) {
        this.releaseId = releaseId;
    }

    @Override
    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<ExecutionItems> getTestCases() {
        return this.executionItems;
    }

    public void setExecutionItems(List<ExecutionItems> testCases) {
        this.executionItems = testCases;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Integer getUserstoryId() {
        return this.userstoryId;
    }

    public void setUserstoryId(Integer userstoryId) {
        this.userstoryId = userstoryId;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

