/*
 * Decompiled with CFR 0.152.
 */
package com.simplifyqa.Services;

import com.simplifyqa.ExecutionImpl;
import com.simplifyqa.Services.KillPayload;
import com.simplifyqa.Services.StatusPayload;
import com.simplifyqa.Services.TriggerPayload;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ExecutionServices {
    private static final int REQUEST_TIMEOUT_IN_SECS = 300;
    private ExecutionImpl exec_obj = null;
    private static final String bannerPath = "src\\main\\resources\\io\\jenkins\\plugins\\SQA\\banner.txt";

    public static String getTimestamp() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date date = new Date();
        return "\n[" + formatter.format(date) + " Hrs] ";
    }

    public static String getBanner() throws IOException {
        return String.join((CharSequence)"\n", Files.readAllLines(Paths.get(bannerPath, new String[0])));
    }

    public ExecutionImpl getExecObj() {
        return this.exec_obj;
    }

    public void setExecObj(ExecutionImpl exec_obj) {
        this.exec_obj = exec_obj;
    }

    public static HttpResponse<String> getResponse(String url, String method, String payload) throws URISyntaxException {
        HttpRequest request = null;
        HttpResponse<String> response = null;
        HttpClient client = HttpClient.newBuilder().cookieHandler(new CookieManager(null, CookiePolicy.ACCEPT_NONE)).followRedirects(HttpClient.Redirect.ALWAYS).build();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(new URI(url)).timeout(Duration.of(300L, ChronoUnit.SECONDS));
        builder.setHeader("Content-Type", "application/json");
        builder.setHeader("Authorization", ExecutionImpl.getAuthKey());
        try {
            if (method.equalsIgnoreCase("GET")) {
                request = builder.GET().version(HttpClient.Version.HTTP_2).build();
            }
            if (method.equalsIgnoreCase("POST")) {
                request = builder.POST(HttpRequest.BodyPublishers.ofString(payload)).version(HttpClient.Version.HTTP_2).build();
            }
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return response;
        }
    }

    public void printLog(String toPrint) {
        if (toPrint.trim().length() == 0) {
            return;
        }
        this.exec_obj.addLogs(toPrint);
        this.exec_obj.getListener().getLogger().print(toPrint);
    }

    public boolean startExec() {
        boolean ret_flag = false;
        HttpResponse<String> response = null;
        TriggerPayload payload = new TriggerPayload(this.exec_obj.getExec_token());
        try {
            response = ExecutionServices.getResponse(this.exec_obj.getBuildApi(), "POST", payload.getPayload());
            switch (response.statusCode()) {
                case 200: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution triggered.");
                    if (this.exec_obj.getVerbose()) {
                        this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                        this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    }
                    this.exec_obj.setExecId((Long)((JSONObject)new JSONParser().parse(response.body().toString())).get((Object)"executionId"));
                    this.exec_obj.setCustomerId(Integer.parseInt(((JSONObject)new JSONParser().parse(response.body().toString())).get((Object)"customerId").toString()));
                    this.exec_obj.setProjectId(Integer.parseInt(((JSONObject)new JSONParser().parse(response.body().toString())).get((Object)"projectId").toString()));
                    ExecutionImpl.setAuthKey((String)((JSONObject)new JSONParser().parse(response.body().toString())).get((Object)"authKey"));
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: INITIALIZING TESTCASES in the triggered suite");
                    ret_flag = true;
                    break;
                }
                case 400: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution did not get triggered.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Invalid Execution token for the specified env: " + this.exec_obj.getApp_url());
                    if (!this.exec_obj.getVerbose()) break;
                    this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                    this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    break;
                }
                case 403: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution did not get triggered.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Invalid Execution token for the specified env: " + this.exec_obj.getApp_url());
                    if (!this.exec_obj.getVerbose()) break;
                    this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                    this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    break;
                }
                case 500: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution did not get triggered.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: The cloud server or the local machine is unavailable for the specified env: " + this.exec_obj.getApp_url());
                    if (!this.exec_obj.getVerbose()) break;
                    this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                    this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    break;
                }
                case 504: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution did not get triggered.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: The server gateway timed-out for the specified env: " + this.exec_obj.getApp_url());
                    if (!this.exec_obj.getVerbose()) break;
                    this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                    this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    break;
                }
                default: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution did not get triggered.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Something is critically broken on SQA Servers.");
                    if (!this.exec_obj.getVerbose()) break;
                    this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                    this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                }
            }
            return ret_flag;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: No response received. Is the server down?");
            e.printStackTrace();
            return ret_flag;
        }
    }

    public String checkExecStatus() {
        HttpResponse<String> response = null;
        StringBuilder toPrint = new StringBuilder();
        StatusPayload payload = new StatusPayload(this.exec_obj.getExecId(), this.exec_obj.getCustomerId(), this.exec_obj.getProjectId());
        try {
            response = ExecutionServices.getResponse(this.exec_obj.getBuildApi(), "POST", payload.getPayload());
            for (int failsafe_counter = 60; !Boolean.valueOf(((JSONObject)new JSONParser().parse(response.body())).get((Object)"success").toString()).booleanValue() && failsafe_counter > 0; --failsafe_counter) {
                response = ExecutionServices.getResponse(this.exec_obj.getStatusApi(), "POST", payload.getPayload());
                Thread.sleep(5000L);
            }
            switch (response.statusCode()) {
                case 200: {
                    JSONObject dataObj = (JSONObject)new JSONParser().parse(((JSONObject)new JSONParser().parse(((JSONObject)new JSONParser().parse(response.body().toString())).get((Object)"data").toString())).get((Object)"data").toString());
                    this.exec_obj.setTcsFailed(0);
                    for (Object item : (JSONArray)dataObj.get((Object)"result")) {
                        if (!((JSONObject)item).get((Object)"result").toString().equalsIgnoreCase("FAILED")) continue;
                        this.exec_obj.setTcsFailed(this.exec_obj.getTcsFailed() + 1);
                    }
                    this.exec_obj.setExecutedTcs(0);
                    for (Object item : (JSONArray)dataObj.get((Object)"result")) {
                        if (!((JSONObject)item).get((Object)"result").toString().equalsIgnoreCase("PASSED") && !((JSONObject)item).get((Object)"result").toString().equalsIgnoreCase("FAILED")) continue;
                        this.exec_obj.setExecutedTcs(this.exec_obj.getExecutedTcs() + 1);
                    }
                    this.exec_obj.setResults((JSONArray)dataObj.get((Object)"result"));
                    this.exec_obj.setTotalTcs(Integer.parseInt(dataObj.get((Object)"totalTestcases").toString()));
                    this.exec_obj.setSuiteId(Integer.parseInt(dataObj.get((Object)"suiteId").toString()));
                    this.exec_obj.setReportUrl((String)dataObj.get((Object)"reporturl"));
                    this.exec_obj.setExecStatus((String)dataObj.get((Object)"execution"));
                    this.exec_obj.setUserId(Integer.parseInt(dataObj.get((Object)"userId").toString()));
                    this.exec_obj.setUserName((String)dataObj.get((Object)"username"));
                    this.exec_obj.setFailPercent();
                    this.exec_obj.setExecPercent();
                    if (!this.exec_obj.getVerbose()) break;
                    this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                    this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    break;
                }
                case 400: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution Status could not be fetched.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Logout and login again, Invalid Execution token for the specified env: " + this.exec_obj.getApp_url());
                    if (this.exec_obj.getVerbose()) {
                        this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                        this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    }
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                case 403: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution Status could not be fetched.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Logout and login again, Invalid Authorization token for the specified env: " + this.exec_obj.getApp_url());
                    if (this.exec_obj.getVerbose()) {
                        this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                        this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    }
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                case 500: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution Status could not be fetched.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: The cloud server or the local machine is unavailable for the specified env: " + this.exec_obj.getApp_url());
                    if (this.exec_obj.getVerbose()) {
                        this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                        this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    }
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                case 504: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution Status could not be fetched.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: The server gateway timed-out for the specified env: " + this.exec_obj.getApp_url());
                    if (this.exec_obj.getVerbose()) {
                        this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                        this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    }
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                default: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution Status could not be fetched.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Something is critically broken on SQA Servers.");
                    if (this.exec_obj.getVerbose()) {
                        this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                        this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
                    }
                    this.exec_obj.setExecStatus("FAILED");
                }
            }
            this.exec_obj.addLogs(toPrint.toString());
            this.exec_obj.getListener().getLogger().println(toPrint.toString());
            toPrint.delete(0, toPrint.length());
            return this.exec_obj.getExecStatus();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: No response received. Is the server down?");
            this.exec_obj.addLogs(toPrint.toString());
            this.exec_obj.getListener().getLogger().println(toPrint.toString());
            toPrint.delete(0, toPrint.length());
            e.printStackTrace();
            return "FAILED";
        }
    }

    public boolean killExec() {
        boolean ret_flag = false;
        HttpResponse<String> response = null;
        KillPayload payload = new KillPayload(this.exec_obj.getCustomerId(), this.exec_obj.getExecId(), this.exec_obj.getUserId(), this.exec_obj.getUserName());
        try {
            response = ExecutionServices.getResponse(this.exec_obj.getKillApi(), "POST", payload.getPayload());
            switch (response.statusCode()) {
                case 200: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Execution Killed Successfully.");
                    ret_flag = true;
                    break;
                }
                case 400: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Failed to kill execiution.");
                    this.printLog(ExecutionServices.getTimestamp() + this.exec_obj.getApp_url());
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                case 403: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Failed to kill execiution.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Logout and login again, Invalid Authorization token for the specified env: " + this.exec_obj.getApp_url());
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                case 500: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Failed to kill execiution.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: The Pipeline Token is invalid for the specified env: " + this.exec_obj.getApp_url());
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                case 504: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Failed to kill execiution.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: The server gateway timed-out for the specified env: " + this.exec_obj.getApp_url());
                    this.exec_obj.setExecStatus("FAILED");
                    break;
                }
                default: {
                    this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: Status code " + response.statusCode() + ", Failed to kill execiution.");
                    this.printLog(ExecutionServices.getTimestamp() + "REASON OF FAILURE: Something is critically broken on SQA Servers.");
                    this.exec_obj.setExecStatus("FAILED");
                }
            }
            if (this.exec_obj.getVerbose()) {
                this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
            }
            return ret_flag;
        }
        catch (Exception e) {
            this.printLog(ExecutionServices.getTimestamp() + "EXECUTION STATUS: No response received. Is the server down?");
            if (this.exec_obj.getVerbose()) {
                this.exec_obj.setReqBody(ExecutionServices.getTimestamp() + "REQUEST BODY: " + payload.getPayload());
                this.exec_obj.setRespBody(ExecutionServices.getTimestamp() + "RESPONSE BODY: " + response.body());
            }
            e.printStackTrace();
            return ret_flag;
        }
    }
}

