/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

final class LocalRunExecutor {
    private static final String API_KEY_ENV = "SEDSTART_API_KEY";

    LocalRunExecutor() {
    }

    void execute(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener, Integer projectId, Integer suiteId, Integer testId, Integer profileId, String browser, boolean headless, String environment) throws IOException, InterruptedException {
        LocalRunExecutor.validate(projectId, suiteId, testId, profileId);
        String apiKey = (String)env.get((Object)API_KEY_ENV);
        if (apiKey == null || apiKey.isEmpty()) {
            throw new IOException("SEDSTART_API_KEY is not set. Use Jenkins credentials binding.");
        }
        env.put(API_KEY_ENV, apiKey);
        env.put("SEDSTART_PROJECT_ID", projectId.toString());
        env.put("SEDSTART_PROFILE_ID", profileId.toString());
        env.put("SEDSTART_BROWSER", browser == null ? "chrome" : browser);
        env.put("SEDSTART_HEADLESS", Boolean.toString(headless));
        env.put("SEDSTART_ENV", environment == null ? "PROD" : environment);
        boolean isUnix = launcher.isUnix();
        List<String> installCmd = isUnix ? List.of("bash", "-c", "set -euo pipefail\n\nOS=\"$(uname -s | tr '[:upper:]' '[:lower:]')\"\nARCH=\"$(uname -m)\"\n\ncase \"$OS\" in\n  linux) PLATFORM_OS=linux ;;\n  darwin) PLATFORM_OS=darwin ;;\n  *) echo \"Unsupported OS: $OS\"; exit 1 ;;\nesac\n\ncase \"$ARCH\" in\n  x86_64|amd64) PLATFORM_ARCH=amd64 ;;\n  arm64|aarch64) PLATFORM_ARCH=arm64 ;;\n  i386|i686) PLATFORM_ARCH=386 ;;\n  *) echo \"Unsupported ARCH: $ARCH\"; exit 1 ;;\nesac\n\ncase \"$PLATFORM_OS/$PLATFORM_ARCH\" in\n  linux/amd64|darwin/amd64) VARIANT=v1 ;;\n  linux/arm64|darwin/arm64) VARIANT=v8.0 ;;\n  linux/386) VARIANT=sse2 ;;\n  *) echo \"No variant for $PLATFORM_OS/$PLATFORM_ARCH\"; exit 1 ;;\nesac\n\nmkdir -p .sedstart\n\nif [ \"$SEDSTART_ENV\" = \"QA\" ]; then\n  BASE_URL=\"https://cli.sedinqa.com/latest\"\n  API_URL=\"https://sedstart.sedinqa.com/api\"\nelse\n  BASE_URL=\"https://cli.sedstart.com/latest\"\n  API_URL=\"https://app.sedstart.com/api\"\nfi\n\nBIN=\".sedstart/sedstart\"\nURL=\"$BASE_URL/cli_${PLATFORM_OS}_${PLATFORM_ARCH}_${VARIANT}/sedstart\"\n\necho \"Downloading $URL\"\ncurl -fL \"$URL\" -o \"$BIN\"\nchmod +x \"$BIN\"\n\ncat > .sedstart/default.env <<EOF\nurl=$API_URL\nkey=$SEDSTART_API_KEY\nproject=$SEDSTART_PROJECT_ID\nprofile=$SEDSTART_PROFILE_ID\nheadless=$SEDSTART_HEADLESS\nEOF\n") : List.of("powershell", "-NoProfile", "-NonInteractive", "-Command", "$ErrorActionPreference = \"Stop\"\n\n$os = \"windows\"\nif ($Env:PROCESSOR_ARCHITECTURE -match \"ARM64\") { $arch = \"arm64\" }\nelseif ($Env:PROCESSOR_ARCHITECTURE -match \"AMD64\") { $arch = \"amd64\" }\nelse { $arch = \"386\" }\n\nswitch (\"$os/$arch\") {\n  \"windows/amd64\" { $variant = \"v1\" }\n  \"windows/arm64\" { $variant = \"v8.0\" }\n  \"windows/386\"   { $variant = \"sse2\" }\n  default { throw \"Unsupported $os/$arch\" }\n}\n\nNew-Item -ItemType Directory -Force .sedstart | Out-Null\n\nif ($Env:SEDSTART_ENV -eq \"QA\") {\n  $base = \"https://cli.sedinqa.com/latest\"\n  $api  = \"https://sedstart.sedinqa.com/api\"\n} else {\n  $base = \"https://cli.sedstart.com/latest\"\n  $api  = \"https://app.sedstart.com/api\"\n}\n\n$url = \"$base/cli_${os}_${arch}_${variant}/sedstart.exe\"\nInvoke-WebRequest -Uri $url -OutFile \".sedstart\\sedstart.exe\"\n\n@(\n  \"url=$api\",\n  \"key=$Env:SEDSTART_API_KEY\",\n  \"project=$Env:SEDSTART_PROJECT_ID\",\n  \"profile=$Env:SEDSTART_PROFILE_ID\",\n  \"headless=$Env:SEDSTART_HEADLESS\"\n) | Set-Content \".sedstart\\default.env\"\n");
        Launcher.ProcStarter installPs = launcher.launch();
        installPs.cmds(installCmd);
        installPs.envs((Map)env);
        installPs.pwd(workspace);
        installPs.stdout((OutputStream)listener.getLogger());
        installPs.stderr((OutputStream)listener.getLogger());
        if (installPs.join() != 0) {
            throw new IOException("sedstart installation failed");
        }
        Launcher.ProcStarter runPs = launcher.launch();
        if (isUnix) {
            String cmd = "cd .sedstart && " + (!headless ? "xvfb-run -a " : "") + "./sedstart run --browser " + (String)env.get((Object)"SEDSTART_BROWSER") + " --project " + projectId + " --data " + profileId + " " + (testId != null ? "--test " + testId : "--suite " + suiteId);
            runPs.cmds(new String[]{"bash", "-c", cmd});
        } else {
            String cmd = "cd .sedstart; .\\sedstart.exe run --browser " + (String)env.get((Object)"SEDSTART_BROWSER") + " --project " + projectId + " --data " + profileId + " " + (testId != null ? "--test " + testId : "--suite " + suiteId);
            runPs.cmds(new String[]{"powershell", "-NoProfile", "-NonInteractive", "-Command", cmd});
        }
        runPs.envs((Map)env);
        runPs.pwd(workspace);
        runPs.stdout((OutputStream)listener.getLogger());
        runPs.stderr((OutputStream)listener.getLogger());
        if (runPs.join() != 0) {
            throw new IOException("sedstart CLI failed");
        }
    }

    private static void validate(Integer projectId, Integer suiteId, Integer testId, Integer profileId) throws IOException {
        if (projectId == null) {
            throw new IOException("projectId is required");
        }
        if (profileId == null) {
            throw new IOException("profileId is required");
        }
        if (suiteId == null && testId == null || suiteId != null && testId != null) {
            throw new IOException("Provide exactly one of suiteId or testId");
        }
    }
}

