/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import io.jenkins.plugins.report.genericdiff.DefaultStrings;
import java.util.UUID;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RpmsReportOneRecord {
    private String command = null;
    private String id = null;
    private String maintitle;
    private String nochanges;
    private String updatedlines;
    private String addedlines;
    private String removedlines;
    private String errortitle;
    private String addedlineslong;
    private String removedlineslong;
    private String alllineslong;
    private String addedlinesshort;
    private String removedlinesshort;
    private String alllinesshort;
    private String lastProject = null;
    public static final String ID_BASE = "a-zA-Z0-9";

    @DataBoundConstructor
    public RpmsReportOneRecord(String command, String id, String maintitle, String nochanges, String updatedlines, String addedlines, String removedlines, String errortitle, String addedlineslong, String removedlineslong, String alllineslong, String addedlinesshort, String removedlinesshort, String alllinesshort) {
        this.command = command;
        this.id = RpmsReportOneRecord.sanitizeId(id);
        this.maintitle = maintitle;
        this.nochanges = nochanges;
        this.updatedlines = updatedlines;
        this.addedlines = addedlines;
        this.removedlines = removedlines;
        this.errortitle = errortitle;
        this.addedlineslong = addedlineslong;
        this.removedlineslong = removedlineslong;
        this.alllineslong = alllineslong;
        this.addedlinesshort = addedlinesshort;
        this.removedlinesshort = removedlinesshort;
        this.alllinesshort = alllinesshort;
    }

    public void setLastProject(String lastProject) {
        this.lastProject = lastProject;
    }

    public String getLastProject() {
        return this.lastProject;
    }

    public String getCommand() {
        return this.command;
    }

    public String getId() {
        return RpmsReportOneRecord.sanitizeId(this.id);
    }

    public static String sanitizeId(String id) {
        if (id == null || id.trim().isEmpty()) {
            return "uuid" + UUID.randomUUID().toString().split("-")[0].toUpperCase();
        }
        return id.replaceAll("[^a-zA-Z0-9]", "");
    }

    public String getMaintitle() {
        return DefaultStrings.get(this.maintitle, "Diff chart");
    }

    public String getNochanges() {
        return DefaultStrings.get(this.nochanges, "No Changes");
    }

    public String getUpdatedlines() {
        return DefaultStrings.get(this.updatedlines, "Changed lines");
    }

    public String getAddedlines() {
        return DefaultStrings.get(this.addedlines, "Added lines");
    }

    public String getRemovedlines() {
        return DefaultStrings.get(this.removedlines, "Removed lines");
    }

    public String getErrortitle() {
        return DefaultStrings.get(this.errortitle, "Command stderr output");
    }

    public String getAddedlineslong() {
        return DefaultStrings.get(this.addedlineslong, "New lines:");
    }

    public String getRemovedlineslong() {
        return DefaultStrings.get(this.removedlineslong, "Removed lines:");
    }

    public String getAlllineslong() {
        return DefaultStrings.get(this.alllineslong, "All lines:");
    }

    public String getAddedlinesshort() {
        return DefaultStrings.get(this.addedlinesshort, "Added");
    }

    public String getRemovedlinesshort() {
        return DefaultStrings.get(this.removedlinesshort, "Deleted");
    }

    public String getAlllinesshort() {
        return DefaultStrings.get(this.alllinesshort, "All");
    }

    @DataBoundSetter
    public void setCommand(String command) {
        this.command = command;
    }

    public void setId(String id) {
        this.id = id;
    }

    @DataBoundSetter
    public void setMaintitle(String maintitle) {
        this.maintitle = maintitle;
    }

    @DataBoundSetter
    public void setNochanges(String nochanges) {
        this.nochanges = nochanges;
    }

    @DataBoundSetter
    public void setUpdatedlines(String updatedlines) {
        this.updatedlines = updatedlines;
    }

    @DataBoundSetter
    public void setAddedlines(String addedlines) {
        this.addedlines = addedlines;
    }

    @DataBoundSetter
    public void setRemovedlines(String removedlines) {
        this.removedlines = removedlines;
    }

    @DataBoundSetter
    public void setErrortitle(String errortitle) {
        this.errortitle = errortitle;
    }

    @DataBoundSetter
    public void setAddedlineslong(String addedlineslong) {
        this.addedlineslong = addedlineslong;
    }

    @DataBoundSetter
    public void setRemovedlineslong(String removedlineslong) {
        this.removedlineslong = removedlineslong;
    }

    @DataBoundSetter
    public void setAlllineslong(String alllineslong) {
        this.alllineslong = alllineslong;
    }

    @DataBoundSetter
    public void setAddedlinesshort(String addedlinesshort) {
        this.addedlinesshort = addedlinesshort;
    }

    @DataBoundSetter
    public void setRemovedlinesshort(String removedlinesshort) {
        this.removedlinesshort = removedlinesshort;
    }

    @DataBoundSetter
    public void setAlllinesshort(String alllinesshort) {
        this.alllinesshort = alllinesshort;
    }
}

