/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.util.CopyOnWriteList;
import io.jenkins.plugins.remote.result.trigger.RemoteBuildResultTriggerProjectAction;
import io.jenkins.plugins.remote.result.trigger.RemoteBuildResultTriggerScheduledAction;
import io.jenkins.plugins.remote.result.trigger.RemoteJenkinsServer;
import io.jenkins.plugins.remote.result.trigger.RemoteJobInfo;
import io.jenkins.plugins.remote.result.trigger.RemoteResultAction;
import io.jenkins.plugins.remote.result.trigger.exceptions.RemoteJobInBuildingException;
import io.jenkins.plugins.remote.result.trigger.exceptions.UnSuccessfulRequestStatusException;
import io.jenkins.plugins.remote.result.trigger.model.JobResultInfo;
import io.jenkins.plugins.remote.result.trigger.model.ResultCheck;
import io.jenkins.plugins.remote.result.trigger.utils.RemoteJobResultUtils;
import io.jenkins.plugins.remote.result.trigger.utils.SourceMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.xtriggerapi.AbstractTrigger;
import org.jenkinsci.plugins.xtriggerapi.XTriggerDescriptor;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class RemoteBuildResultTrigger
extends AbstractTrigger
implements Serializable {
    private static final long serialVersionUID = -4059001060991775146L;
    private final List<RemoteJobInfo> remoteJobInfos;

    @DataBoundConstructor
    public RemoteBuildResultTrigger(String cronTabSpec, List<RemoteJobInfo> remoteJobInfos) {
        super(cronTabSpec);
        for (RemoteJobInfo info : remoteJobInfos) {
            info.updateId();
        }
        this.remoteJobInfos = remoteJobInfos;
    }

    protected File getLogFile() {
        if (this.job == null) {
            return null;
        }
        return new File(((BuildableItem)this.job).getRootDir(), "remote-build-result.log");
    }

    protected boolean requiresWorkspaceForPolling() {
        return false;
    }

    protected String getName() {
        return "RemoteResultTrigger";
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    protected boolean checkIfModified(Node pollingNode, XTriggerLog log) throws XTriggerException {
        boolean modified = false;
        ObjectWriter jsonPretty = new ObjectMapper().writerWithDefaultPrettyPrinter();
        if (this.job == null) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(this.remoteJobInfos)) {
            log.info("Job count: " + this.remoteJobInfos.size());
            RemoteJobResultUtils.cleanUnusedBuildInfo((BuildableItem)this.job, this.remoteJobInfos);
            for (RemoteJobInfo jobInfo : this.remoteJobInfos) {
                try {
                    log.info("================== " + jobInfo.getRemoteJobUrl() + " ==================");
                    Integer lastBuildBuildNumber = RemoteJobResultUtils.requestLastBuildBuildNumber(this.job, jobInfo);
                    if (lastBuildBuildNumber == null) continue;
                    log.info("Build number: " + lastBuildBuildNumber);
                    int checkedNumber = RemoteJobResultUtils.getCheckedNumber(this.job, jobInfo);
                    log.info("Checked number: " + checkedNumber);
                    int minBuildNumber = this.getMinBuildNumber(this.job, jobInfo, checkedNumber);
                    log.info("Min request number: " + minBuildNumber);
                    for (int number = lastBuildBuildNumber.intValue(); number > minBuildNumber; --number) {
                        SourceMap result = RemoteJobResultUtils.requestBuildResult(this.job, jobInfo, number);
                        if (result != null) {
                            SourceMap resultJson = this.cleanAndFixResultJson(result);
                            Integer buildNumber = result.integerValue("number");
                            String buildUrl = result.stringValue("url");
                            log.info("Last build url: " + buildUrl);
                            log.info("Last build number: " + buildNumber);
                            log.info("Remote build result: " + jsonPretty.writeValueAsString(result.getSource()));
                            if (resultJson != null) {
                                log.info("Remote build result json: " + jsonPretty.writeValueAsString(resultJson.getSource()));
                            }
                            if (!result.booleanValue("building").booleanValue() && !result.booleanValue("inProgress").booleanValue()) {
                                if (!jobInfo.getTriggerResults().contains(result.stringValue("result"))) continue;
                                log.info("Result confirmed: " + result.stringValue("result"));
                                List<ResultCheck> resultChecks = jobInfo.getResultChecks();
                                if (CollectionUtils.isNotEmpty(resultChecks)) {
                                    if (resultJson == null) {
                                        log.error("Cannot find remote result json!");
                                    } else {
                                        modified = true;
                                        for (ResultCheck check : resultChecks) {
                                            if (!StringUtils.isNotEmpty((String)check.getKey()) || !StringUtils.isNotEmpty((String)check.getExpectedValue())) continue;
                                            if (resultJson.containsKey(check.getKey())) {
                                                String value = resultJson.stringValue(check.getKey());
                                                Pattern pattern = Pattern.compile(check.getExpectedValue());
                                                if (pattern.matcher(value).matches()) continue;
                                                modified = false;
                                                break;
                                            }
                                            modified = false;
                                        }
                                    }
                                } else {
                                    modified = true;
                                }
                                if (!modified) continue;
                                log.info("Need trigger, remote build result: " + result.stringValue("result"));
                                RemoteJobResultUtils.saveBuildResultInfo((BuildableItem)this.job, jobInfo, result);
                                RemoteJobResultUtils.saveTriggeredNumber((BuildableItem)this.job, jobInfo, buildNumber);
                                if (resultJson == null) break;
                                RemoteJobResultUtils.saveRemoteResultInfo((BuildableItem)this.job, jobInfo, resultJson);
                                break;
                            }
                            throw new RemoteJobInBuildingException("Job is in building, skip checking:" + result.stringValue("url"));
                        }
                        throw new XTriggerException("Can't get remote build result, Server maybe deleted");
                    }
                    RemoteJobResultUtils.saveCheckedNumber((BuildableItem)this.job, jobInfo, lastBuildBuildNumber);
                }
                catch (RemoteJobInBuildingException e) {
                    log.error(e.getMessage());
                }
                catch (IOException e) {
                    log.error("Request last remote have a io exception\uff1a" + e.getMessage());
                }
                catch (UnSuccessfulRequestStatusException e) {
                    if (e.getStatus() == 404) continue;
                    throw new XTriggerException("Request last remote successful job fail", (Throwable)e);
                }
            }
        } else {
            log.error("No remote job configured!");
        }
        return modified;
    }

    protected Action[] getScheduledActions(Node pollingNode, XTriggerLog log) {
        if (this.job != null) {
            try {
                List<JobResultInfo> jobResultInfos = RemoteJobResultUtils.getSavedJobInfos(this.job);
                return new Action[]{new RemoteBuildResultTriggerScheduledAction((BuildableItem)this.job, jobResultInfos)};
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Action[0];
    }

    public Collection<? extends Action> getProjectActions() {
        RemoteBuildResultTriggerProjectAction action = new RemoteBuildResultTriggerProjectAction((BuildableItem)this.job, this.getLogFile());
        return Collections.singleton(action);
    }

    protected String getCause() {
        return "A successful build result within the remote job";
    }

    public RemoteBuildResultTriggerDescriptor getDescriptor() {
        return (RemoteBuildResultTriggerDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    private Integer getMinBuildNumber(Item job, RemoteJobInfo jobInfo, int checkedNumber) throws UnSuccessfulRequestStatusException, IOException {
        Integer number;
        SourceMap firstBuild;
        SourceMap info = RemoteJobResultUtils.requestJobInfo(job, jobInfo);
        if (info != null && (firstBuild = info.sourceMap("firstBuild")) != null && (number = firstBuild.integerValue("number")) != null) {
            return Math.max(checkedNumber, number - 1);
        }
        return checkedNumber;
    }

    private SourceMap cleanAndFixResultJson(SourceMap result) throws JsonProcessingException {
        Map<String, Object> source = result.getSource();
        source.remove("changeSets");
        source.remove("culprits");
        source.remove("artifacts");
        source.remove("_class");
        List<Map> actions = result.listValue("actions", Map.class);
        SourceMap resultJson = null;
        for (Map action : actions) {
            SourceMap sourceMap = SourceMap.of(action);
            if (!RemoteResultAction.class.getName().equals(sourceMap.stringValue("_class"))) continue;
            Map<String, Object> resultJsonMap = sourceMap.sourceMap("result").getSource();
            resultJsonMap.remove("_class");
            resultJson = SourceMap.of(resultJsonMap);
            break;
        }
        source.remove("actions");
        return resultJson;
    }

    @Generated
    public List<RemoteJobInfo> getRemoteJobInfos() {
        return this.remoteJobInfos;
    }

    @Extension
    public static class RemoteBuildResultTriggerDescriptor
    extends XTriggerDescriptor {
        private final CopyOnWriteList<RemoteJenkinsServer> remoteJenkinsServers = new CopyOnWriteList();

        public RemoteBuildResultTriggerDescriptor() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Remote Build Result Trigger";
        }

        public String getHelpFile() {
            return "/plugin/remote-result-trigger/help.html";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            List servers = req.bindJSONToList(RemoteJenkinsServer.class, json.get("remoteJenkinsServers"));
            for (RemoteJenkinsServer server : servers) {
                if (!StringUtils.isEmpty((String)server.getId())) continue;
                server.setId(UUID.randomUUID().toString());
            }
            this.remoteJenkinsServers.replaceBy((Collection)servers);
            this.save();
            return super.configure(req, json);
        }

        public RemoteJenkinsServer[] getRemoteJenkinsServers() {
            return (RemoteJenkinsServer[])this.remoteJenkinsServers.toArray((Object[])new RemoteJenkinsServer[this.remoteJenkinsServers.size()]);
        }
    }
}

