/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.util.ComboBoxModel;
import io.jenkins.plugins.util.FormValidationAssert;
import io.jenkins.plugins.util.ValidationUtilities;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ValidationUtilitiesTest {
    ValidationUtilitiesTest() {
    }

    @Test
    void shouldValidateCharsets() {
        ValidationUtilities model = new ValidationUtilities();
        FormValidationAssert.assertThat(model.validateCharset("")).isOk();
        FormValidationAssert.assertThat(model.validateCharset("UTF-8")).isOk();
        FormValidationAssert.assertThat(model.validateCharset("Some wrong text")).isError().hasMessage(ValidationUtilities.createWrongEncodingErrorMessage());
    }

    @Test
    void shouldContainDefaultCharsets() {
        ValidationUtilities model = new ValidationUtilities();
        ComboBoxModel allCharsets = model.getAllCharsets();
        ((ListAssert)Assertions.assertThat((List)allCharsets).isNotEmpty()).contains((Object[])new String[]{"UTF-8", "ISO-8859-1"});
    }

    @Test
    void shouldFallbackToPlatformCharset() {
        ValidationUtilities model = new ValidationUtilities();
        Assertions.assertThat((Comparable)model.getCharset("UTF-8")).isEqualTo((Object)StandardCharsets.UTF_8);
        Assertions.assertThat((Comparable)model.getCharset("nothing")).isEqualTo((Object)Charset.defaultCharset());
        Assertions.assertThat((Comparable)model.getCharset("")).isEqualTo((Object)Charset.defaultCharset());
        Assertions.assertThat((Comparable)model.getCharset(null)).isEqualTo((Object)Charset.defaultCharset());
    }

    @ParameterizedTest(name="{index} => Should be marked as illegal ID: \"{0}\"")
    @ValueSource(strings={"a b", "a/b", "a#b", "\u00e4\u00f6\u00fc", "a\u00f6", ".", ".."})
    @DisplayName(value="should reject IDs")
    void shouldRejectId(String id) {
        ValidationUtilities model = new ValidationUtilities();
        FormValidationAssert.assertThat(model.validateId(id)).isError().hasMessage(ValidationUtilities.createInvalidIdMessage((String)id));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> model.ensureValidId(id));
    }

    @ParameterizedTest(name="{index} => Should be marked as valid ID: \"{0}\"")
    @ValueSource(strings={"", "a", "awordb", "a-b", "a_b", "0", "a0b", "12a34", "A", "aBc", "a.b-c_e", "z.."})
    @DisplayName(value="should accept IDs")
    void shouldAcceptId(String id) {
        ValidationUtilities model = new ValidationUtilities();
        FormValidationAssert.assertThat(model.validateId(id)).isOk();
        Assertions.assertThatCode(() -> model.ensureValidId(id)).doesNotThrowAnyException();
    }
}

