/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.ResourceTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class SerializableTest<T extends Serializable>
extends ResourceTest {
    protected abstract T createSerializable();

    @Test
    @DisplayName(value="should be serializable: instance -> byte array -> instance")
    void shouldBeSerializable() {
        T serializableInstance = this.createSerializable();
        byte[] bytes = this.toByteArray((Serializable)serializableInstance);
        this.assertThatSerializableCanBeRestoredFrom(bytes);
    }

    protected void assertThatSerializableCanBeRestoredFrom(byte ... serializedInstance) {
        this.assertThatRestoredInstanceEqualsOriginalInstance(this.createSerializable(), this.restore(serializedInstance));
    }

    protected void assertThatRestoredInstanceEqualsOriginalInstance(T original, T restored) {
        Assertions.assertThat(restored).usingRecursiveComparison().isEqualTo(original);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T restore(byte[] serializedInstance) {
        try (ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(serializedInstance));){
            Object object = inputStream.readObject();
            Serializable serializable = (Serializable)object;
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new AssertionError("Can't resolve instance from byte array", e);
        }
    }

    protected byte[] toByteArray(Serializable object) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(out);){
            stream.writeObject(object);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Can't serialize object " + String.valueOf(object), exception);
        }
        return out.toByteArray();
    }

    protected void createSerializationFile() throws IOException {
        Files.write(Path.of("/tmp/serializable.ser", new String[0]), this.toByteArray((Serializable)this.createSerializable()), StandardOpenOption.CREATE_NEW);
    }
}

