/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.context;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import java.util.Optional;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class StepContextHelper {
    public static Computer getComputer(StepContext stepContext) throws Exception {
        return StepContextHelper.getOrThrow(stepContext, Computer.class);
    }

    public static Launcher getLauncher(StepContext stepContext) throws Exception {
        return StepContextHelper.getOrThrow(stepContext, Launcher.class);
    }

    public static EnvVars getEnvVars(StepContext stepContext) throws Exception {
        return StepContextHelper.getOrThrow(stepContext, EnvVars.class);
    }

    public static TaskListener getTaskListener(StepContext stepContext) throws Exception {
        return StepContextHelper.getOrThrow(stepContext, TaskListener.class);
    }

    public static FilePath getWorkspace(StepContext stepContext) throws Exception {
        FilePath workspace = StepContextHelper.getOrThrow(stepContext, FilePath.class);
        if (!workspace.exists()) {
            workspace.mkdirs();
        }
        return workspace;
    }

    public static FilePath getTemporaryDirectory(StepContext stepContext) throws Exception {
        FilePath workspace = StepContextHelper.getWorkspace(stepContext);
        return Optional.ofNullable(WorkspaceList.tempDir((FilePath)workspace)).orElseThrow(() -> new IllegalStateException("failed to resolve temporary directory from context"));
    }

    private static <T> T getOrThrow(StepContext stepContext, Class<T> type) throws Exception {
        return (T)Optional.ofNullable(stepContext.get(type)).orElseThrow(() -> new IllegalStateException("failed to resolve " + type.getSimpleName() + " from context"));
    }
}

