/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.treescanner;

import io.jenkins.plugins.pipelinegraphview.treescanner.PipelineNodeTreeScanner;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraphBuilderApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepBuilderApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineNodeGraphAdapter
implements PipelineGraphBuilderApi,
PipelineStepBuilderApi {
    private static final Logger logger = LoggerFactory.getLogger(PipelineNodeGraphAdapter.class);
    private boolean isDebugEnabled = logger.isDebugEnabled();
    private PipelineNodeTreeScanner treeScanner;
    private List<FlowNodeWrapper> pipelineNodesList;
    private Map<String, List<FlowNodeWrapper>> stepsMap;
    private Map<String, String> nodesToRemap;

    public PipelineNodeGraphAdapter(WorkflowRun run) {
        this.treeScanner = new PipelineNodeTreeScanner(run);
    }

    private Map<String, String> getNodesToRemap(List<FlowNodeWrapper> pipelineNodesList) {
        if (this.nodesToRemap != null) {
            return this.nodesToRemap;
        }
        this.nodesToRemap = new HashMap<String, String>();
        for (int i = pipelineNodesList.size() - 1; i >= 0; --i) {
            FlowNodeWrapper node = pipelineNodesList.get(i);
            for (FlowNodeWrapper parent : node.getParents()) {
                if (node.getType() == FlowNodeWrapper.NodeType.PARALLEL_BLOCK && parent.getType() == FlowNodeWrapper.NodeType.STAGE) {
                    if (this.isDebugEnabled) {
                        logger.debug("getNodesToRemap => Found Parallel block {id: {}, name: {}, type: {}} that has a Stage {id: {}, name: {}, type: {}} as a parent. Adding to remap list.", new Object[]{node.getId(), node.getDisplayName(), node.getType(), parent.getId(), parent.getDisplayName(), parent.getType()});
                    }
                    this.nodesToRemap.put(node.getId(), parent.getId());
                    continue;
                }
                if (parent.getType() != FlowNodeWrapper.NodeType.PARALLEL || !node.getDisplayName().equals(parent.getDisplayName())) continue;
                if (this.isDebugEnabled) {
                    logger.debug("getNodesToRemap => Found Stage {id: {}, name: {}, type: {}} that is an only child and has a parent with the same name {id: {}, name: {}, type: {}}. Adding to remap list.", new Object[]{node.getId(), node.getDisplayName(), node.getType(), parent.getId(), parent.getDisplayName(), parent.getType()});
                }
                this.nodesToRemap.put(node.getId(), parent.getId());
            }
        }
        for (String nodeId : this.nodesToRemap.keySet()) {
            this.nodesToRemap.put(nodeId, this.getFinalParent(nodeId, this.nodesToRemap));
        }
        return this.nodesToRemap;
    }

    private String getFinalParent(String nodeId, Map<String, String> nodesToRemap) {
        if (nodesToRemap.containsKey(nodeId)) {
            return this.getFinalParent(nodesToRemap.get(nodeId), nodesToRemap);
        }
        return nodeId;
    }

    private void dumpNodeGraphviz(List<FlowNodeWrapper> localPipelineNodesList, Map<String, List<FlowNodeWrapper>> localStepsMap) {
        if (this.isDebugEnabled) {
            ArrayList<FlowNodeWrapper> nodes = new ArrayList<FlowNodeWrapper>(localPipelineNodesList);
            if (this.stepsMap != null) {
                for (List<FlowNodeWrapper> stepsList : localStepsMap.values()) {
                    nodes.addAll(stepsList);
                }
            }
            if (this.isDebugEnabled) {
                logger.debug(FlowNodeWrapper.getNodeGraphviz(nodes));
            }
        }
    }

    private void dumpNodeGraphviz(List<FlowNodeWrapper> nodes) {
        this.dumpNodeGraphviz(nodes, this.stepsMap);
    }

    private void remapStageParentage() {
        if (this.pipelineNodesList != null) {
            return;
        }
        Map<String, FlowNodeWrapper> pipelineNodeMap = this.treeScanner.getPipelineNodeMap();
        this.pipelineNodesList = new ArrayList<FlowNodeWrapper>(pipelineNodeMap.values());
        Collections.sort(this.pipelineNodesList, new FlowNodeWrapper.NodeComparator());
        Map<String, String> nodesToRemap = this.getNodesToRemap(this.pipelineNodesList);
        if (this.isDebugEnabled) {
            logger.debug("remapStageParentage => nodesToRemap: {}", (Object)nodesToRemap.entrySet().stream().map(entrySet -> (String)entrySet.getKey() + ":" + (String)entrySet.getValue()).collect(Collectors.joining(",", "[", "]")));
        }
        this.dumpNodeGraphviz(this.pipelineNodesList);
        for (int i = this.pipelineNodesList.size() - 1; i >= 0; --i) {
            FlowNodeWrapper node = this.pipelineNodesList.get(i);
            List parentIds = node.getParents().stream().map(FlowNodeWrapper::getId).collect(Collectors.toList());
            for (String parentId : parentIds) {
                if (!nodesToRemap.containsKey(parentId)) continue;
                FlowNodeWrapper parent = pipelineNodeMap.get(parentId);
                node.removeEdge(parent);
                node.removeParent(parent);
                String newParentId = nodesToRemap.get(parentId);
                if (newParentId != null) {
                    FlowNodeWrapper newParent = pipelineNodeMap.get(newParentId);
                    node.addEdge(newParent);
                    node.addParent(newParent);
                    if (!this.isDebugEnabled) continue;
                    logger.debug("remapStageParentage => Remapped parent node of {id: {}, name: {}, type: {}} from {id: {}, name: {}, type: {}} to {id: {}, name: {}, type: {}}.", new Object[]{node.getId(), node.getDisplayName(), node.getType(), parent.getId(), parent.getDisplayName(), parent.getType(), newParent.getId(), newParent.getDisplayName(), newParent.getType()});
                    continue;
                }
                if (!this.isDebugEnabled) continue;
                logger.debug("remapStageParentage => Removed parent of {id: {}, name: {}, type: {}} - was {id: {}, name: {}, type: {}}.", new Object[]{node.getId(), node.getDisplayName(), node.getType(), parent.getId(), parent.getDisplayName(), parent.getType()});
            }
        }
        this.pipelineNodesList = this.pipelineNodesList.stream().filter(n -> !nodesToRemap.containsKey(n.getId())).filter(n -> n.getParents().isEmpty() || n.getParents().get(0).getStatus().wasExecuted()).collect(Collectors.toList());
        this.dumpNodeGraphviz(this.pipelineNodesList);
    }

    private void remapStepParentage() {
        if (this.stepsMap != null) {
            return;
        }
        this.stepsMap = this.treeScanner.getAllSteps();
        this.dumpNodeGraphviz(this.getPipelineNodes(), this.stepsMap);
        Map<String, String> nodesToRemap = this.getNodesToRemap(this.getPipelineNodes());
        for (Map.Entry<String, String> remapEntry : nodesToRemap.entrySet()) {
            String originalParentId = remapEntry.getKey();
            if (!this.stepsMap.containsKey(originalParentId)) continue;
            String remappedParentId = remapEntry.getValue();
            if (this.isDebugEnabled) {
                logger.debug("remapStepParentage => Remapping {} steps from stage {} to {}.", new Object[]{this.stepsMap.get(originalParentId).size(), originalParentId, remappedParentId});
            }
            List remappedParentStepsList = this.stepsMap.getOrDefault(remappedParentId, new ArrayList());
            remappedParentStepsList.addAll((Collection)this.stepsMap.get(originalParentId));
            Collections.sort(remappedParentStepsList, new FlowNodeWrapper.NodeComparator());
            this.stepsMap.put(remappedParentId, remappedParentStepsList);
            this.stepsMap.remove(originalParentId);
        }
        this.dumpNodeGraphviz(this.getPipelineNodes(), this.stepsMap);
    }

    @Override
    public List<FlowNodeWrapper> getPipelineNodes() {
        if (this.pipelineNodesList == null) {
            this.remapStageParentage();
        }
        return this.pipelineNodesList;
    }

    @Override
    public Map<String, List<FlowNodeWrapper>> getAllSteps() {
        if (this.stepsMap == null) {
            this.remapStepParentage();
        }
        return this.stepsMap;
    }

    @Override
    public List<FlowNodeWrapper> getStageSteps(String startNodeId) {
        return this.getAllSteps().getOrDefault(startNodeId, new ArrayList());
    }

    public Map<String, List<FlowNodeWrapper>> getStep() {
        if (this.stepsMap == null) {
            this.remapStepParentage();
        }
        return this.stepsMap;
    }
}

