/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.cards;

import java.util.Objects;

public class RunDetailsItem {
    private final String icon;
    private final String text;
    private final String href;
    private final boolean separator;

    RunDetailsItem(String icon, String text, String href, boolean separator) {
        this.icon = icon;
        this.text = text;
        this.href = href;
        this.separator = separator;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public String getHref() {
        return this.href;
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public static class Builder {
        private String icon;
        private String text;
        private String href;
        private boolean separator;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder ionicon(String ionicon) {
            this.icon = String.format("symbol-%s plugin-ionicons-api", ionicon);
            return this;
        }

        public Builder href(String href) {
            this.href = href;
            return this;
        }

        public Builder separator() {
            this.separator = true;
            return this;
        }

        public RunDetailsItem build() {
            if (!this.separator) {
                Objects.requireNonNull(this.icon);
            }
            return new RunDetailsItem(this.icon, this.text, this.href, this.separator);
        }
    }
}

