/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils.legacy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.Result;
import io.jenkins.plugins.pipelinegraphview.utils.BlueRun;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.NodeRunStatus;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraphBuilderApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.ExecutionModelAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.graphanalysis.StandardChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StageChunkFinder;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineNodeGraphVisitor
extends StandardChunkVisitor
implements PipelineGraphBuilderApi {
    private final WorkflowRun run;
    private final ArrayDeque<FlowNodeWrapper> parallelBranches = new ArrayDeque();
    public final ArrayDeque<FlowNodeWrapper> nodes = new ArrayDeque();
    private FlowNode firstExecuted = null;
    private FlowNodeWrapper nextStage;
    public final Map<String, FlowNodeWrapper> nodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
    public final Map<String, Stack<FlowNodeWrapper>> stackPerEnd = new HashMap<String, Stack<FlowNodeWrapper>>();
    private static final Logger logger = LoggerFactory.getLogger(PipelineNodeGraphVisitor.class);
    private static final boolean isNodeVisitorDumpEnabled = logger.isTraceEnabled();
    private final Stack<FlowNode> nestedStages = new Stack();
    private final Stack<FlowNode> nestedbranches = new Stack();
    private final ArrayDeque<FlowNode> pendingInputSteps = new ArrayDeque();
    private Stack<FlowNode> parallelEnds = new Stack();
    private final Stack<FlowNode> pendingBranchEndNodes = new Stack();
    private final Stack<FlowNode> parallelBranchEndNodes = new Stack();
    private final Stack<FlowNode> parallelBranchStartNodes = new Stack();
    private final InputAction inputAction;
    private StepStartNode agentNode = null;
    private Set<Action> pipelineActions;
    private Map<FlowNode, Set<Action>> pendingActionsForBranches;
    private static final String PARALLEL_SYNTHETIC_STAGE_NAME = "Parallel";
    private final boolean declarative;

    public PipelineNodeGraphVisitor(WorkflowRun run) {
        this.run = run;
        this.inputAction = (InputAction)run.getAction(InputAction.class);
        this.pipelineActions = new HashSet<Action>();
        this.pendingActionsForBranches = new HashMap<FlowNode, Set<Action>>();
        this.declarative = run.getAction(ExecutionModelAction.class) != null;
        FlowExecution execution = run.getExecution();
        if (execution != null) {
            try {
                ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)this, (ChunkFinder)new StageChunkFinder());
            }
            catch (Throwable t) {
                logger.error("Caught a " + t.getClass().getSimpleName() + " traversing the graph for run " + run.getExternalizableId());
                throw t;
            }
        } else {
            logger.debug("Could not find execution for run " + run.getExternalizableId());
        }
    }

    public void chunkStart(@NonNull FlowNode startNode, @CheckForNull FlowNode beforeBlock, @NonNull ForkScanner scanner) {
        super.chunkStart(startNode, beforeBlock, scanner);
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("chunkStart=> id: %s, name: %s, function: %s", startNode.getId(), startNode.getDisplayName(), startNode.getDisplayFunctionName()));
        }
        if (NotExecutedNodeAction.isExecuted((FlowNode)startNode)) {
            this.firstExecuted = startNode;
        }
    }

    public void chunkEnd(@NonNull FlowNode endNode, @CheckForNull FlowNode afterBlock, @NonNull ForkScanner scanner) {
        super.chunkEnd(endNode, afterBlock, scanner);
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("chunkEnd=> id: %s, name: %s, function: %s, type:%s", endNode.getId(), endNode.getDisplayName(), endNode.getDisplayFunctionName(), endNode.getClass()));
        }
        if (isNodeVisitorDumpEnabled && endNode instanceof StepEndNode) {
            this.dump("\tStartNode: " + String.valueOf(((StepEndNode)endNode).getStartNode()));
        }
        if (endNode instanceof StepStartNode && PipelineNodeUtil.isAgentStart(endNode)) {
            this.agentNode = (StepStartNode)endNode;
        }
        this.captureOrphanParallelBranches();
        if (this.parallelEnds.isEmpty() && endNode instanceof StepEndNode && PipelineNodeUtil.isStage((FlowNode)((StepEndNode)endNode).getStartNode())) {
            FlowNode node = null;
            if (!this.nestedStages.empty()) {
                node = this.nestedStages.peek();
            }
            if (node == null || !node.equals((Object)endNode)) {
                this.nestedStages.push(endNode);
            }
        }
        this.firstExecuted = null;
        if (!(endNode instanceof BlockEndNode)) {
            this.atomNode(null, endNode, afterBlock, scanner);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="chunk.getLastNode() is marked non null but is null sometimes, when JENKINS-40200 is fixed we will remove this check ")
    protected void handleChunkDone(@NonNull MemoryFlowChunk chunk) {
        NodeRunStatus status;
        boolean skippedStage;
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("handleChunkDone=> id: %s, name: %s, function: %s", chunk.getFirstNode().getId(), chunk.getFirstNode().getDisplayName(), chunk.getFirstNode().getDisplayFunctionName()));
        }
        boolean parallelNestedStages = false;
        if (!this.parallelEnds.isEmpty()) {
            parallelNestedStages = true;
        }
        TimingInfo times = null;
        if (this.firstExecuted != null && chunk.getLastNode() != null) {
            times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)chunk.getPauseTimeMillis(), (FlowNode)this.firstExecuted, (FlowNode)chunk.getLastNode(), (FlowNode)chunk.getNodeAfter());
        }
        if (times == null) {
            times = new TimingInfo();
        }
        if (skippedStage = PipelineNodeUtil.isSkippedStage(chunk.getFirstNode())) {
            status = new NodeRunStatus(BlueRun.BlueRunResult.NOT_BUILT, BlueRun.BlueRunState.SKIPPED);
        } else if (this.firstExecuted == null) {
            status = new NodeRunStatus(GenericStatus.NOT_EXECUTED);
        } else if (chunk.getLastNode() != null) {
            WarningAction warningAction = (WarningAction)chunk.getFirstNode().getPersistentAction(WarningAction.class);
            if (parallelNestedStages && chunk.getFirstNode().isActive()) {
                status = new NodeRunStatus(chunk.getFirstNode());
            } else if (PipelineNodeUtil.isStage(chunk.getFirstNode()) && warningAction != null) {
                status = new NodeRunStatus(GenericStatus.fromResult((Result)warningAction.getResult()));
            } else {
                FlowNode nodeBefore = chunk.getNodeBefore();
                FlowNode firstNode = chunk.getFirstNode();
                FlowNode lastNode = chunk.getLastNode();
                FlowNode nodeAfter = chunk.getNodeAfter();
                status = new NodeRunStatus(StatusAndTiming.computeChunkStatus2((WorkflowRun)this.run, (FlowNode)nodeBefore, (FlowNode)firstNode, (FlowNode)lastNode, (FlowNode)nodeAfter));
            }
        } else {
            status = new NodeRunStatus(this.firstExecuted);
        }
        if (!this.pendingInputSteps.isEmpty()) {
            status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.PAUSED);
        }
        FlowNodeWrapper stage = new FlowNodeWrapper(chunk.getFirstNode(), status, times, this.run);
        stage.setCauseOfFailure(PipelineNodeUtil.getCauseOfBlockage(stage.getNode(), (FlowNode)this.agentNode));
        this.accumulatePipelineActions(chunk.getFirstNode());
        Set<Action> pipelineActions = this.drainPipelineActions();
        if (isNodeVisitorDumpEnabled && pipelineActions.isEmpty()) {
            this.dump("\tAdding " + pipelineActions.size() + " actions to stage id: " + stage.getId());
        }
        stage.setPipelineActions(pipelineActions);
        if (!parallelNestedStages) {
            this.nodes.push(stage);
            this.nodeMap.put(stage.getId(), stage);
        }
        if (!skippedStage && !this.parallelBranches.isEmpty()) {
            Iterator<FlowNodeWrapper> branches = this.parallelBranches.descendingIterator();
            while (branches.hasNext()) {
                FlowNodeWrapper p = branches.next();
                if (isNodeVisitorDumpEnabled) {
                    this.dump(String.format("handleChunkDone=> found node [id: %s, name: %s, function: %s] is child of [id: %s, name: %s, function: %s] - parallelBranches", p.getId(), p.getDisplayName(), p.getNode().getDisplayFunctionName(), stage.getId(), stage.getDisplayName(), stage.getNode().getDisplayFunctionName()));
                }
                p.addParent(stage);
                stage.addEdge(p);
            }
        } else {
            if (parallelNestedStages) {
                if (this.pendingBranchEndNodes.isEmpty()) {
                    logger.debug("skip parsing stage {} but parallelBranchEndNodes is empty", (Object)stage);
                } else {
                    String endId = this.pendingBranchEndNodes.peek().getId();
                    Stack stack = this.stackPerEnd.computeIfAbsent(endId, k -> new Stack());
                    stack.add(stage);
                }
            }
            if (this.nextStage != null && !parallelNestedStages) {
                if (isNodeVisitorDumpEnabled) {
                    this.dump(String.format("handleChunkDone=> found node [id: %s, name: %s, function: %s] is child of [id: %s, name: %s, function: %s]", this.nextStage.getId(), this.nextStage.getDisplayName(), this.nextStage.getNode().getDisplayFunctionName(), stage.getId(), stage.getDisplayName(), stage.getNode().getDisplayFunctionName()));
                }
                this.nextStage.addParent(stage);
                stage.addEdge(this.nextStage);
            }
            if (this.nextStage == null && isNodeVisitorDumpEnabled) {
                this.dump(String.format("handleChunkDone=> WARNING: nextStage is null! Unable for assign parent stage for stage [id: %s, name: %s, function: %s]", stage.getId(), stage.getDisplayName(), stage.getNode().getDisplayFunctionName()));
            }
            for (FlowNodeWrapper p : this.parallelBranches) {
                this.nodes.remove(p);
                this.nodeMap.remove(p.getId(), p);
            }
        }
        this.parallelBranches.clear();
        if (!parallelNestedStages) {
            if (isNodeVisitorDumpEnabled) {
                this.dump(String.format("handleChunkDone=> setting nextStage to: [id: %s, name: %s, function: %s]", stage.getId(), stage.getDisplayName(), stage.getNode().getDisplayFunctionName()));
            }
            this.nextStage = stage;
        }
    }

    protected void resetChunk(@NonNull MemoryFlowChunk chunk) {
        super.resetChunk(chunk);
        this.firstExecuted = null;
        this.pendingInputSteps.clear();
    }

    public void parallelStart(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchNode, @NonNull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelStart=> id: %s, name: %s, function: %s", parallelStartNode.getId(), parallelStartNode.getDisplayName(), parallelStartNode.getDisplayFunctionName()));
            this.dump(String.format("\tbranch=> id: %s, name: %s, function: %s", branchNode.getId(), branchNode.getDisplayName(), branchNode.getDisplayFunctionName()));
        }
        if (this.nestedbranches.size() != this.parallelBranchEndNodes.size()) {
            logger.debug(String.format("nestedBranches size: %s not equal to parallelBranchEndNodes: %s", this.nestedbranches.size(), this.parallelBranchEndNodes.size()));
            if (!this.parallelEnds.isEmpty()) {
                this.parallelEnds.pop();
            }
            return;
        }
        if (!this.pendingBranchEndNodes.isEmpty()) {
            logger.debug("Found parallelBranchEndNodes, but the corresponding branchStartNode yet");
            if (!this.parallelEnds.isEmpty()) {
                this.parallelEnds.pop();
            }
            return;
        }
        while (!this.nestedbranches.empty() && !this.parallelBranchEndNodes.empty()) {
            Stack<FlowNodeWrapper> stack;
            NodeRunStatus status;
            TimingInfo times;
            FlowNode branchStartNode = this.nestedbranches.pop();
            FlowNode endNode = this.parallelBranchEndNodes.pop();
            if (isNodeVisitorDumpEnabled) {
                this.dump(String.format("\tBranch with start node id: %s", branchStartNode.getId()));
            }
            if (endNode != null) {
                times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)this.chunk.getPauseTimeMillis(), (FlowNode)branchStartNode, (FlowNode)endNode, (FlowNode)this.chunk.getNodeAfter());
                if (endNode instanceof StepAtomNode) {
                    status = PipelineNodeUtil.isPausedForInputStep((StepAtomNode)endNode, this.inputAction) ? new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.PAUSED) : new NodeRunStatus(endNode);
                } else {
                    FlowNode parallelEnd = null;
                    if (!this.parallelEnds.isEmpty()) {
                        parallelEnd = this.parallelEnds.peek();
                    }
                    GenericStatus genericStatus = StatusAndTiming.computeChunkStatus2((WorkflowRun)this.run, (FlowNode)parallelStartNode, (FlowNode)branchStartNode, (FlowNode)endNode, (FlowNode)parallelEnd);
                    status = new NodeRunStatus(genericStatus);
                }
            } else {
                long startTime = System.currentTimeMillis();
                if (branchStartNode.getAction(TimingAction.class) != null) {
                    startTime = TimingAction.getStartTime((FlowNode)branchStartNode);
                }
                times = new TimingInfo(System.currentTimeMillis() - startTime, this.chunk.getPauseTimeMillis(), startTime);
                status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.RUNNING);
            }
            assert (times != null);
            FlowNodeWrapper branch = new FlowNodeWrapper(branchStartNode, status, times, this.run);
            ArrayList<Action> branchActions = new ArrayList<Action>(this.drainPipelineActions());
            if (this.pendingActionsForBranches.containsKey(branchStartNode)) {
                branchActions.addAll((Collection<Action>)this.pendingActionsForBranches.get(branchStartNode));
                this.pendingActionsForBranches.remove(branchStartNode);
            }
            if (isNodeVisitorDumpEnabled && branchActions.isEmpty()) {
                this.dump("\t\tAdding " + branchActions.size() + " actions to branch id: " + branch.getId());
            }
            if ((stack = this.stackPerEnd.get(endNode.getId())) != null && !stack.isEmpty()) {
                if (isNodeVisitorDumpEnabled) {
                    this.dump(String.format("\t\t\"Complex\" stages detected (%d)", stack.size()));
                }
                if (stack.size() == 1) {
                    firstNodeWrapper = stack.pop();
                    if (isNodeVisitorDumpEnabled) {
                        this.dump("\t\tSingle-stage branch");
                    }
                    branchActions.addAll(firstNodeWrapper.getPipelineActions());
                    if (this.nextStage != null) {
                        branch.addEdge(this.nextStage);
                    }
                } else {
                    if (this.isDeclarative() && !StringUtils.equals((String)(firstNodeWrapper = stack.pop()).getDisplayName(), (String)branch.getDisplayName())) {
                        if (isNodeVisitorDumpEnabled) {
                            this.dump("\t\tNested labelling stage detected");
                        }
                        if (isNodeVisitorDumpEnabled) {
                            this.dump(String.format("parallelStart=> found node [id: %s, name: %s, function: %s] is child of [id: %s, name: %s, function: %s] - declarative", firstNodeWrapper.getId(), firstNodeWrapper.getDisplayName(), firstNodeWrapper.getNode().getDisplayFunctionName(), branch.getId(), branch.getDisplayName(), branch.getNode().getDisplayFunctionName()));
                        }
                        branch.addEdge(firstNodeWrapper);
                        firstNodeWrapper.addParent(branch);
                        this.nodes.add(firstNodeWrapper);
                    }
                    FlowNodeWrapper previousNode = branch;
                    while (!stack.isEmpty()) {
                        FlowNodeWrapper currentStage = stack.pop();
                        if (isNodeVisitorDumpEnabled) {
                            this.dump(String.format("parallelStart=> found node [id: %s, name: %s, function: %s] is child of [id: %s, name: %s, function: %s]", currentStage.getId(), currentStage.getDisplayName(), currentStage.getNode().getDisplayFunctionName(), previousNode.getId(), previousNode.getDisplayName(), previousNode.getNode().getDisplayFunctionName()));
                        }
                        previousNode.addEdge(currentStage);
                        currentStage.addParent(previousNode);
                        this.nodes.add(currentStage);
                        previousNode = currentStage;
                    }
                    if (this.nextStage != null) {
                        previousNode.addEdge(this.nextStage);
                    }
                }
            } else {
                if (isNodeVisitorDumpEnabled) {
                    this.dump("\t\tSimple branch (classic pipeline)");
                }
                if (this.nextStage != null) {
                    branch.addEdge(this.nextStage);
                }
            }
            branch.setPipelineActions(branchActions);
            this.parallelBranches.push(branch);
        }
        FlowNodeWrapper[] sortedBranches = this.parallelBranches.toArray(new FlowNodeWrapper[0]);
        Arrays.sort(sortedBranches, Comparator.comparing(FlowNodeWrapper::getDisplayName));
        this.parallelBranches.clear();
        for (FlowNodeWrapper sortedBranch : sortedBranches) {
            this.parallelBranches.push(sortedBranch);
        }
        for (FlowNodeWrapper p : this.parallelBranches) {
            this.nodes.push(p);
            this.nodeMap.put(p.getId(), p);
        }
        if (!this.parallelEnds.isEmpty()) {
            this.parallelEnds.pop();
        }
    }

    public void parallelEnd(@NonNull FlowNode parallelStartNode, @NonNull FlowNode parallelEndNode, @NonNull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelEnd=> id: %s, name: %s, function: %s", parallelEndNode.getId(), parallelEndNode.getDisplayName(), parallelEndNode.getDisplayFunctionName()));
            if (parallelEndNode instanceof StepEndNode) {
                this.dump(String.format("parallelEnd=> id: %s, StartNode: %s, name: %s, function: %s", parallelEndNode.getId(), ((StepStartNode)((StepEndNode)parallelEndNode).getStartNode()).getId(), ((StepStartNode)((StepEndNode)parallelEndNode).getStartNode()).getDisplayName(), ((StepStartNode)((StepEndNode)parallelEndNode).getStartNode()).getDisplayFunctionName()));
            }
        }
        this.captureOrphanParallelBranches();
        this.parallelEnds.add(parallelEndNode);
    }

    public void parallelBranchStart(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchStartNode, @NonNull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelBranchStart=> id: %s, name: %s, function: %s", branchStartNode.getId(), branchStartNode.getDisplayName(), branchStartNode.getDisplayFunctionName()));
        }
        this.pendingActionsForBranches.put(branchStartNode, this.drainPipelineActions());
        this.nestedbranches.push(branchStartNode);
        if (!this.pendingBranchEndNodes.isEmpty()) {
            FlowNode endNode = this.pendingBranchEndNodes.pop();
            this.parallelBranchEndNodes.add(endNode);
        }
    }

    public void parallelBranchEnd(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchEndNode, @NonNull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelBranchEnd=> id: %s, name: %s, function: %s, type: %s", branchEndNode.getId(), branchEndNode.getDisplayName(), branchEndNode.getDisplayFunctionName(), branchEndNode.getClass()));
            if (branchEndNode instanceof StepEndNode) {
                this.dump(String.format("parallelBranchEnd=> id: %s, StartNode: %s, name: %s, function: %s", branchEndNode.getId(), ((StepStartNode)((StepEndNode)branchEndNode).getStartNode()).getId(), ((StepStartNode)((StepEndNode)branchEndNode).getStartNode()).getDisplayName(), ((StepStartNode)((StepEndNode)branchEndNode).getStartNode()).getDisplayFunctionName()));
            }
        }
        this.pendingBranchEndNodes.add(branchEndNode);
        this.parallelBranchStartNodes.add(parallelStartNode);
    }

    public void atomNode(@CheckForNull FlowNode before, @NonNull FlowNode atomNode, @CheckForNull FlowNode after, @NonNull ForkScanner scan) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("atomNode=> id: %s, name: %s, function: %s, type: %s", atomNode.getId(), atomNode.getDisplayName(), atomNode.getDisplayFunctionName(), atomNode.getClass()));
        }
        this.accumulatePipelineActions(atomNode);
        if (atomNode instanceof FlowStartNode) {
            this.captureOrphanParallelBranches();
            return;
        }
        if (NotExecutedNodeAction.isExecuted((FlowNode)atomNode)) {
            this.firstExecuted = atomNode;
        }
        long pause = PauseAction.getPauseDuration((FlowNode)atomNode);
        this.chunk.setPauseTimeMillis(this.chunk.getPauseTimeMillis() + pause);
        if (atomNode instanceof StepAtomNode && PipelineNodeUtil.isPausedForInputStep((StepAtomNode)atomNode, this.inputAction)) {
            this.pendingInputSteps.add(atomNode);
        }
    }

    private void dump(String str) {
        logger.debug(System.identityHashCode(this) + ": " + str);
    }

    protected void accumulatePipelineActions(FlowNode node) {
        List actions = node.getActions(Action.class);
        this.pipelineActions.addAll(actions);
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("\t\taccumulating actions - added %d, total is %d", actions.size(), this.pipelineActions.size()));
        }
    }

    protected Set<Action> drainPipelineActions() {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("\t\tdraining accumulated actions - total is %d", this.pipelineActions.size()));
        }
        if (this.pipelineActions.size() == 0) {
            return Collections.emptySet();
        }
        Set<Action> drainedActions = this.pipelineActions;
        this.pipelineActions = new HashSet<Action>();
        return drainedActions;
    }

    @Override
    public List<FlowNodeWrapper> getPipelineNodes() {
        return new ArrayList<FlowNodeWrapper>(this.nodes);
    }

    private static Optional<FlowNodeWrapper> findNodeWrapperByIdIn(String id, Collection<FlowNodeWrapper> nodes) {
        for (FlowNodeWrapper node : nodes) {
            if (!node.getId().equals(id)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    private static Optional<FlowNodeWrapper> findNodeWrapperByParentageIn(FlowNodeWrapper example, List<FlowNodeWrapper> nodes) {
        String exampleDisplayName = example.getDisplayName();
        FlowNodeWrapper firstParent = example.getFirstParent();
        String exampleParentName = firstParent == null ? "" : firstParent.getDisplayName();
        for (FlowNodeWrapper node : nodes) {
            String nodeParentName;
            FlowNodeWrapper nodeParent = node.getFirstParent();
            String string = nodeParentName = nodeParent == null ? "" : nodeParent.getDisplayName();
            if (!node.getDisplayName().equals(exampleDisplayName) || !nodeParentName.equals(exampleParentName)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    private void captureOrphanParallelBranches() {
        FlowNodeWrapper synStage;
        if (!(this.parallelBranches.isEmpty() || this.firstExecuted != null && PipelineNodeUtil.isStage(this.firstExecuted) || (synStage = this.createParallelSyntheticNode()) == null)) {
            this.nodes.push(synStage);
            this.nodeMap.put(synStage.getId(), synStage);
            this.parallelBranches.clear();
            if (isNodeVisitorDumpEnabled) {
                this.dump(String.format("captureOrphanParallelBranches=> setting nextStage to: [id: %s, name: %s, function: %s]", synStage.getId(), synStage.getDisplayName(), synStage.getNode().getDisplayFunctionName()));
            }
            this.nextStage = synStage;
        }
    }

    @Nullable
    private FlowNodeWrapper createParallelSyntheticNode() {
        BlueRun.BlueRunState state;
        if (this.parallelBranches.isEmpty()) {
            return null;
        }
        FlowNodeWrapper firstBranch = this.parallelBranches.getLast();
        FlowNodeWrapper parallel = firstBranch.getFirstParent();
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("createParallelSyntheticNode=> firstBranch: %s, parallel:%s", firstBranch.getId(), parallel == null ? "(none)" : parallel.getId()));
        }
        String syntheticNodeId = firstBranch.getNode().getParents().stream().map(node -> node.getId()).findFirst().orElseGet(() -> this.createSyntheticStageId(firstBranch.getId(), PARALLEL_SYNTHETIC_STAGE_NAME));
        ArrayList parents = parallel != null ? parallel.getNode().getParents() : new ArrayList();
        FlowNode syntheticNode = new FlowNode(firstBranch.getNode().getExecution(), syntheticNodeId, parents){

            public void save() throws IOException {
            }

            protected String getTypeDisplayName() {
                return PipelineNodeGraphVisitor.PARALLEL_SYNTHETIC_STAGE_NAME;
            }
        };
        syntheticNode.addAction((Action)new LabelAction(PARALLEL_SYNTHETIC_STAGE_NAME));
        long duration = 0L;
        long pauseDuration = 0L;
        long startTime = System.currentTimeMillis();
        boolean isCompleted = true;
        boolean isPaused = false;
        boolean isFailure = false;
        boolean isUnknown = false;
        for (FlowNodeWrapper pb : this.parallelBranches) {
            if (!isPaused && pb.getStatus().getState() == BlueRun.BlueRunState.PAUSED) {
                isPaused = true;
            }
            if (isCompleted && pb.getStatus().getState() != BlueRun.BlueRunState.FINISHED) {
                isCompleted = false;
            }
            if (!isFailure && pb.getStatus().getResult() == BlueRun.BlueRunResult.FAILURE) {
                isFailure = true;
            }
            if (!isUnknown && pb.getStatus().getResult() == BlueRun.BlueRunResult.UNKNOWN) {
                isUnknown = true;
            }
            duration += pb.getTiming().getTotalDurationMillis();
            pauseDuration += pb.getTiming().getPauseDurationMillis();
        }
        BlueRun.BlueRunState blueRunState = isCompleted ? BlueRun.BlueRunState.FINISHED : (state = isPaused ? BlueRun.BlueRunState.PAUSED : BlueRun.BlueRunState.RUNNING);
        BlueRun.BlueRunResult result = isFailure ? BlueRun.BlueRunResult.FAILURE : (isUnknown ? BlueRun.BlueRunResult.UNKNOWN : BlueRun.BlueRunResult.SUCCESS);
        TimingInfo timingInfo = new TimingInfo(duration, pauseDuration, startTime);
        FlowNodeWrapper synStage = new FlowNodeWrapper(syntheticNode, new NodeRunStatus(result, state), timingInfo, this.run);
        Iterator<FlowNodeWrapper> sortedBranches = this.parallelBranches.descendingIterator();
        while (sortedBranches.hasNext()) {
            FlowNodeWrapper p = sortedBranches.next();
            if (isNodeVisitorDumpEnabled) {
                this.dump(String.format("createParallelSyntheticNode=> found node [id: %s, name: %s, function: %s] is child of [id: %s, name: %s, function: %s]", p.getId(), p.getDisplayName(), p.getNode().getDisplayFunctionName(), synStage.getId(), synStage.getDisplayName(), synStage.getNode().getDisplayFunctionName()));
            }
            p.addParent(synStage);
            synStage.addEdge(p);
        }
        return synStage;
    }

    public boolean isDeclarative() {
        return this.declarative;
    }

    @NonNull
    private String createSyntheticStageId(@NonNull String firstNodeId, @NonNull String syntheticStageName) {
        return String.format("%s-%s-synthetic", firstNodeId, syntheticStageName.toLowerCase());
    }
}

