/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.treescanner.PipelineNodeGraphAdapter;
import io.jenkins.plugins.pipelinegraphview.utils.BlueRun;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepBuilderApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepList;
import io.jenkins.plugins.pipelinegraphview.utils.legacy.PipelineStepVisitor;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStepApi {
    private static final Logger logger = LoggerFactory.getLogger(PipelineStepApi.class);
    private final transient WorkflowRun run;

    public PipelineStepApi(WorkflowRun run) {
        this.run = run;
    }

    private List<PipelineStep> parseSteps(List<FlowNodeWrapper> stepNodes, String stageId) {
        if (logger.isDebugEnabled()) {
            logger.debug("PipelineStepApi steps: '" + String.valueOf(stepNodes) + "'.");
        }
        List<PipelineStep> steps = stepNodes.stream().map(flowNodeWrapper -> {
            String state = flowNodeWrapper.getStatus().getResult().name().toLowerCase(Locale.ROOT);
            if (flowNodeWrapper.getStatus().getState() != BlueRun.BlueRunState.FINISHED) {
                state = flowNodeWrapper.getStatus().getState().name().toLowerCase(Locale.ROOT);
            }
            String displayName = flowNodeWrapper.getDisplayName();
            String title = "";
            if (flowNodeWrapper.getType() == FlowNodeWrapper.NodeType.UNHANDLED_EXCEPTION) {
                displayName = "Pipeline error";
            } else {
                String labelDisplayName;
                String stepArguments = flowNodeWrapper.getArgumentsAsString();
                if (stepArguments != null && !stepArguments.isEmpty()) {
                    displayName = stepArguments;
                    title = flowNodeWrapper.getDisplayName();
                }
                if ((labelDisplayName = flowNodeWrapper.getLabelDisplayName()) != null && !labelDisplayName.isEmpty()) {
                    displayName = labelDisplayName;
                    title = "";
                }
            }
            logger.debug("DisplayName Before: '" + displayName + "'.");
            displayName = PipelineStepApi.cleanTextContent(displayName);
            logger.debug("DisplayName After: '" + displayName + "'.");
            return new PipelineStep(flowNodeWrapper.getId(), displayName, state, flowNodeWrapper.getType().name(), title, stageId, flowNodeWrapper.getTiming());
        }).collect(Collectors.toList());
        return steps;
    }

    static String cleanTextContent(String text) {
        text = text.replaceAll("\\e\\[(\\d+[;:]?)+m", "");
        return text.trim();
    }

    private PipelineStepList getSteps(String stageId, PipelineStepBuilderApi builder) {
        List<FlowNodeWrapper> stepNodes = builder.getStageSteps(stageId);
        PipelineStepList steps = new PipelineStepList(this.parseSteps(stepNodes, stageId));
        steps.sort();
        return steps;
    }

    private PipelineStepList getAllSteps(PipelineStepBuilderApi builder) {
        Map<String, List<FlowNodeWrapper>> stepNodes = builder.getAllSteps();
        PipelineStepList allSteps = new PipelineStepList();
        for (Map.Entry<String, List<FlowNodeWrapper>> entry : stepNodes.entrySet()) {
            allSteps.addAll(this.parseSteps(entry.getValue(), entry.getKey()));
        }
        allSteps.sort();
        return allSteps;
    }

    public PipelineStepList getSteps(String stageId) {
        return this.getSteps(stageId, new PipelineNodeGraphAdapter(this.run));
    }

    public PipelineStepList getAllSteps() {
        return this.getAllSteps(new PipelineNodeGraphAdapter(this.run));
    }

    protected PipelineStepList getLegacySteps(String stageId) {
        return this.getSteps(stageId, new PipelineStepVisitor(this.run));
    }

    protected PipelineStepList getAllLegacySteps() {
        return this.getAllSteps(new PipelineStepVisitor(this.run));
    }
}

