/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import java.util.Locale;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;

public class AbstractPipelineNode {
    private String name;
    private String state;
    private String type;
    private String title;
    private String id;
    private long pauseDurationMillis;
    private long totalDurationMillis;
    private TimingInfo timingInfo;

    public AbstractPipelineNode(String id, String name, String state, String type, String title, TimingInfo timingInfo) {
        this.id = id;
        this.name = name;
        this.state = state.toLowerCase(Locale.ROOT);
        this.type = type;
        this.title = title;
        this.timingInfo = timingInfo;
        this.pauseDurationMillis = timingInfo.getPauseDurationMillis();
        this.totalDurationMillis = timingInfo.getTotalDurationMillis();
    }

    public long getPauseDurationMillis() {
        return this.pauseDurationMillis;
    }

    public long getStartTimeMillis() {
        return this.timingInfo.getStartTimeMillis();
    }

    public long getTotalDurationMillis() {
        return this.totalDurationMillis;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    protected TimingInfo getTimingInfo() {
        return this.timingInfo;
    }
}

