/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview;

import io.jenkins.plugins.pipelinegraphview.PipelineGraphViewConfiguration;
import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsCard;
import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.SCMRunDetailsItems;
import io.jenkins.plugins.pipelinegraphview.cards.items.TimingRunDetailsItems;
import io.jenkins.plugins.pipelinegraphview.cards.items.UpstreamCauseRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.UserIdCauseRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.utils.AbstractPipelineViewAction;
import java.util.ArrayList;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineGraphViewAction
extends AbstractPipelineViewAction {
    public PipelineGraphViewAction(WorkflowRun target) {
        super(target);
    }

    public String getDisplayName() {
        return "Pipeline Overview";
    }

    public String getUrlName() {
        return "pipeline-graph";
    }

    public String getUrl() {
        return this.run.getUrl();
    }

    public RunDetailsCard getRunDetailsCard() {
        ArrayList<RunDetailsItem> runDetailsItems = new ArrayList<RunDetailsItem>();
        runDetailsItems.addAll(SCMRunDetailsItems.get(this.run));
        if (!runDetailsItems.isEmpty()) {
            runDetailsItems.add(new RunDetailsItem.Builder().separator().build());
        }
        UpstreamCauseRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        UserIdCauseRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        runDetailsItems.addAll(TimingRunDetailsItems.get(this.run));
        return new RunDetailsCard(runDetailsItems);
    }

    public boolean isShowGraphOnBuildPage() {
        return PipelineGraphViewConfiguration.get().isShowGraphOnBuildPage();
    }
}

