/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils.legacy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.utils.BlueRun;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.NodeRunStatus;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepBuilderApi;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.ExecutionModelAction;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.graphanalysis.StandardChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StageChunkFinder;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStepVisitor
extends StandardChunkVisitor
implements PipelineStepBuilderApi {
    private final WorkflowRun run;
    private final ArrayDeque<FlowNodeWrapper> stageSteps = new ArrayDeque();
    private final Map<String, FlowNodeWrapper> stepMap = new HashMap<String, FlowNodeWrapper>();
    private final Map<String, List<FlowNodeWrapper>> stageStepMap = new HashMap<String, List<FlowNodeWrapper>>();
    private final ArrayDeque<FlowNode> pendingBlocks = new ArrayDeque();
    private FlowNode currentStage;
    private InputAction inputAction;
    private final boolean declarative;
    private ErrorAction unhandledException;
    private FlowNode nodeThatThrewException;
    private boolean isLastNode;
    private FlowExecution execution;
    private static final Logger logger = LoggerFactory.getLogger(PipelineStepVisitor.class);

    public PipelineStepVisitor(WorkflowRun run) {
        this.run = run;
        this.inputAction = (InputAction)run.getAction(InputAction.class);
        this.declarative = run.getAction(ExecutionModelAction.class) != null;
        this.isLastNode = true;
        this.execution = run.getExecution();
        if (this.execution != null) {
            try {
                ForkScanner.visitSimpleChunks((Collection)this.execution.getCurrentHeads(), (SimpleChunkVisitor)this, (ChunkFinder)new StageChunkFinder());
            }
            catch (Throwable t) {
                logger.debug("Caught a " + t.getClass().getSimpleName() + " traversing the graph for run " + run.getExternalizableId());
                throw t;
            }
        } else {
            logger.debug("Could not find execution for run " + run.getExternalizableId());
        }
    }

    public void parallelBranchStart(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchStartNode, @NonNull ForkScanner scanner) {
        FlowNode finishedBlock = null;
        if (!this.pendingBlocks.isEmpty()) {
            finishedBlock = this.pendingBlocks.pop();
            if (logger.isDebugEnabled()) {
                logger.debug("parallelBranchStart. Removed Node ID: " + finishedBlock.getId() + "(" + finishedBlock.getDisplayName() + "-) from pendingBlocks.");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("parallelBranchStart. Node ID: " + branchStartNode.getId() + " - " + branchStartNode.getDisplayName() + " - " + PipelineNodeUtil.isStage(branchStartNode) + " - " + PipelineNodeUtil.isParallelBranch(branchStartNode) + " - " + PipelineNodeUtil.isSyntheticStage(branchStartNode) + " .");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Pushing steps to stage in parallelBranchStart.");
        }
        this.pushStageStepsToMap(branchStartNode);
    }

    public void parallelBranchEnd(@NonNull FlowNode parallelStartNode, @NonNull FlowNode branchEndNode, @NonNull ForkScanner scanner) {
        if (branchEndNode instanceof StepEndNode) {
            BlockStartNode branchStartNode = ((StepEndNode)branchEndNode).getStartNode();
            if (logger.isDebugEnabled()) {
                logger.debug("Node ID: " + branchStartNode.getId() + " - " + PipelineNodeUtil.isStage((FlowNode)branchStartNode) + " - " + PipelineNodeUtil.isParallelBranch((FlowNode)branchStartNode) + " - " + PipelineNodeUtil.isSyntheticStage((FlowNode)branchStartNode) + " .");
            }
            this.pendingBlocks.push((FlowNode)branchStartNode);
        }
    }

    public void chunkStart(@NonNull FlowNode startNode, @CheckForNull FlowNode beforeBlock, @NonNull ForkScanner scanner) {
        super.chunkStart(startNode, beforeBlock, scanner);
        FlowNode finishedBlock = null;
        if (!this.pendingBlocks.isEmpty()) {
            finishedBlock = this.pendingBlocks.pop();
            if (logger.isDebugEnabled()) {
                logger.debug("chunkStart. Removed Node ID: " + finishedBlock.getId() + "(" + finishedBlock.getDisplayName() + "} from pendingBlocks.");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Node ID: " + startNode.getId() + " - " + startNode.getDisplayName() + " - " + PipelineNodeUtil.isStage(startNode) + " - " + PipelineNodeUtil.isParallelBranch(startNode) + " - " + PipelineNodeUtil.isSyntheticStage(startNode) + " .");
        }
        if (PipelineNodeUtil.isParallelBranch(this.pendingBlocks.peek()) && this.isDeclarative()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not pushing steps to stage '" + startNode.getDisplayName() + "' in chunkStart as parent is parallel block in declarative pipeline.");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Pushing step to stage in chunkStart.");
            }
            this.pushStageStepsToMap(startNode);
        }
    }

    public void chunkEnd(@NonNull FlowNode endNode, @CheckForNull FlowNode afterChunk, @NonNull ForkScanner scanner) {
        super.chunkEnd(endNode, afterChunk, scanner);
        if (endNode instanceof StepEndNode) {
            BlockStartNode startNode = ((StepEndNode)endNode).getStartNode();
            if (logger.isDebugEnabled()) {
                logger.debug("chunkEnd. Node ID: " + startNode.getId() + " - " + startNode.getDisplayName() + " - " + PipelineNodeUtil.isStage((FlowNode)startNode) + " - " + PipelineNodeUtil.isParallelBranch((FlowNode)startNode) + " - " + PipelineNodeUtil.isSyntheticStage((FlowNode)startNode) + " .");
            }
            this.pendingBlocks.push((FlowNode)startNode);
        }
        if (endNode instanceof StepEndNode && PipelineNodeUtil.isStage((FlowNode)((StepEndNode)endNode).getStartNode())) {
            this.currentStage = ((StepEndNode)endNode).getStartNode();
        } else {
            String id = endNode.getEnclosingId();
            this.currentStage = endNode.getEnclosingBlocks().stream().filter(block -> block.getId().equals(id)).findFirst().orElse(null);
        }
        if (this.isLastNode) {
            this.isLastNode = false;
            ErrorAction errorAction = (ErrorAction)endNode.getAction(ErrorAction.class);
            if (errorAction != null && !PipelineNodeUtil.isJenkinsFailureException(errorAction.getError())) {
                logger.debug("Found unhandled exception: " + errorAction.getError().getMessage());
                this.nodeThatThrewException = ErrorAction.findOrigin((Throwable)errorAction.getError(), (FlowExecution)this.execution);
                if (this.nodeThatThrewException != null) {
                    logger.debug("Found that node '" + this.nodeThatThrewException.getId() + "' threw unhandled exception: " + this.nodeThatThrewException.getDisplayName());
                }
            }
        }
        if (this.nodeThatThrewException == endNode) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found endNode that threw exception.");
            }
            this.pushExceptionNodeToStepsMap(endNode);
        }
        if (!(endNode instanceof BlockEndNode)) {
            this.atomNode(null, endNode, afterChunk, scanner);
        }
    }

    public void atomNode(@CheckForNull FlowNode before, @NonNull FlowNode atomNode, @CheckForNull FlowNode after, @NonNull ForkScanner scan) {
        long pause = PauseAction.getPauseDuration((FlowNode)atomNode);
        TimingInfo times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)pause, (FlowNode)atomNode, (FlowNode)atomNode, (FlowNode)after);
        if (times == null) {
            times = new TimingInfo();
        }
        InputStep inputStep = null;
        if (atomNode instanceof StepAtomNode && !PipelineNodeUtil.isSkippedStage(this.currentStage)) {
            NodeRunStatus status;
            if (PipelineNodeUtil.isPausedForInputStep((StepAtomNode)atomNode, this.inputAction)) {
                status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.PAUSED);
                try {
                    for (InputStepExecution execution : this.inputAction.getExecutions()) {
                        FlowNode node = (FlowNode)execution.getContext().get(FlowNode.class);
                        if (node == null || !node.equals((Object)atomNode)) continue;
                        inputStep = execution.getInput();
                    }
                }
                catch (IOException | InterruptedException | TimeoutException e) {
                    logger.error("Error getting FlowNode from execution context: " + e.getMessage(), (Throwable)e);
                }
            } else {
                status = new NodeRunStatus(atomNode);
            }
            FlowNodeWrapper stepNode = new FlowNodeWrapper(atomNode, status, times, inputStep, this.run);
            this.stepMap.put(stepNode.getId(), stepNode);
            if (logger.isDebugEnabled()) {
                logger.debug("Pushing step: " + stepNode.getId() + "(" + stepNode.getArgumentsAsString() + ") to stack.");
            }
            if (!this.stageSteps.contains(stepNode)) {
                this.stageSteps.push(stepNode);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Steps in stack:");
                for (FlowNodeWrapper step : this.stageSteps) {
                    logger.debug(" - " + step.getArgumentsAsString() + " - " + step.getId());
                }
            }
        }
        if (this.nodeThatThrewException == atomNode) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found atomNode that threw exception.");
            }
            this.pushExceptionNodeToStepsMap(atomNode);
        }
    }

    @Override
    public List<FlowNodeWrapper> getStageSteps(String startNodeId) {
        return this.stageStepMap.getOrDefault(startNodeId, new ArrayList());
    }

    @Override
    public Map<String, List<FlowNodeWrapper>> getAllSteps() {
        return this.stageStepMap;
    }

    public FlowNodeWrapper getStep(String id) {
        return this.stepMap.get(id);
    }

    public boolean isDeclarative() {
        return this.declarative;
    }

    private void pushStageStepsToMap(FlowNode stage) {
        List stageStepsList = this.stageStepMap.getOrDefault(stage.getId(), new ArrayList());
        for (FlowNodeWrapper step : this.stageSteps) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding step '" + step.getArgumentsAsString() + "' to '" + stage.getId() + "' (" + stage.getDisplayName() + ") .");
            }
            stageStepsList.add(step);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Assigning parent stage for " + this.stageSteps.size() + " steps.");
        }
        this.stageSteps.clear();
        this.stageStepMap.put(stage.getId(), stageStepsList);
    }

    private void pushExceptionNodeToStepsMap(FlowNode exceptionNode) {
        long pause = PauseAction.getPauseDuration((FlowNode)exceptionNode);
        TimingInfo times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)pause, (FlowNode)exceptionNode, (FlowNode)exceptionNode, null);
        if (times == null) {
            times = new TimingInfo();
        }
        NodeRunStatus status = new NodeRunStatus(exceptionNode);
        pause = PauseAction.getPauseDuration((FlowNode)exceptionNode);
        times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)pause, (FlowNode)exceptionNode, (FlowNode)exceptionNode, null);
        if (times == null) {
            times = new TimingInfo();
        }
        FlowNodeWrapper erroredStep = new FlowNodeWrapper(exceptionNode, status, times, null, this.run);
        this.stepMap.put(erroredStep.getId(), erroredStep);
        if (logger.isDebugEnabled()) {
            logger.debug("Found step exception from step: " + erroredStep.getId() + "(" + erroredStep.getArgumentsAsString() + ") to stack.\nError:\n" + erroredStep.nodeError());
        }
        if (!this.stageSteps.contains(erroredStep)) {
            this.stageSteps.push(erroredStep);
        }
    }

    static class LocalAtomNode
    extends AtomNode {
        private final String cause;

        public LocalAtomNode(MemoryFlowChunk chunk, String cause) {
            super(chunk.getFirstNode().getExecution(), UUID.randomUUID().toString(), new FlowNode[]{chunk.getFirstNode()});
            this.cause = cause;
        }

        protected String getTypeDisplayName() {
            return this.cause;
        }
    }
}

