/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.utils.PipelineStage;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;

public class PipelineStageInternal {
    private String name;
    private List<String> parents;
    private String state;
    private int completePercent;
    private String type;
    private String title;
    private String id;
    private String seqContainerName;
    private PipelineStageInternal nextSibling;
    private boolean sequential;
    private boolean synthetic;
    private TimingInfo timingInfo;
    private String agent;

    public PipelineStageInternal(String id, String name, List<String> parents, String state, int completePercent, String type, String title, boolean synthetic, TimingInfo times, String agent) {
        this.id = id;
        this.name = name;
        this.parents = parents;
        this.state = state.toLowerCase(Locale.ROOT);
        this.completePercent = completePercent;
        this.type = type;
        this.title = title;
        this.synthetic = synthetic;
        this.timingInfo = times;
        this.agent = agent;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setCompletePercent(int completePercent) {
        this.completePercent = completePercent;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNextSibling(PipelineStageInternal nextSibling) {
        this.nextSibling = nextSibling;
    }

    public void setSeqContainerName(String seqContainerName) {
        this.seqContainerName = seqContainerName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSeqContainerName() {
        return this.seqContainerName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public String getState() {
        return this.state;
    }

    public int getCompletePercent() {
        return this.completePercent;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String aAgent) {
        this.agent = aAgent;
    }

    public PipelineStage toPipelineStage(List<PipelineStage> children, String runUrl) {
        return new PipelineStage(this.id, this.name, children, this.state, this.completePercent, this.type, this.title, this.seqContainerName, this.nextSibling != null ? this.nextSibling.toPipelineStage(Collections.emptyList(), runUrl) : null, this.sequential, this.synthetic, this.timingInfo, this.agent, runUrl);
    }
}

