/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.AbortException;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.output.StringBuilderWriter;
import org.jenkinsci.plugins.pipeline.StageStatus;
import org.jenkinsci.plugins.pipeline.SyntheticStage;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.QueueItemAction;
import org.jenkinsci.plugins.workflow.actions.TagsAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStep;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;

public class PipelineNodeUtil {
    private static final String DECLARATIVE_DISPLAY_NAME_PREFIX = "Declarative: ";
    private static final String PARALLEL_SYNTHETIC_STAGE_NAME = "Parallel";
    public static final Predicate<FlowNode> isLoggable = input -> {
        if (input == null) {
            return false;
        }
        return input.getAction(LogAction.class) != null;
    };

    public static String getDisplayName(@NonNull FlowNode node) {
        ThreadNameAction threadNameAction = (ThreadNameAction)node.getAction(ThreadNameAction.class);
        String name = threadNameAction != null ? threadNameAction.getThreadName() : node.getDisplayName();
        return PipelineNodeUtil.isSyntheticStage(node) && name.startsWith(DECLARATIVE_DISPLAY_NAME_PREFIX) ? name.substring(DECLARATIVE_DISPLAY_NAME_PREFIX.length()) : name;
    }

    public static boolean isStep(FlowNode node) {
        if (node != null) {
            if (node instanceof AtomNode) {
                return true;
            }
            if (node instanceof StepStartNode) {
                StepStartNode stepStartNode = (StepStartNode)node;
                boolean takesImplicitBlockArgument = false;
                StepDescriptor sd = stepStartNode.getDescriptor();
                if (sd != null) {
                    takesImplicitBlockArgument = sd.takesImplicitBlockArgument();
                }
                return !PipelineNodeUtil.isStage(node) && !PipelineNodeUtil.isParallelBranch(node) && stepStartNode.isBody() && !takesImplicitBlockArgument;
            }
        }
        return false;
    }

    public static boolean isStage(FlowNode node) {
        if (node != null) {
            StepStartNode stepStartNode;
            if (node instanceof StepStartNode && (stepStartNode = (StepStartNode)node).getDescriptor() != null) {
                StepDescriptor sd = stepStartNode.getDescriptor();
                return sd != null && StageStep.DescriptorImpl.class.equals(sd.getClass()) && stepStartNode.isBody();
            }
            LabelAction labelAction = (LabelAction)node.getAction(LabelAction.class);
            ThreadNameAction threadNameAction = (ThreadNameAction)node.getAction(ThreadNameAction.class);
            return labelAction != null && PARALLEL_SYNTHETIC_STAGE_NAME.equals(labelAction.getDisplayName()) && threadNameAction == null;
        }
        return false;
    }

    public static boolean isSyntheticStage(@Nullable FlowNode node) {
        return node != null && PipelineNodeUtil.getSyntheticStage(node) != null;
    }

    @CheckForNull
    public static TagsAction getSyntheticStage(@Nullable FlowNode node) {
        if (node != null) {
            for (Action action : node.getActions()) {
                if (!(action instanceof TagsAction) || ((TagsAction)action).getTagValue("SYNTHETIC_STAGE") == null) continue;
                return (TagsAction)action;
            }
        }
        return null;
    }

    public static boolean isPostSyntheticStage(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        TagsAction tagsAction = PipelineNodeUtil.getSyntheticStage(node);
        if (tagsAction == null) {
            return false;
        }
        String value = tagsAction.getTagValue("SYNTHETIC_STAGE");
        return value != null && value.equals(SyntheticStage.getPost());
    }

    public static boolean isSkippedStage(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        for (Action action : node.getActions()) {
            if (!(action instanceof TagsAction) || ((TagsAction)action).getTagValue("STAGE_STATUS") == null) continue;
            TagsAction tagsAction = (TagsAction)action;
            String value = tagsAction.getTagValue("STAGE_STATUS");
            return value != null && (value.equals(StageStatus.getSkippedForConditional()) || value.equals(StageStatus.getSkippedForFailure()) || value.equals(StageStatus.getSkippedForUnstable()));
        }
        return false;
    }

    public static boolean isPreSyntheticStage(@Nullable FlowNode node) {
        if (node == null) {
            return false;
        }
        TagsAction tagsAction = PipelineNodeUtil.getSyntheticStage(node);
        if (tagsAction == null) {
            return false;
        }
        String value = tagsAction.getTagValue("SYNTHETIC_STAGE");
        return value != null && value.equals(SyntheticStage.getPre());
    }

    public static boolean isParallelBranch(@Nullable FlowNode node) {
        StepStartNode stepStartNode;
        if (node != null && node instanceof StepStartNode && (stepStartNode = (StepStartNode)node).getDescriptor() != null) {
            StepDescriptor sd = stepStartNode.getDescriptor();
            return sd != null && ParallelStep.DescriptorImpl.class.equals(sd.getClass()) && stepStartNode.isBody();
        }
        return false;
    }

    public static boolean isUnhandledException(@Nullable FlowNode node) {
        return node != null && node.getAction(ErrorAction.class) != null;
    }

    public static String getArgumentsAsString(@Nullable FlowNode node) {
        if (node != null) {
            return ArgumentsAction.getStepArgumentsAsString((FlowNode)node);
        }
        return "";
    }

    @CheckForNull
    public static String getCauseOfBlockage(@NonNull FlowNode stage, @Nullable FlowNode nodeBlock) {
        if (nodeBlock != null) {
            for (FlowNode p : nodeBlock.getParents()) {
                Queue.Item item;
                if (!p.equals((Object)stage) || (item = QueueItemAction.getQueueItem((FlowNode)nodeBlock)) == null) continue;
                CauseOfBlockage causeOfBlockage = item.getCauseOfBlockage();
                String cause = null;
                if (causeOfBlockage != null && (cause = causeOfBlockage.getShortDescription()) == null && (causeOfBlockage = item.task.getCauseOfBlockage()) != null) {
                    return causeOfBlockage.getShortDescription();
                }
                return cause;
            }
        }
        return null;
    }

    public static boolean isPausedForInputStep(@NonNull StepAtomNode step, @Nullable InputAction inputAction) {
        if (inputAction == null) {
            return false;
        }
        PauseAction pauseAction = (PauseAction)step.getAction(PauseAction.class);
        return pauseAction != null && pauseAction.isPaused() && pauseAction.getCause().equals("Input");
    }

    public static boolean isPaused(@NonNull FlowNode step) {
        PauseAction pauseAction = (PauseAction)step.getAction(PauseAction.class);
        return pauseAction != null && pauseAction.isPaused();
    }

    protected static boolean isParallelBlock(@NonNull FlowNode node) {
        StepStartNode stepStartNode;
        if (node != null && node instanceof StepStartNode && (stepStartNode = (StepStartNode)node).getDescriptor() != null) {
            StepDescriptor sd = stepStartNode.getDescriptor();
            return sd != null && ParallelStep.DescriptorImpl.class.equals(sd.getClass()) && !stepStartNode.isBody();
        }
        return false;
    }

    public static boolean isAgentStart(@Nullable FlowNode node) {
        StepStartNode stepStartNode;
        if (node != null && node instanceof StepStartNode && (stepStartNode = (StepStartNode)node).getDescriptor() != null) {
            StepDescriptor sd = stepStartNode.getDescriptor();
            return sd != null && ExecutorStep.DescriptorImpl.class.equals(sd.getClass()) && !stepStartNode.isBody();
        }
        return false;
    }

    public static AnnotatedLargeText<? extends FlowNode> getLogText(@Nullable FlowNode node) {
        LogAction logAction;
        if (node != null && (logAction = (LogAction)node.getAction(LogAction.class)) != null) {
            return logAction.getLogText();
        }
        return null;
    }

    public static String convertLogToString(AnnotatedLargeText<? extends FlowNode> log) throws IOException {
        return PipelineNodeUtil.convertLogToString(log, 0L, false);
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public static String convertLogToString(AnnotatedLargeText<? extends FlowNode> log, Long startByte, boolean html) throws IOException {
        StringBuilderWriter stringWriter = new StringBuilderWriter();
        if (html) {
            log.writeHtmlTo(startByte.longValue(), (Writer)stringWriter);
        } else {
            log.writeLogTo(startByte.longValue(), (Writer)stringWriter);
        }
        return stringWriter.toString();
    }

    public static String getExceptionText(@Nullable FlowNode node) {
        if (node != null) {
            Object log = null;
            ErrorAction error = (ErrorAction)node.getAction(ErrorAction.class);
            if (error != null) {
                Throwable exception = error.getError();
                if (PipelineNodeUtil.isJenkinsFailureException(exception)) {
                    log = exception.getMessage();
                } else {
                    log = "Found unhandled " + exception.getClass().getName() + " exception:\n";
                    String message = exception.getMessage();
                    if (message != null) {
                        log = (String)log + message + "\n\t";
                    }
                    log = (String)log + Arrays.stream(exception.getStackTrace()).map(s -> s.toString()).collect(Collectors.joining("\n\t"));
                }
            }
            return log;
        }
        return null;
    }

    public static boolean isJenkinsFailureException(Throwable exception) {
        return exception instanceof AbortException || exception instanceof FlowInterruptedException;
    }
}

