/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import hudson.Util;
import java.util.Date;
import java.util.Locale;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;

public class AbstractPipelineNode {
    private String name;
    private String state;
    private int completePercent;
    private String type;
    private String title;
    private String id;
    private String pauseDurationMillis;
    private String totalDurationMillis;
    private TimingInfo timingInfo;

    public AbstractPipelineNode(String id, String name, String state, int completePercent, String type, String title, TimingInfo timingInfo) {
        this.id = id;
        this.name = name;
        this.state = state.toLowerCase(Locale.ROOT);
        this.completePercent = completePercent;
        this.type = type;
        this.title = title;
        this.timingInfo = timingInfo;
        this.pauseDurationMillis = AbstractPipelineNode.getUserFriendlyPauseDuration(timingInfo.getPauseDurationMillis());
        this.totalDurationMillis = AbstractPipelineNode.getUserFriendlyDuration(timingInfo.getTotalDurationMillis());
    }

    protected static String getUserFriendlyPauseDuration(long pauseDurationMillis) {
        return "Queued " + Util.getTimeSpanString((long)pauseDurationMillis);
    }

    protected static String getUserFriendlyStartTime(long startTimeMillis) {
        return startTimeMillis == 0L ? "" : "Started " + Util.getTimeSpanString((long)Math.abs(startTimeMillis - new Date().getTime())) + " ago";
    }

    protected static String getUserFriendlyDuration(long totalDurationMillis) {
        return Util.getTimeSpanString((long)totalDurationMillis);
    }

    public String getPauseDurationMillis() {
        return this.pauseDurationMillis;
    }

    public String getStartTimeMillis() {
        return AbstractPipelineNode.getUserFriendlyStartTime(this.timingInfo.getStartTimeMillis());
    }

    public String getTotalDurationMillis() {
        return this.totalDurationMillis;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public int getCompletePercent() {
        return this.completePercent;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    protected TimingInfo getTimingInfo() {
        return this.timingInfo;
    }
}

