/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.consoleview;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.console.AnnotatedLargeText;
import hudson.util.HttpResponses;
import io.jenkins.plugins.pipelinegraphview.utils.AbstractPipelineViewAction;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepList;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.framework.io.CharSpool;
import org.kohsuke.stapler.framework.io.LineEndNormalizingWriter;
import org.kohsuke.stapler.verb.GET;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConsoleViewAction
extends AbstractPipelineViewAction {
    public static final long LOG_THRESHOLD = 153600L;
    public static final String URL_NAME = "pipeline-console";
    private static final Logger logger = LoggerFactory.getLogger(PipelineConsoleViewAction.class);
    private final WorkflowRun target;
    private final PipelineStepApi stepApi;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public PipelineConsoleViewAction(WorkflowRun target) {
        super(target);
        this.target = target;
        this.stepApi = new PipelineStepApi(target);
    }

    public String getDisplayName() {
        return "Pipeline Console";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @Override
    public String getIconClassName() {
        return "symbol-terminal-outline plugin-ionicons-api";
    }

    public String getDurationString() {
        return this.run.getDurationString();
    }

    public String getStartTimeString() {
        return this.run.getTimestampString();
    }

    public String getUrl() {
        return this.target.getUrl();
    }

    @GET
    @WebMethod(name={"steps"})
    public HttpResponse getSteps(StaplerRequest2 req) throws IOException {
        String nodeId = req.getParameter("nodeId");
        if (nodeId != null) {
            return HttpResponses.okJSON((JSONObject)this.getSteps(nodeId));
        }
        return HttpResponses.errorJSON((String)"Error getting console text");
    }

    private JSONObject getSteps(String nodeId) throws IOException {
        logger.debug("getSteps was passed nodeId '" + nodeId + "'.");
        PipelineStepList steps = this.stepApi.getSteps(nodeId);
        String stepsJson = MAPPER.writeValueAsString((Object)steps);
        if (logger.isDebugEnabled()) {
            logger.debug("Steps: '" + stepsJson + "'.");
        }
        return JSONObject.fromObject((Object)stepsJson);
    }

    @GET
    @WebMethod(name={"allSteps"})
    public HttpResponse getAllSteps(StaplerRequest2 req) throws IOException {
        return HttpResponses.okJSON((JSONObject)this.getAllSteps());
    }

    protected JSONObject getAllSteps() throws IOException {
        PipelineStepList steps = this.stepApi.getAllSteps();
        String stepsJson = MAPPER.writeValueAsString((Object)steps);
        if (logger.isDebugEnabled()) {
            logger.debug("Steps: '" + stepsJson + "'.");
        }
        return JSONObject.fromObject((Object)stepsJson);
    }

    @WebMethod(name={"log"})
    public HttpResponse getConsoleText(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        AnnotatedLargeText<? extends FlowNode> logText;
        block14: {
            String nodeId = req.getParameter("nodeId");
            if (nodeId == null) {
                logger.error("'consoleText' was not passed 'nodeId'.");
                return HttpResponses.errorJSON((String)"Error getting console text");
            }
            logger.debug("getConsoleText was passed node id '" + nodeId + "'.");
            logText = this.getLogForNode(nodeId);
            long count = 0L;
            PipelineStepList steps = this.stepApi.getSteps(nodeId);
            try (CharSpool spool = new CharSpool();){
                for (PipelineStep step : steps.getSteps()) {
                    AnnotatedLargeText<? extends FlowNode> logForNode = this.getLogForNode(String.valueOf(step.getId()));
                    if (logForNode == null) continue;
                    count += logForNode.writeLogTo(0L, (Writer)spool);
                }
                if (count <= 0L) break block14;
                rsp.setContentType("text/plain;charset=UTF-8");
                try (PrintWriter writer = rsp.getWriter();){
                    spool.flush();
                    spool.writeTo((Writer)new LineEndNormalizingWriter((Writer)writer));
                }
            }
        }
        if (logText != null) {
            return HttpResponses.text((String)PipelineNodeUtil.convertLogToString(logText));
        }
        return HttpResponses.text((String)"No logs found");
    }

    @GET
    @WebMethod(name={"consoleOutput"})
    public HttpResponse getConsoleOutput(StaplerRequest2 req) throws IOException {
        String nodeId = req.getParameter("nodeId");
        if (nodeId == null) {
            logger.error("'consoleJson' was not passed 'nodeId'.");
            return HttpResponses.errorJSON((String)"Error getting console json");
        }
        logger.debug("getConsoleOutput was passed node id '" + nodeId + "'.");
        Long startByte = PipelineConsoleViewAction.parseIntWithDefault(req.getParameter("startByte"), -153600L);
        JSONObject data = this.getConsoleOutputJson(nodeId, startByte);
        if (data == null) {
            return HttpResponses.errorJSON((String)"Something went wrong - check Jenkins logs.");
        }
        return HttpResponses.okJSON((JSONObject)data);
    }

    protected JSONObject getConsoleOutputJson(String nodeId, Long requestStartByte) throws IOException {
        Long startByte = 0L;
        long endByte = 0L;
        Object text = "";
        AnnotatedLargeText<? extends FlowNode> logText = this.getLogForNode(nodeId);
        if (logText != null) {
            long textLength = logText.length();
            if (requestStartByte > textLength) {
                logger.error("consoleJson - user requested startByte larger than console output.");
                return null;
            }
            if (requestStartByte < 0L) {
                logger.debug("consoleJson - requested negative startByte '" + requestStartByte + "'.");
                startByte = textLength + requestStartByte;
                if (startByte < 0L) {
                    logger.debug("consoleJson - requested negative startByte '" + requestStartByte + "' out of bounds, starting at 0.");
                    startByte = 0L;
                }
            } else {
                startByte = requestStartByte;
            }
            logger.debug("Returning '" + (textLength - startByte) + "' bytes from 'getConsoleOutput'.");
            text = PipelineNodeUtil.convertLogToString(logText, startByte, true);
            endByte = textLength;
        }
        if (this.isUnhandledException(nodeId)) {
            String nodeExceptionText = this.getNodeExceptionText(nodeId);
            if (nodeExceptionText != null) {
                text = (String)text + nodeExceptionText;
            }
            endByte += (long)((String)text).length();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("text", text);
        response.put("startByte", startByte);
        response.put("endByte", endByte);
        return JSONObject.fromObject(response);
    }

    private AnnotatedLargeText<? extends FlowNode> getLogForNode(String nodeId) throws IOException {
        FlowExecution execution = this.target.getExecution();
        if (execution != null) {
            logger.debug("getLogForNode found execution.");
            return PipelineNodeUtil.getLogText(execution.getNode(nodeId));
        }
        return null;
    }

    private String getNodeExceptionText(String nodeId) throws IOException {
        FlowExecution execution = this.target.getExecution();
        if (execution != null) {
            logger.debug("getNodeException found execution.");
            return PipelineNodeUtil.getExceptionText(execution.getNode(nodeId));
        }
        return null;
    }

    private boolean isUnhandledException(String nodeId) throws IOException {
        FlowExecution execution = this.target.getExecution();
        if (execution != null) {
            return PipelineNodeUtil.isUnhandledException(execution.getNode(nodeId));
        }
        return false;
    }

    private static long parseIntWithDefault(String s, long defaultValue) {
        try {
            logger.debug("Parsing user provided value of '" + s + "'");
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            logger.debug("Using default value of '" + defaultValue + "'");
            return defaultValue;
        }
    }
}

