/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.api;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleCounter;
import io.opentelemetry.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.opentelemetry.api.incubator.metrics.ExtendedLongCounter;
import io.opentelemetry.api.incubator.metrics.ExtendedLongHistogramBuilder;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.DoubleGauge;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongGauge;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfoBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ReconfigurableMeterProvider
implements MeterProvider {
    static final Logger logger = Logger.getLogger(ReconfigurableMeterProvider.class.getName());
    @GuardedBy(value="lock")
    private MeterProvider delegate;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentMap<InstrumentationScopeInfo, ReconfigurableMeter> meters = new ConcurrentHashMap<InstrumentationScopeInfo, ReconfigurableMeter>();

    public ReconfigurableMeterProvider() {
        this(MeterProvider.noop());
    }

    public ReconfigurableMeterProvider(MeterProvider delegate) {
        this.delegate = delegate;
    }

    public Meter get(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            Meter meter = this.meters.computeIfAbsent(InstrumentationScopeInfo.create((String)instrumentationScopeName), instrumentationScopeInfo -> new ReconfigurableMeter(this.delegate.get(instrumentationScopeInfo.getName()), this.lock));
            return meter;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDelegate(MeterProvider delegate) {
        this.lock.writeLock().lock();
        try {
            this.delegate = delegate;
            this.meters.forEach((instrumentationScopeInfo, reconfigurableMeter) -> {
                MeterBuilder meterBuilder = delegate.meterBuilder(instrumentationScopeInfo.getName());
                Optional.ofNullable(instrumentationScopeInfo.getVersion()).ifPresent(arg_0 -> ((MeterBuilder)meterBuilder).setInstrumentationVersion(arg_0));
                Optional.ofNullable(instrumentationScopeInfo.getSchemaUrl()).ifPresent(arg_0 -> ((MeterBuilder)meterBuilder).setSchemaUrl(arg_0));
                reconfigurableMeter.setDelegate(meterBuilder.build());
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public MeterBuilder meterBuilder(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            ReconfigurableMeterBuilder reconfigurableMeterBuilder = new ReconfigurableMeterBuilder(this.delegate.meterBuilder(instrumentationScopeName), instrumentationScopeName, this.lock);
            return reconfigurableMeterBuilder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MeterProvider getDelegate() {
        this.lock.readLock().lock();
        try {
            MeterProvider meterProvider = this.delegate;
            return meterProvider;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    protected class ReconfigurableMeterBuilder
    implements MeterBuilder {
        final ReadWriteLock lock;
        final MeterBuilder delegate;
        final InstrumentationScopeInfoBuilder instrumentationScopeInfoBuilder;

        public ReconfigurableMeterBuilder(MeterBuilder delegate, String instrumentationScopeName, ReadWriteLock lock) {
            this.delegate = Objects.requireNonNull(delegate);
            this.instrumentationScopeInfoBuilder = InstrumentationScopeInfo.builder((String)instrumentationScopeName);
            this.lock = lock;
        }

        public MeterBuilder setSchemaUrl(String schemaUrl) {
            this.lock.readLock().lock();
            try {
                this.delegate.setSchemaUrl(schemaUrl);
                this.instrumentationScopeInfoBuilder.setSchemaUrl(schemaUrl);
                ReconfigurableMeterBuilder reconfigurableMeterBuilder = this;
                return reconfigurableMeterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public MeterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.lock.readLock().lock();
            try {
                this.delegate.setInstrumentationVersion(instrumentationScopeVersion);
                this.instrumentationScopeInfoBuilder.setVersion(instrumentationScopeVersion);
                ReconfigurableMeterBuilder reconfigurableMeterBuilder = this;
                return reconfigurableMeterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public Meter build() {
            this.lock.readLock().lock();
            try {
                InstrumentationScopeInfo instrumentationScopeInfo = this.instrumentationScopeInfoBuilder.build();
                Meter meter = ReconfigurableMeterProvider.this.meters.computeIfAbsent(instrumentationScopeInfo, k -> new ReconfigurableMeter(this.delegate.build(), this.lock));
                return meter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @ThreadSafe
    @VisibleForTesting
    protected static class ReconfigurableMeter
    implements Meter {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        Meter delegate;
        final ConcurrentMap<InstrumentKey, ReconfigurableLongCounter> longCounters = new ConcurrentHashMap<InstrumentKey, ReconfigurableLongCounter>();
        final ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongCounter> observableLongCounters = new ConcurrentHashMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongCounter>();
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongCounterMeasurements = new ConcurrentHashMap<InstrumentKey, ReconfigurableObservableLongMeasurement>();
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleCounter> doubleCounters = new ConcurrentHashMap<InstrumentKey, ReconfigurableDoubleCounter>();
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleCounter> observableDoubleCounters = new ConcurrentHashMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleCounter>();
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleCounterMeasurements = new ConcurrentHashMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement>();
        final ConcurrentMap<InstrumentKey, ReconfigurableLongGauge> longGauges = new ConcurrentHashMap<InstrumentKey, ReconfigurableLongGauge>();
        final ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongGauge> observableLongGauges = new ConcurrentHashMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongGauge>();
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongGaugeMeasurements = new ConcurrentHashMap<InstrumentKey, ReconfigurableObservableLongMeasurement>();
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleGauge> doubleGauges = new ConcurrentHashMap<InstrumentKey, ReconfigurableDoubleGauge>();
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleGauge> observableDoubleGauges = new ConcurrentHashMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleGauge>();
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleGaugeMeasurements = new ConcurrentHashMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement>();
        final ConcurrentMap<InstrumentKey, ReconfigurableLongUpDownCounter> longUpDownCounters = new ConcurrentHashMap<InstrumentKey, ReconfigurableLongUpDownCounter>();
        final ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongUpDownCounter> observableLongUpDownCounters = new ConcurrentHashMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongUpDownCounter>();
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongUpDownCounterMeasurements = new ConcurrentHashMap<InstrumentKey, ReconfigurableObservableLongMeasurement>();
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleUpDownCounter> doubleUpDownCounters = new ConcurrentHashMap<InstrumentKey, ReconfigurableDoubleUpDownCounter>();
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleUpDownCounter> observableDoubleUpDownCounters = new ConcurrentHashMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleUpDownCounter>();
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleUpDownCounterMeasurements = new ConcurrentHashMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement>();
        final ConcurrentMap<HistogramKey<Long>, ReconfigurableLongHistogram> longHistograms = new ConcurrentHashMap<HistogramKey<Long>, ReconfigurableLongHistogram>();
        final ConcurrentMap<HistogramKey<Double>, ReconfigurableDoubleHistogram> doubleHistograms = new ConcurrentHashMap<HistogramKey<Double>, ReconfigurableDoubleHistogram>();
        final ConcurrentMap<BatchCallbackKey, ReconfigurableBatchCallback> batchCallbacks = new ConcurrentHashMap<BatchCallbackKey, ReconfigurableBatchCallback>();

        public ReconfigurableMeter(Meter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
            this.lock.readLock().lock();
            try {
                BatchCallbackKey key = new BatchCallbackKey(callback, observableMeasurement, additionalMeasurements);
                Object originalObservableMeasurement = ((ReconfigurableObservableMeasurement)observableMeasurement).getDelegate();
                ObservableMeasurement[] originalAdditionalMeasurements = (ObservableMeasurement[])Arrays.stream(additionalMeasurements).map(additionalMeasurement -> ((ReconfigurableObservableMeasurement)additionalMeasurement).getDelegate()).toArray(ObservableMeasurement[]::new);
                BatchCallback batchCallback = this.batchCallbacks.computeIfAbsent(key, k -> new ReconfigurableBatchCallback(this.delegate.batchCallback(callback, originalObservableMeasurement, originalAdditionalMeasurements), this.lock));
                return batchCallback;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleGaugeBuilder gaugeBuilder(String name) {
            this.lock.readLock().lock();
            try {
                ReconfigurableDoubleGaugeBuilder reconfigurableDoubleGaugeBuilder = new ReconfigurableDoubleGaugeBuilder(this.delegate.gaugeBuilder(name), name, this.doubleGauges, this.observableDoubleGauges, this.observableDoubleGaugeMeasurements, this.longGauges, this.observableLongGauges, this.observableLongGaugeMeasurements, this.lock);
                return reconfigurableDoubleGaugeBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DoubleHistogramBuilder histogramBuilder(String name) {
            this.lock.readLock().lock();
            try {
                DoubleHistogramBuilder doubleHistogramBuilder = this.delegate.histogramBuilder(name);
                if (doubleHistogramBuilder instanceof ExtendedDoubleHistogramBuilder) {
                    ExtendedDoubleHistogramBuilder histogramBuilder = (ExtendedDoubleHistogramBuilder)doubleHistogramBuilder;
                    ReconfigurableDoubleHistogramBuilder reconfigurableDoubleHistogramBuilder = new ReconfigurableDoubleHistogramBuilder((DoubleHistogramBuilder)histogramBuilder, name, this.doubleHistograms, this.longHistograms, this.lock);
                    return reconfigurableDoubleHistogramBuilder;
                }
                ReconfigurableDoubleHistogramBuilder reconfigurableDoubleHistogramBuilder = new ReconfigurableDoubleHistogramBuilder(doubleHistogramBuilder, name, this.doubleHistograms, this.longHistograms, this.lock);
                return reconfigurableDoubleHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
            this.lock.readLock().lock();
            try {
                ReconfigurableLongUpDownCounterBuilder reconfigurableLongUpDownCounterBuilder = new ReconfigurableLongUpDownCounterBuilder(this.delegate.upDownCounterBuilder(name), name, this.longUpDownCounters, this.doubleUpDownCounters, this.observableLongUpDownCounters, this.observableLongUpDownCounterMeasurements, this.observableDoubleUpDownCounters, this.observableDoubleUpDownCounterMeasurements, this.lock);
                return reconfigurableLongUpDownCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongCounterBuilder counterBuilder(String name) {
            this.lock.readLock().lock();
            try {
                ReconfigurableLongCounterBuilder reconfigurableLongCounterBuilder = new ReconfigurableLongCounterBuilder(this.delegate.counterBuilder(name), name, this.longCounters, this.doubleCounters, this.observableLongCounters, this.observableLongCounterMeasurements, this.observableDoubleCounters, this.observableDoubleCounterMeasurements, this.lock);
                return reconfigurableLongCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(Meter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
                this.longCounters.forEach((counterKey, reconfigurableLongCounter) -> {
                    LongCounterBuilder longCounterBuilder = delegate.counterBuilder(counterKey.name);
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((LongCounterBuilder)longCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((LongCounterBuilder)longCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring long counter " + counterKey.name);
                    reconfigurableLongCounter.setDelegate(longCounterBuilder.build());
                });
                this.observableLongCounters.forEach((callbackKey, reconfigurableObservableLongCounter) -> {
                    LongCounterBuilder longCounterBuilder = delegate.counterBuilder(callbackKey.name);
                    Optional.ofNullable(callbackKey.description).ifPresent(arg_0 -> ((LongCounterBuilder)longCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(callbackKey.unit).ifPresent(arg_0 -> ((LongCounterBuilder)longCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable long counter " + callbackKey.name);
                    reconfigurableObservableLongCounter.setDelegate(longCounterBuilder.buildWithCallback(callbackKey.callback));
                });
                this.observableLongCounterMeasurements.forEach((counterKey, reconfigurableObservableLongMeasurement) -> {
                    LongCounterBuilder longCounterBuilder = delegate.counterBuilder(counterKey.name);
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((LongCounterBuilder)longCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((LongCounterBuilder)longCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable long measurement " + counterKey.name);
                    reconfigurableObservableLongMeasurement.setDelegate(longCounterBuilder.buildObserver());
                });
                this.doubleCounters.forEach((counterKey, reconfigurableDoubleCounter) -> {
                    DoubleCounterBuilder doubleCounterBuilder = delegate.counterBuilder(counterKey.name).ofDoubles();
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((DoubleCounterBuilder)doubleCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((DoubleCounterBuilder)doubleCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring double counter " + counterKey.name);
                    reconfigurableDoubleCounter.setDelegate(doubleCounterBuilder.build());
                });
                this.observableDoubleCounters.forEach((callbackKey, reconfigurableObservableDoubleCounter) -> {
                    DoubleCounterBuilder doubleCounterBuilder = delegate.counterBuilder(callbackKey.name).ofDoubles();
                    Optional.ofNullable(callbackKey.description).ifPresent(arg_0 -> ((DoubleCounterBuilder)doubleCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(callbackKey.unit).ifPresent(arg_0 -> ((DoubleCounterBuilder)doubleCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable double counter " + callbackKey.name);
                    reconfigurableObservableDoubleCounter.setDelegate(doubleCounterBuilder.buildWithCallback(callbackKey.callback));
                });
                this.observableDoubleCounterMeasurements.forEach((counterKey, reconfigurableObservableDoubleMeasurement) -> {
                    DoubleCounterBuilder doubleCounterBuilder = delegate.counterBuilder(counterKey.name).ofDoubles();
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((DoubleCounterBuilder)doubleCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((DoubleCounterBuilder)doubleCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable double measurement " + counterKey.name);
                    reconfigurableObservableDoubleMeasurement.setDelegate(doubleCounterBuilder.buildObserver());
                });
                this.doubleGauges.forEach((counterKey, reconfigurableDoubleGauge) -> {
                    DoubleGaugeBuilder doubleGaugeBuilder = delegate.gaugeBuilder(counterKey.name);
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((DoubleGaugeBuilder)doubleGaugeBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((DoubleGaugeBuilder)doubleGaugeBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring double gauge " + counterKey.name);
                    reconfigurableDoubleGauge.setDelegate(doubleGaugeBuilder.build());
                });
                this.observableDoubleGauges.forEach((callbackKey, reconfigurableObservableDoubleGauge) -> {
                    DoubleGaugeBuilder doubleGaugeBuilder = delegate.gaugeBuilder(callbackKey.name);
                    Optional.ofNullable(callbackKey.description).ifPresent(arg_0 -> ((DoubleGaugeBuilder)doubleGaugeBuilder).setDescription(arg_0));
                    Optional.ofNullable(callbackKey.unit).ifPresent(arg_0 -> ((DoubleGaugeBuilder)doubleGaugeBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable double gauge " + callbackKey.name);
                    reconfigurableObservableDoubleGauge.setDelegate(doubleGaugeBuilder.buildWithCallback(callbackKey.callback));
                });
                this.observableDoubleGaugeMeasurements.forEach((counterKey, reconfigurableObservableDoubleMeasurement) -> {
                    DoubleGaugeBuilder doubleGaugeBuilder = delegate.gaugeBuilder(counterKey.name);
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((DoubleGaugeBuilder)doubleGaugeBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((DoubleGaugeBuilder)doubleGaugeBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable double measurement " + counterKey.name);
                    reconfigurableObservableDoubleMeasurement.setDelegate(doubleGaugeBuilder.buildObserver());
                });
                this.longGauges.forEach((counterKey, reconfigurableLongGauge) -> {
                    LongGaugeBuilder longGaugeBuilder = delegate.gaugeBuilder(counterKey.name).ofLongs();
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((LongGaugeBuilder)longGaugeBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((LongGaugeBuilder)longGaugeBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring long gauge " + counterKey.name);
                    reconfigurableLongGauge.setDelegate(longGaugeBuilder.build());
                });
                this.observableLongGauges.forEach((callbackKey, reconfigurableObservableLongGauge) -> {
                    LongGaugeBuilder longGaugeBuilder = delegate.gaugeBuilder(callbackKey.name).ofLongs();
                    Optional.ofNullable(callbackKey.description).ifPresent(arg_0 -> ((LongGaugeBuilder)longGaugeBuilder).setDescription(arg_0));
                    Optional.ofNullable(callbackKey.unit).ifPresent(arg_0 -> ((LongGaugeBuilder)longGaugeBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable long gauge " + callbackKey.name);
                    reconfigurableObservableLongGauge.setDelegate(longGaugeBuilder.buildWithCallback(callbackKey.callback));
                });
                this.observableLongGaugeMeasurements.forEach((counterKey, reconfigurableObservableLongMeasurement) -> {
                    LongGaugeBuilder longGaugeBuilder = delegate.gaugeBuilder(counterKey.name).ofLongs();
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((LongGaugeBuilder)longGaugeBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((LongGaugeBuilder)longGaugeBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable long measurement " + counterKey.name);
                    reconfigurableObservableLongMeasurement.setDelegate(longGaugeBuilder.buildObserver());
                });
                this.longUpDownCounters.forEach((counterKey, reconfigurableLongUpDownCounter) -> {
                    LongUpDownCounterBuilder longUpDownCounterBuilder = delegate.upDownCounterBuilder(counterKey.name);
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((LongUpDownCounterBuilder)longUpDownCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((LongUpDownCounterBuilder)longUpDownCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring long updown counter " + counterKey.name);
                    reconfigurableLongUpDownCounter.setDelegate(longUpDownCounterBuilder.build());
                });
                this.observableLongUpDownCounters.forEach((callbackKey, reconfigurableObservableLongUpDownCounter) -> {
                    LongUpDownCounterBuilder longUpDownCounterBuilder = delegate.upDownCounterBuilder(callbackKey.name);
                    Optional.ofNullable(callbackKey.description).ifPresent(arg_0 -> ((LongUpDownCounterBuilder)longUpDownCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(callbackKey.unit).ifPresent(arg_0 -> ((LongUpDownCounterBuilder)longUpDownCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable long updown counter " + callbackKey.name);
                    reconfigurableObservableLongUpDownCounter.setDelegate(longUpDownCounterBuilder.buildWithCallback(callbackKey.callback));
                });
                this.observableLongUpDownCounterMeasurements.forEach((counterKey, reconfigurableObservableLongMeasurement) -> {
                    LongUpDownCounterBuilder longUpDownCounterBuilder = delegate.upDownCounterBuilder(counterKey.name);
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((LongUpDownCounterBuilder)longUpDownCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((LongUpDownCounterBuilder)longUpDownCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable long updown measurement " + counterKey.name);
                    reconfigurableObservableLongMeasurement.setDelegate(longUpDownCounterBuilder.buildObserver());
                });
                this.doubleUpDownCounters.forEach((counterKey, reconfigurableDoubleUpDownCounter) -> {
                    DoubleUpDownCounterBuilder doubleUpDownCounterBuilder = delegate.upDownCounterBuilder(counterKey.name).ofDoubles();
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((DoubleUpDownCounterBuilder)doubleUpDownCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((DoubleUpDownCounterBuilder)doubleUpDownCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring double updown counter " + counterKey.name);
                    reconfigurableDoubleUpDownCounter.setDelegate(doubleUpDownCounterBuilder.build());
                });
                this.observableDoubleUpDownCounters.forEach((callbackKey, reconfigurableObservableDoubleUpDownCounter) -> {
                    DoubleUpDownCounterBuilder doubleUpDownCounterBuilder = delegate.upDownCounterBuilder(callbackKey.name).ofDoubles();
                    Optional.ofNullable(callbackKey.description).ifPresent(arg_0 -> ((DoubleUpDownCounterBuilder)doubleUpDownCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(callbackKey.unit).ifPresent(arg_0 -> ((DoubleUpDownCounterBuilder)doubleUpDownCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable double updown counter " + callbackKey.name);
                    reconfigurableObservableDoubleUpDownCounter.setDelegate(doubleUpDownCounterBuilder.buildWithCallback(callbackKey.callback));
                });
                this.observableDoubleUpDownCounterMeasurements.forEach((counterKey, reconfigurableObservableDoubleMeasurement) -> {
                    DoubleUpDownCounterBuilder doubleUpDownCounterBuilder = delegate.upDownCounterBuilder(counterKey.name).ofDoubles();
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((DoubleUpDownCounterBuilder)doubleUpDownCounterBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((DoubleUpDownCounterBuilder)doubleUpDownCounterBuilder).setUnit(arg_0));
                    logger.log(Level.FINE, () -> "Reconfiguring observable double updown measurement " + counterKey.name);
                    reconfigurableObservableDoubleMeasurement.setDelegate(doubleUpDownCounterBuilder.buildObserver());
                });
                this.longHistograms.forEach((histogramKey, reconfigurableLongHistogram) -> {
                    LongHistogramBuilder longHistogramBuilder = delegate.histogramBuilder(histogramKey.name).ofLongs();
                    Optional.ofNullable(histogramKey.description).ifPresent(arg_0 -> ((LongHistogramBuilder)longHistogramBuilder).setDescription(arg_0));
                    Optional.ofNullable(histogramKey.unit).ifPresent(arg_0 -> ((LongHistogramBuilder)longHistogramBuilder).setUnit(arg_0));
                    Optional.ofNullable(histogramKey.bucketBoundaries).ifPresent(arg_0 -> ((LongHistogramBuilder)longHistogramBuilder).setExplicitBucketBoundariesAdvice(arg_0));
                    if (longHistogramBuilder instanceof ExtendedLongHistogramBuilder) {
                        Optional.ofNullable(histogramKey.attributes).ifPresent(arg_0 -> ((ExtendedLongHistogramBuilder)((ExtendedLongHistogramBuilder)longHistogramBuilder)).setAttributesAdvice(arg_0));
                    }
                    logger.log(Level.FINE, () -> "Reconfiguring long histogram " + histogramKey.name);
                    reconfigurableLongHistogram.setDelegate(longHistogramBuilder.build());
                });
                this.doubleHistograms.forEach((counterKey, reconfigurableDoubleHistogram) -> {
                    DoubleHistogramBuilder doubleHistogramBuilder = delegate.histogramBuilder(counterKey.name);
                    Optional.ofNullable(counterKey.description).ifPresent(arg_0 -> ((DoubleHistogramBuilder)doubleHistogramBuilder).setDescription(arg_0));
                    Optional.ofNullable(counterKey.unit).ifPresent(arg_0 -> ((DoubleHistogramBuilder)doubleHistogramBuilder).setUnit(arg_0));
                    Optional.ofNullable(counterKey.bucketBoundaries).ifPresent(arg_0 -> ((DoubleHistogramBuilder)doubleHistogramBuilder).setExplicitBucketBoundariesAdvice(arg_0));
                    if (doubleHistogramBuilder instanceof ExtendedDoubleHistogramBuilder) {
                        Optional.ofNullable(counterKey.attributes).ifPresent(arg_0 -> ((ExtendedDoubleHistogramBuilder)((ExtendedDoubleHistogramBuilder)doubleHistogramBuilder)).setAttributesAdvice(arg_0));
                    }
                    logger.log(Level.FINE, () -> "Reconfiguring double histogram " + counterKey.name);
                    reconfigurableDoubleHistogram.setDelegate(doubleHistogramBuilder.build());
                });
                this.batchCallbacks.forEach((batchCallbackKey, reconfigurableBatchCallback) -> {
                    reconfigurableBatchCallback.close();
                    Object originalObservableMeasurement = ((ReconfigurableObservableMeasurement)batchCallbackKey.observableMeasurement).getDelegate();
                    ObservableMeasurement[] originalAdditionalMeasurements = (ObservableMeasurement[])Arrays.stream(batchCallbackKey.additionalObservableMeasurements).map(additionalMeasurement -> ((ReconfigurableObservableMeasurement)additionalMeasurement).getDelegate()).toArray(ObservableMeasurement[]::new);
                    logger.log(Level.FINE, () -> "Reconfiguring batch callback " + String.valueOf(batchCallbackKey.observableMeasurement) + " " + Arrays.toString(batchCallbackKey.additionalObservableMeasurements));
                    reconfigurableBatchCallback.setDelegate(delegate.batchCallback(batchCallbackKey.callback, originalObservableMeasurement, originalAdditionalMeasurements));
                });
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public synchronized Meter getDelegate() {
            this.lock.readLock().lock();
            try {
                Meter meter = this.delegate;
                return meter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static interface ReconfigurableObservableMeasurement<T extends ObservableMeasurement>
    extends ObservableMeasurement {
        public void setDelegate(T var1);

        public T getDelegate();
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableLongHistogram
    implements LongHistogram {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private LongHistogram delegate;

        ReconfigurableLongHistogram(LongHistogram delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void record(long value) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(long value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(long value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(LongHistogram delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public LongHistogram getDelegate() {
            this.lock.readLock().lock();
            try {
                LongHistogram longHistogram = this.delegate;
                return longHistogram;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableLongHistogramBuilder
    implements ExtendedLongHistogramBuilder {
        final ReadWriteLock lock;
        LongHistogramBuilder delegate;
        final ConcurrentMap<HistogramKey<Long>, ReconfigurableLongHistogram> longHistograms;
        final String name;
        String description;
        String unit;
        List<Long> bucketBoundaries;
        List<AttributeKey<?>> attributes;

        ReconfigurableLongHistogramBuilder(LongHistogramBuilder delegate, String name, ConcurrentMap<HistogramKey<Long>, ReconfigurableLongHistogram> longHistograms, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.longHistograms = longHistograms;
            this.lock = lock;
        }

        public LongHistogramBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableLongHistogramBuilder reconfigurableLongHistogramBuilder = this;
                return reconfigurableLongHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongHistogramBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableLongHistogramBuilder reconfigurableLongHistogramBuilder = this;
                return reconfigurableLongHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ExtendedLongHistogramBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.lock.readLock().lock();
            try {
                if (this.delegate instanceof ExtendedLongHistogramBuilder) {
                    ((ExtendedLongHistogramBuilder)this.delegate).setAttributesAdvice(attributes);
                }
                this.attributes = attributes;
                ReconfigurableLongHistogramBuilder reconfigurableLongHistogramBuilder = this;
                return reconfigurableLongHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongHistogramBuilder setExplicitBucketBoundariesAdvice(List<Long> bucketBoundaries) {
            this.lock.readLock().lock();
            try {
                this.delegate.setExplicitBucketBoundariesAdvice(bucketBoundaries);
                this.bucketBoundaries = bucketBoundaries;
                ReconfigurableLongHistogramBuilder reconfigurableLongHistogramBuilder = this;
                return reconfigurableLongHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongHistogram build() {
            this.lock.readLock().lock();
            try {
                HistogramKey<Long> longHistogramKey = new HistogramKey<Long>(this.name, this.description, this.unit, this.attributes, this.bucketBoundaries);
                LongHistogram longHistogram = this.longHistograms.computeIfAbsent(longHistogramKey, k -> new ReconfigurableLongHistogram(this.delegate.build(), this.lock));
                return longHistogram;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableDoubleHistogram
    implements DoubleHistogram {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private DoubleHistogram delegate;

        ReconfigurableDoubleHistogram(DoubleHistogram delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void record(double value) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(double value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(double value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(DoubleHistogram delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public DoubleHistogram getDelegate() {
            this.lock.readLock().lock();
            try {
                DoubleHistogram doubleHistogram = this.delegate;
                return doubleHistogram;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableDoubleHistogramBuilder
    implements ExtendedDoubleHistogramBuilder {
        final ReadWriteLock lock;
        DoubleHistogramBuilder delegate;
        final ConcurrentMap<HistogramKey<Double>, ReconfigurableDoubleHistogram> doubleHistograms;
        final ConcurrentMap<HistogramKey<Long>, ReconfigurableLongHistogram> longHistograms;
        final String name;
        String description;
        String unit;
        List<AttributeKey<?>> attributes;
        List<Double> bucketBoundaries;

        ReconfigurableDoubleHistogramBuilder(DoubleHistogramBuilder delegate, String name, ConcurrentMap<HistogramKey<Double>, ReconfigurableDoubleHistogram> doubleHistograms, ConcurrentMap<HistogramKey<Long>, ReconfigurableLongHistogram> longHistograms, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.doubleHistograms = doubleHistograms;
            this.longHistograms = longHistograms;
            this.lock = lock;
        }

        public DoubleHistogramBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableDoubleHistogramBuilder reconfigurableDoubleHistogramBuilder = this;
                return reconfigurableDoubleHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleHistogramBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableDoubleHistogramBuilder reconfigurableDoubleHistogramBuilder = this;
                return reconfigurableDoubleHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ExtendedDoubleHistogramBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.lock.readLock().lock();
            try {
                if (this.delegate instanceof ExtendedDoubleHistogramBuilder) {
                    ((ExtendedDoubleHistogramBuilder)this.delegate).setAttributesAdvice(attributes);
                }
                this.attributes = attributes;
                ReconfigurableDoubleHistogramBuilder reconfigurableDoubleHistogramBuilder = this;
                return reconfigurableDoubleHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongHistogramBuilder ofLongs() {
            this.lock.readLock().lock();
            try {
                ReconfigurableLongHistogramBuilder reconfigurableLongCounterBuilder = new ReconfigurableLongHistogramBuilder(this.delegate.ofLongs(), this.name, this.longHistograms, this.lock);
                Optional.ofNullable(this.description).ifPresent(reconfigurableLongCounterBuilder::setDescription);
                Optional.ofNullable(this.unit).ifPresent(reconfigurableLongCounterBuilder::setUnit);
                if (reconfigurableLongCounterBuilder.delegate instanceof ExtendedLongHistogramBuilder) {
                    Optional.ofNullable(this.attributes).ifPresent(arg_0 -> ((ExtendedLongHistogramBuilder)((ExtendedLongHistogramBuilder)reconfigurableLongCounterBuilder.delegate)).setAttributesAdvice(arg_0));
                }
                ReconfigurableLongHistogramBuilder reconfigurableLongHistogramBuilder = reconfigurableLongCounterBuilder;
                return reconfigurableLongHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleHistogram build() {
            this.lock.readLock().lock();
            try {
                HistogramKey<Double> doubleHistogramKey = new HistogramKey<Double>(this.name, this.description, this.unit, this.attributes, this.bucketBoundaries);
                DoubleHistogram doubleHistogram = this.doubleHistograms.computeIfAbsent(doubleHistogramKey, k -> new ReconfigurableDoubleHistogram(this.delegate.build(), this.lock));
                return doubleHistogram;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleHistogramBuilder setExplicitBucketBoundariesAdvice(List<Double> bucketBoundaries) {
            this.lock.readLock().lock();
            try {
                this.delegate.setExplicitBucketBoundariesAdvice(bucketBoundaries);
                this.bucketBoundaries = bucketBoundaries;
                ReconfigurableDoubleHistogramBuilder reconfigurableDoubleHistogramBuilder = this;
                return reconfigurableDoubleHistogramBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class BatchCallbackKey {
        final Runnable callback;
        final ObservableMeasurement observableMeasurement;
        final ObservableMeasurement[] additionalObservableMeasurements;

        public BatchCallbackKey(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalObservableMeasurements) {
            this.callback = callback;
            this.observableMeasurement = Objects.requireNonNull(observableMeasurement);
            this.additionalObservableMeasurements = Objects.requireNonNull(additionalObservableMeasurements);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BatchCallbackKey that = (BatchCallbackKey)o;
            return Objects.equals(this.callback, that.callback) && Objects.equals(this.observableMeasurement, that.observableMeasurement) && Objects.deepEquals(this.additionalObservableMeasurements, that.additionalObservableMeasurements);
        }

        public int hashCode() {
            return Objects.hash(this.callback, this.observableMeasurement, Arrays.hashCode(this.additionalObservableMeasurements));
        }
    }

    static class ReconfigurableBatchCallback
    implements BatchCallback {
        final ReadWriteLock lock;
        BatchCallback delegate;

        ReconfigurableBatchCallback(BatchCallback delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void close() {
            this.lock.readLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(BatchCallback delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    static class ReconfigurableDoubleUpDownCounterBuilder
    implements DoubleUpDownCounterBuilder {
        final ReadWriteLock lock;
        DoubleUpDownCounterBuilder delegate;
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleUpDownCounter> doubleUpDownCounters;
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleUpDownCounter> observableDoubleUpDownCounters;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements;
        final String name;
        String description;
        String unit;

        ReconfigurableDoubleUpDownCounterBuilder(DoubleUpDownCounterBuilder delegate, String name, ConcurrentMap<InstrumentKey, ReconfigurableDoubleUpDownCounter> doubleUpDownCounters, ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleUpDownCounter> observableDoubleUpDownCounters, ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.doubleUpDownCounters = doubleUpDownCounters;
            this.observableDoubleUpDownCounters = observableDoubleUpDownCounters;
            this.observableDoubleMeasurements = observableDoubleMeasurements;
            this.lock = lock;
        }

        public DoubleUpDownCounterBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableDoubleUpDownCounterBuilder reconfigurableDoubleUpDownCounterBuilder = this;
                return reconfigurableDoubleUpDownCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableDoubleUpDownCounterBuilder reconfigurableDoubleUpDownCounterBuilder = this;
                return reconfigurableDoubleUpDownCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleUpDownCounter build() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                DoubleUpDownCounter doubleUpDownCounter = this.doubleUpDownCounters.computeIfAbsent(counterKey, k -> new ReconfigurableDoubleUpDownCounter(this.delegate.build(), this.lock));
                return doubleUpDownCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            this.lock.readLock().lock();
            try {
                ObservableDoubleMeasurementCallbackKey key = new ObservableDoubleMeasurementCallbackKey(this.name, this.description, this.unit, callback);
                ObservableDoubleUpDownCounter observableDoubleUpDownCounter = this.observableDoubleUpDownCounters.computeIfAbsent(key, k -> new ReconfigurableObservableDoubleUpDownCounter(this.delegate.buildWithCallback(callback), this.lock));
                return observableDoubleUpDownCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ObservableDoubleMeasurement buildObserver() {
            this.lock.readLock().lock();
            try {
                InstrumentKey key = new InstrumentKey(this.name, this.description, this.unit);
                ObservableDoubleMeasurement observableDoubleMeasurement = this.observableDoubleMeasurements.computeIfAbsent(key, k -> new ReconfigurableObservableDoubleMeasurement(this.delegate.buildObserver(), this.lock));
                return observableDoubleMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableObservableDoubleUpDownCounter
    implements ObservableDoubleUpDownCounter {
        final ReadWriteLock lock;
        ObservableDoubleUpDownCounter delegate;

        ReconfigurableObservableDoubleUpDownCounter(ObservableDoubleUpDownCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void setDelegate(ObservableDoubleUpDownCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public ObservableDoubleUpDownCounter getDelegate() {
            this.lock.readLock().lock();
            try {
                ObservableDoubleUpDownCounter observableDoubleUpDownCounter = this.delegate;
                return observableDoubleUpDownCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void close() {
            this.lock.readLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableObservableLongUpDownCounter
    implements ObservableLongUpDownCounter {
        final ReadWriteLock lock;
        ObservableLongUpDownCounter delegate;

        ReconfigurableObservableLongUpDownCounter(ObservableLongUpDownCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void setDelegate(ObservableLongUpDownCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public void close() {
            this.lock.readLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableLongUpDownCounterBuilder
    implements LongUpDownCounterBuilder {
        final ReadWriteLock lock;
        LongUpDownCounterBuilder delegate;
        final ConcurrentMap<InstrumentKey, ReconfigurableLongUpDownCounter> longUpDownCounters;
        final ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongUpDownCounter> observableLongUpDownCounters;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements;
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleUpDownCounter> doubleUpDownCounters;
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleUpDownCounter> observableDoubleUpDownCounters;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements;
        final String name;
        String description;
        String unit;

        ReconfigurableLongUpDownCounterBuilder(LongUpDownCounterBuilder delegate, String name, ConcurrentMap<InstrumentKey, ReconfigurableLongUpDownCounter> longUpDownCounters, ConcurrentMap<InstrumentKey, ReconfigurableDoubleUpDownCounter> doubleUpDownCounters, ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongUpDownCounter> observableLongUpDownCounters, ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements, ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleUpDownCounter> observableDoubleUpDownCounters, ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.longUpDownCounters = longUpDownCounters;
            this.observableLongUpDownCounters = observableLongUpDownCounters;
            this.observableLongMeasurements = observableLongMeasurements;
            this.doubleUpDownCounters = doubleUpDownCounters;
            this.observableDoubleUpDownCounters = observableDoubleUpDownCounters;
            this.observableDoubleMeasurements = observableDoubleMeasurements;
            this.lock = lock;
        }

        public LongUpDownCounterBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableLongUpDownCounterBuilder reconfigurableLongUpDownCounterBuilder = this;
                return reconfigurableLongUpDownCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongUpDownCounterBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableLongUpDownCounterBuilder reconfigurableLongUpDownCounterBuilder = this;
                return reconfigurableLongUpDownCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleUpDownCounterBuilder ofDoubles() {
            this.lock.readLock().lock();
            try {
                ReconfigurableDoubleUpDownCounterBuilder reconfigurableDoubleCounterBuilder = new ReconfigurableDoubleUpDownCounterBuilder(this.delegate.ofDoubles(), this.name, this.doubleUpDownCounters, this.observableDoubleUpDownCounters, this.observableDoubleMeasurements, this.lock);
                Optional.ofNullable(this.description).ifPresent(reconfigurableDoubleCounterBuilder::setDescription);
                Optional.ofNullable(this.unit).ifPresent(reconfigurableDoubleCounterBuilder::setUnit);
                ReconfigurableDoubleUpDownCounterBuilder reconfigurableDoubleUpDownCounterBuilder = reconfigurableDoubleCounterBuilder;
                return reconfigurableDoubleUpDownCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongUpDownCounter build() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                LongUpDownCounter longUpDownCounter = this.longUpDownCounters.computeIfAbsent(counterKey, k -> new ReconfigurableLongUpDownCounter(this.delegate.build(), this.lock));
                return longUpDownCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            this.lock.readLock().lock();
            try {
                ObservableLongMeasurementCallbackKey key = new ObservableLongMeasurementCallbackKey(this.name, this.description, this.unit, callback);
                ObservableLongUpDownCounter observableLongUpDownCounter = this.observableLongUpDownCounters.computeIfAbsent(key, k -> new ReconfigurableObservableLongUpDownCounter(this.delegate.buildWithCallback(callback), this.lock));
                return observableLongUpDownCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ObservableLongMeasurement buildObserver() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                ObservableLongMeasurement observableLongMeasurement = this.observableLongMeasurements.computeIfAbsent(counterKey, k -> new ReconfigurableObservableLongMeasurement(this.delegate.buildObserver(), this.lock));
                return observableLongMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableDoubleUpDownCounter
    implements DoubleUpDownCounter {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private DoubleUpDownCounter delegate;

        ReconfigurableDoubleUpDownCounter(DoubleUpDownCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void add(double increment) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(increment);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(double value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(double value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(DoubleUpDownCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public DoubleUpDownCounter getDelegate() {
            this.lock.readLock().lock();
            try {
                DoubleUpDownCounter doubleUpDownCounter = this.delegate;
                return doubleUpDownCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableLongUpDownCounter
    implements LongUpDownCounter {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private LongUpDownCounter delegate;

        ReconfigurableLongUpDownCounter(LongUpDownCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void add(long increment) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(increment);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(LongUpDownCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public LongUpDownCounter getDelegate() {
            this.lock.readLock().lock();
            try {
                LongUpDownCounter longUpDownCounter = this.delegate;
                return longUpDownCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableObservableDoubleMeasurement
    implements ObservableDoubleMeasurement,
    ReconfigurableObservableMeasurement<ObservableDoubleMeasurement> {
        final ReadWriteLock lock;
        private ObservableDoubleMeasurement delegate;

        ReconfigurableObservableDoubleMeasurement(ObservableDoubleMeasurement delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void record(double value) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(double value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public ObservableDoubleMeasurement getDelegate() {
            this.lock.readLock().lock();
            try {
                ObservableDoubleMeasurement observableDoubleMeasurement = this.delegate;
                return observableDoubleMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public void setDelegate(ObservableDoubleMeasurement delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableObservableDoubleGauge
    implements ObservableDoubleGauge {
        final ReadWriteLock lock;
        ObservableDoubleGauge delegate;

        ReconfigurableObservableDoubleGauge(ObservableDoubleGauge delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void setDelegate(ObservableDoubleGauge delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public void close() {
            this.lock.readLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableDoubleGauge
    implements DoubleGauge {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private DoubleGauge delegate;

        ReconfigurableDoubleGauge(DoubleGauge delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void set(double value) {
            this.lock.readLock().lock();
            try {
                this.delegate.set(value);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(double value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.set(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(double value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.set(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(DoubleGauge delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public DoubleGauge getDelegate() {
            this.lock.readLock().lock();
            try {
                DoubleGauge doubleGauge = this.delegate;
                return doubleGauge;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableObservableLongGauge
    implements ObservableLongGauge {
        final ReadWriteLock lock;
        ObservableLongGauge delegate;

        ReconfigurableObservableLongGauge(ObservableLongGauge delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void setDelegate(ObservableLongGauge delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public void close() {
            this.lock.readLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableLongGauge
    implements LongGauge {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private LongGauge delegate;

        ReconfigurableLongGauge(LongGauge delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void set(long value) {
            this.lock.readLock().lock();
            try {
                this.delegate.set(value);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(long value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.set(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(long value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.set(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(LongGauge delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public LongGauge getDelegate() {
            this.lock.readLock().lock();
            try {
                LongGauge longGauge = this.delegate;
                return longGauge;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableLongGaugeBuilder
    implements LongGaugeBuilder {
        final ReadWriteLock lock;
        LongGaugeBuilder delegate;
        final ConcurrentMap<InstrumentKey, ReconfigurableLongGauge> longGauges;
        final ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongGauge> observableLongGauges;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements;
        final String name;
        String description;
        String unit;

        ReconfigurableLongGaugeBuilder(LongGaugeBuilder delegate, String name, ConcurrentMap<InstrumentKey, ReconfigurableLongGauge> longGauges, ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongGauge> observableLongGauges, ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.longGauges = longGauges;
            this.observableLongGauges = observableLongGauges;
            this.observableLongMeasurements = observableLongMeasurements;
            this.lock = lock;
        }

        public LongGaugeBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableLongGaugeBuilder reconfigurableLongGaugeBuilder = this;
                return reconfigurableLongGaugeBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongGaugeBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableLongGaugeBuilder reconfigurableLongGaugeBuilder = this;
                return reconfigurableLongGaugeBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongGauge build() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                LongGauge longGauge = this.longGauges.computeIfAbsent(counterKey, k -> new ReconfigurableLongGauge(this.delegate.build(), this.lock));
                return longGauge;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            this.lock.readLock().lock();
            try {
                ObservableLongMeasurementCallbackKey key = new ObservableLongMeasurementCallbackKey(this.name, this.description, this.unit, callback);
                ObservableLongGauge observableLongGauge = this.observableLongGauges.computeIfAbsent(key, k -> new ReconfigurableObservableLongGauge(this.delegate.buildWithCallback(callback), this.lock));
                return observableLongGauge;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ObservableLongMeasurement buildObserver() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                ObservableLongMeasurement observableLongMeasurement = this.observableLongMeasurements.computeIfAbsent(counterKey, k -> new ReconfigurableObservableLongMeasurement(this.delegate.buildObserver(), this.lock));
                return observableLongMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableDoubleGaugeBuilder
    implements DoubleGaugeBuilder {
        final ReadWriteLock lock;
        DoubleGaugeBuilder delegate;
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleGauge> doubleGauges;
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleGauge> observableDoubleGauges;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements;
        final ConcurrentMap<InstrumentKey, ReconfigurableLongGauge> longGauges;
        final ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongGauge> observableLongGauges;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements;
        final String name;
        String description;
        String unit;

        ReconfigurableDoubleGaugeBuilder(DoubleGaugeBuilder delegate, String name, ConcurrentMap<InstrumentKey, ReconfigurableDoubleGauge> doubleGauges, ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleGauge> observableDoubleGauges, ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements, ConcurrentMap<InstrumentKey, ReconfigurableLongGauge> longGauges, ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongGauge> observableLongGauges, ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.doubleGauges = doubleGauges;
            this.observableDoubleGauges = observableDoubleGauges;
            this.observableDoubleMeasurements = observableDoubleMeasurements;
            this.observableLongGauges = observableLongGauges;
            this.observableLongMeasurements = observableLongMeasurements;
            this.longGauges = longGauges;
            this.lock = lock;
        }

        public DoubleGaugeBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableDoubleGaugeBuilder reconfigurableDoubleGaugeBuilder = this;
                return reconfigurableDoubleGaugeBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleGaugeBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableDoubleGaugeBuilder reconfigurableDoubleGaugeBuilder = this;
                return reconfigurableDoubleGaugeBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongGaugeBuilder ofLongs() {
            this.lock.readLock().lock();
            try {
                ReconfigurableLongGaugeBuilder reconfigurableLongCounterBuilder = new ReconfigurableLongGaugeBuilder(this.delegate.ofLongs(), this.name, this.longGauges, this.observableLongGauges, this.observableLongMeasurements, this.lock);
                Optional.ofNullable(this.description).ifPresent(reconfigurableLongCounterBuilder::setDescription);
                Optional.ofNullable(this.unit).ifPresent(reconfigurableLongCounterBuilder::setUnit);
                ReconfigurableLongGaugeBuilder reconfigurableLongGaugeBuilder = reconfigurableLongCounterBuilder;
                return reconfigurableLongGaugeBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleGauge build() {
            this.lock.readLock().lock();
            try {
                InstrumentKey gaugeKey = new InstrumentKey(this.name, this.description, this.unit);
                DoubleGauge doubleGauge = this.doubleGauges.computeIfAbsent(gaugeKey, k -> new ReconfigurableDoubleGauge(this.delegate.build(), this.lock));
                return doubleGauge;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            this.lock.readLock().lock();
            try {
                ObservableDoubleMeasurementCallbackKey key = new ObservableDoubleMeasurementCallbackKey(this.name, this.description, this.unit, callback);
                ObservableDoubleGauge observableDoubleGauge = this.observableDoubleGauges.computeIfAbsent(key, k -> new ReconfigurableObservableDoubleGauge(this.delegate.buildWithCallback(callback), this.lock));
                return observableDoubleGauge;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ObservableDoubleMeasurement buildObserver() {
            this.lock.readLock().lock();
            try {
                InstrumentKey gaugeKey = new InstrumentKey(this.name, this.description, this.unit);
                ObservableDoubleMeasurement observableDoubleMeasurement = this.observableDoubleMeasurements.computeIfAbsent(gaugeKey, k -> new ReconfigurableObservableDoubleMeasurement(this.delegate.buildObserver(), this.lock));
                return observableDoubleMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableDoubleCounter
    implements ExtendedDoubleCounter {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private DoubleCounter delegate;

        ReconfigurableDoubleCounter(DoubleCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void add(double increment) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(increment);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(double value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(double value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(DoubleCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public DoubleCounter getDelegate() {
            this.lock.readLock().lock();
            try {
                DoubleCounter doubleCounter = this.delegate;
                return doubleCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public boolean isEnabled() {
            this.lock.readLock().lock();
            try {
                if (this.delegate instanceof ExtendedDoubleCounter) {
                    boolean bl = ((ExtendedDoubleCounter)this.delegate).isEnabled();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableObservableDoubleCounter
    implements ObservableDoubleCounter {
        final ReadWriteLock lock;
        ObservableDoubleCounter delegate;

        ReconfigurableObservableDoubleCounter(ObservableDoubleCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void setDelegate(ObservableDoubleCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public ObservableDoubleCounter getDelegate() {
            this.lock.readLock().lock();
            try {
                ObservableDoubleCounter observableDoubleCounter = this.delegate;
                return observableDoubleCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void close() {
            this.lock.readLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableDoubleCounterBuilder
    implements DoubleCounterBuilder {
        final ReadWriteLock lock;
        DoubleCounterBuilder delegate;
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleCounter> doubleCounters;
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleCounter> observableDoubleCounters;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements;
        final String name;
        String description;
        String unit;

        ReconfigurableDoubleCounterBuilder(DoubleCounterBuilder delegate, String name, ConcurrentMap<InstrumentKey, ReconfigurableDoubleCounter> doubleCounters, ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleCounter> observableDoubleCounters, ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.doubleCounters = doubleCounters;
            this.observableDoubleCounters = observableDoubleCounters;
            this.observableDoubleMeasurements = observableDoubleMeasurements;
            this.lock = lock;
        }

        public DoubleCounterBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableDoubleCounterBuilder reconfigurableDoubleCounterBuilder = this;
                return reconfigurableDoubleCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleCounterBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableDoubleCounterBuilder reconfigurableDoubleCounterBuilder = this;
                return reconfigurableDoubleCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleCounter build() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                DoubleCounter doubleCounter = (DoubleCounter)this.doubleCounters.computeIfAbsent(counterKey, k -> new ReconfigurableDoubleCounter(this.delegate.build(), this.lock));
                return doubleCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            this.lock.readLock().lock();
            try {
                ObservableDoubleMeasurementCallbackKey key = new ObservableDoubleMeasurementCallbackKey(this.name, this.description, this.unit, callback);
                ObservableDoubleCounter observableDoubleCounter = this.observableDoubleCounters.computeIfAbsent(key, k -> new ReconfigurableObservableDoubleCounter(this.delegate.buildWithCallback(callback), this.lock));
                return observableDoubleCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ObservableDoubleMeasurement buildObserver() {
            this.lock.readLock().lock();
            try {
                InstrumentKey key = new InstrumentKey(this.name, this.description, this.unit);
                ObservableDoubleMeasurement observableDoubleMeasurement = this.observableDoubleMeasurements.computeIfAbsent(key, k -> new ReconfigurableObservableDoubleMeasurement(this.delegate.buildObserver(), this.lock));
                return observableDoubleMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableObservableLongCounter
    implements ObservableLongCounter {
        final ReadWriteLock lock;
        ObservableLongCounter delegate;

        ReconfigurableObservableLongCounter(ObservableLongCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void setDelegate(ObservableLongCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public void close() {
            this.lock.readLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    @ThreadSafe
    protected static class ReconfigurableLongCounter
    implements ExtendedLongCounter {
        final ReadWriteLock lock;
        @GuardedBy(value="lock")
        private LongCounter delegate;

        ReconfigurableLongCounter(LongCounter delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void add(long increment) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(increment);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long value, Attributes attributes, Context context) {
            this.lock.readLock().lock();
            try {
                this.delegate.add(value, attributes, context);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(LongCounter delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public LongCounter getDelegate() {
            this.lock.readLock().lock();
            try {
                LongCounter longCounter = this.delegate;
                return longCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public boolean isEnabled() {
            this.lock.readLock().lock();
            try {
                if (this.delegate instanceof ExtendedLongCounter) {
                    boolean bl = ((ExtendedLongCounter)this.delegate).isEnabled();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class ReconfigurableLongCounterBuilder
    implements LongCounterBuilder {
        final ReadWriteLock lock;
        LongCounterBuilder delegate;
        final ConcurrentMap<InstrumentKey, ReconfigurableLongCounter> longCounters;
        final ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongCounter> observableLongCounters;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements;
        final ConcurrentMap<InstrumentKey, ReconfigurableDoubleCounter> doubleCounters;
        final ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleCounter> observableDoubleCounters;
        final ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements;
        final String name;
        String description;
        String unit;

        ReconfigurableLongCounterBuilder(LongCounterBuilder delegate, String name, ConcurrentMap<InstrumentKey, ReconfigurableLongCounter> longCounters, ConcurrentMap<InstrumentKey, ReconfigurableDoubleCounter> doubleCounters, ConcurrentMap<ObservableLongMeasurementCallbackKey, ReconfigurableObservableLongCounter> observableLongCounters, ConcurrentMap<InstrumentKey, ReconfigurableObservableLongMeasurement> observableLongMeasurements, ConcurrentMap<ObservableDoubleMeasurementCallbackKey, ReconfigurableObservableDoubleCounter> observableDoubleCounters, ConcurrentMap<InstrumentKey, ReconfigurableObservableDoubleMeasurement> observableDoubleMeasurements, ReadWriteLock lock) {
            this.delegate = delegate;
            this.name = name;
            this.longCounters = longCounters;
            this.observableLongCounters = observableLongCounters;
            this.observableLongMeasurements = observableLongMeasurements;
            this.doubleCounters = doubleCounters;
            this.observableDoubleCounters = observableDoubleCounters;
            this.observableDoubleMeasurements = observableDoubleMeasurements;
            this.lock = lock;
        }

        public LongCounterBuilder setDescription(String description) {
            this.lock.readLock().lock();
            try {
                this.delegate.setDescription(description);
                this.description = description;
                ReconfigurableLongCounterBuilder reconfigurableLongCounterBuilder = this;
                return reconfigurableLongCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongCounterBuilder setUnit(String unit) {
            this.lock.readLock().lock();
            try {
                this.delegate.setUnit(unit);
                this.unit = unit;
                ReconfigurableLongCounterBuilder reconfigurableLongCounterBuilder = this;
                return reconfigurableLongCounterBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public DoubleCounterBuilder ofDoubles() {
            this.lock.readLock().lock();
            try {
                ReconfigurableDoubleCounterBuilder reconfigurableDoubleCounterBuilder = new ReconfigurableDoubleCounterBuilder(this.delegate.ofDoubles(), this.name, this.doubleCounters, this.observableDoubleCounters, this.observableDoubleMeasurements, this.lock);
                Optional.ofNullable(this.description).ifPresent(reconfigurableDoubleCounterBuilder::setDescription);
                Optional.ofNullable(this.unit).ifPresent(reconfigurableDoubleCounterBuilder::setUnit);
                ReconfigurableDoubleCounterBuilder reconfigurableDoubleCounterBuilder2 = reconfigurableDoubleCounterBuilder;
                return reconfigurableDoubleCounterBuilder2;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public LongCounter build() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                LongCounter longCounter = (LongCounter)this.longCounters.computeIfAbsent(counterKey, k -> new ReconfigurableLongCounter(this.delegate.build(), this.lock));
                return longCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            this.lock.readLock().lock();
            try {
                ObservableLongMeasurementCallbackKey key = new ObservableLongMeasurementCallbackKey(this.name, this.description, this.unit, callback);
                ObservableLongCounter observableLongCounter = this.observableLongCounters.computeIfAbsent(key, k -> new ReconfigurableObservableLongCounter(this.delegate.buildWithCallback(callback), this.lock));
                return observableLongCounter;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public ObservableLongMeasurement buildObserver() {
            this.lock.readLock().lock();
            try {
                InstrumentKey counterKey = new InstrumentKey(this.name, this.description, this.unit);
                ObservableLongMeasurement observableLongMeasurement = this.observableLongMeasurements.computeIfAbsent(counterKey, k -> new ReconfigurableObservableLongMeasurement(this.delegate.buildObserver(), this.lock));
                return observableLongMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableObservableLongMeasurement
    implements ObservableLongMeasurement,
    ReconfigurableObservableMeasurement<ObservableLongMeasurement> {
        final ReadWriteLock lock;
        private ObservableLongMeasurement delegate;

        ReconfigurableObservableLongMeasurement(ObservableLongMeasurement delegate, ReadWriteLock lock) {
            this.delegate = delegate;
            this.lock = lock;
        }

        public void record(long value) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(long value, Attributes attributes) {
            this.lock.readLock().lock();
            try {
                this.delegate.record(value, attributes);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public ObservableLongMeasurement getDelegate() {
            this.lock.readLock().lock();
            try {
                ObservableLongMeasurement observableLongMeasurement = this.delegate;
                return observableLongMeasurement;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public void setDelegate(ObservableLongMeasurement delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public String toString() {
            return "ReconfigurableObservableLongMeasurement{delegate=" + String.valueOf(this.delegate) + "}";
        }
    }

    static class ObservableDoubleMeasurementCallbackKey {
        final String name;
        @Nullable
        final String description;
        @Nullable
        final String unit;
        final Consumer<ObservableDoubleMeasurement> callback;

        public ObservableDoubleMeasurementCallbackKey(String name, @Nullable String description, @Nullable String unit, Consumer<ObservableDoubleMeasurement> callback) {
            this.name = name;
            this.description = description;
            this.unit = unit;
            this.callback = callback;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObservableDoubleMeasurementCallbackKey that = (ObservableDoubleMeasurementCallbackKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.unit, that.unit) && Objects.equals(this.callback, that.callback);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.description, this.unit, this.callback);
        }
    }

    static class ObservableLongMeasurementCallbackKey {
        final String name;
        @Nullable
        final String description;
        @Nullable
        final String unit;
        final Consumer<ObservableLongMeasurement> callback;

        public ObservableLongMeasurementCallbackKey(String name, @Nullable String description, @Nullable String unit, Consumer<ObservableLongMeasurement> callback) {
            this.name = name;
            this.description = description;
            this.unit = unit;
            this.callback = callback;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObservableLongMeasurementCallbackKey that = (ObservableLongMeasurementCallbackKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.unit, that.unit) && Objects.equals(this.callback, that.callback);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.description, this.unit, this.callback);
        }
    }

    static class HistogramKey<T extends Number>
    extends InstrumentKey {
        @Nullable
        final List<T> bucketBoundaries;

        public HistogramKey(String name, @Nullable String description, @Nullable String unit, @Nullable List<AttributeKey<?>> attributes, @Nullable List<T> bucketBoundaries) {
            super(name, description, unit, attributes);
            this.bucketBoundaries = bucketBoundaries;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HistogramKey that = (HistogramKey)o;
            return Objects.equals(this.bucketBoundaries, that.bucketBoundaries);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.bucketBoundaries);
        }
    }

    static class InstrumentKey {
        final String name;
        @Nullable
        final String description;
        @Nullable
        final String unit;
        @Nullable
        final List<AttributeKey<?>> attributes;

        public InstrumentKey(String name, @Nullable String description, @Nullable String unit, @Nullable List<AttributeKey<?>> attributes) {
            this.name = name;
            this.description = description;
            this.unit = unit;
            this.attributes = attributes;
        }

        public InstrumentKey(String name, @Nullable String description, @Nullable String unit) {
            this(name, description, unit, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstrumentKey that = (InstrumentKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.unit, that.unit) && Objects.equals(this.attributes, that.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.description, this.unit, this.attributes);
        }
    }
}

