/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit.exec;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import io.jenkins.plugins.onmonit.LauncherProvider;
import io.jenkins.plugins.onmonit.RemoteOtelContribProcess;
import io.jenkins.plugins.onmonit.RemoteOtelContribProcessFactory;
import io.jenkins.plugins.onmonit.exec.ExecDownloadedOtelContribProcessFactory;
import io.jenkins.plugins.onmonit.exec.ExecRemoteOtelContribProcessFactory;
import io.jenkins.plugins.onmonit.exec.ExecUploadedOtelContribProcessFactory;
import io.jenkins.plugins.onmonit.util.ComputerInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Extension
public class DelegatedOtelContribProcessFactory
extends RemoteOtelContribProcessFactory {
    private static final List<RemoteOtelContribProcessFactory> delegates = List.of(new ExecRemoteOtelContribProcessFactory(), new ExecDownloadedOtelContribProcessFactory(), new ExecUploadedOtelContribProcessFactory());

    @Override
    public String getDisplayName() {
        return "Delegated exec otelcol-contrib (fixed order delegation to other process factories)";
    }

    @Override
    public boolean isSupported(Launcher launcher, TaskListener listener, ComputerInfo info) {
        return true;
    }

    @Override
    public RemoteOtelContribProcess create(LauncherProvider launcherProvider, TaskListener listener, ComputerInfo info, FilePath temp, String envCookie, String additionalOptions, boolean debug) throws Throwable {
        Launcher launcher = launcherProvider.getLauncher();
        LinkedHashMap<String, Throwable> faults = new LinkedHashMap<String, Throwable>();
        for (RemoteOtelContribProcessFactory remoteOtelContribProcessFactory : delegates) {
            if (!remoteOtelContribProcessFactory.isSupported(launcher, listener, info)) continue;
            try {
                listener.getLogger().println("[on-monit]   " + remoteOtelContribProcessFactory.getDisplayName());
                return remoteOtelContribProcessFactory.create(launcherProvider, listener, info, temp, envCookie, additionalOptions, debug);
            }
            catch (Throwable t) {
                faults.put(remoteOtelContribProcessFactory.getDisplayName(), t);
            }
        }
        for (Map.Entry entry : faults.entrySet()) {
            listener.getLogger().println("[on-monit] * " + (String)entry.getKey());
            StringWriter sw = new StringWriter();
            ((Throwable)entry.getValue()).printStackTrace(new PrintWriter(sw));
            for (String line : StringUtils.split((String)sw.toString(), (String)"\n")) {
                listener.getLogger().println("[on-monit]     " + line);
            }
        }
        throw new RuntimeException("Could not start process otel-contrib");
    }
}

