/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.onmonit.ONMonitConfig;
import io.jenkins.plugins.onmonit.ONTemplating;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;

public class MonitoringAction
implements Action,
RunAction2,
SimpleBuildStep.LastBuildAction,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(MonitoringAction.class.getName());
    private static final long serialVersionUID = -7093396061479813632L;
    private static final ONTemplating templating = new ONTemplating();
    private final String jobGroup;
    private final String jobName;
    private final String jobId;
    private final String dashboardUrl;
    private transient Run run;
    private boolean isProjectAction;

    public MonitoringAction(String jobGroup, String jobName, String jobId, String dashboardUrl) {
        this.jobGroup = jobGroup;
        this.jobName = jobName;
        this.jobId = jobId;
        this.dashboardUrl = dashboardUrl;
    }

    public MonitoringAction(MonitoringAction original, boolean isProjectAction) {
        this.jobGroup = original.jobGroup;
        this.jobName = original.jobName;
        this.jobId = original.jobId;
        this.dashboardUrl = original.dashboardUrl;
        this.run = original.run;
        this.isProjectAction = isProjectAction;
    }

    public MonitoringAction(ONTemplating.UrlContext context, String dashboardUrl) {
        this(context.getJobGroup(), context.getJobName(), context.getJobId(), dashboardUrl);
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public Collection<? extends Action> getProjectActions() {
        Run build = this.run.getParent().getLastBuild();
        if (build == null) {
            return new ArrayList();
        }
        return build.getActions(MonitoringAction.class).stream().map(a -> new MonitoringAction((MonitoringAction)a, true)).collect(Collectors.toList());
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "ONMonit";
    }

    public String getUrlName() {
        return null;
    }

    @NonNull
    public List<MonitoringDashboardLink> getLinks() {
        String dashboardUrlTemplate = this.dashboardUrl;
        if ((null == this.dashboardUrl || this.dashboardUrl.isEmpty()) && (dashboardUrlTemplate = ONMonitConfig.get().getGrafanaDashboard()).isEmpty()) {
            return Collections.singletonList(new MonitoringDashboardLink("Please define an ONMonit dashboard URL in Jenkins configuration", Jenkins.get().getRootUrl() + "/configure", "icon-gear2"));
        }
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("jobGroup", this.jobGroup);
        binding.put("jobName", this.jobName);
        binding.put("jobId", this.jobId);
        binding.put("startTime", String.valueOf(this.run.getStartTimeInMillis()));
        if (this.run.isBuilding()) {
            binding.put("endTime", "now");
        } else {
            binding.put("endTime", String.valueOf(this.run.getStartTimeInMillis() + this.run.getDuration()));
        }
        return Collections.singletonList(new MonitoringDashboardLink((this.isProjectAction ? "View last" : "View") + " build with Grafana", templating.getVisualisationUrl(dashboardUrlTemplate, binding), "icon-onmonit-grafana"));
    }

    public String toString() {
        return "MonitoringAction{jobGroup='" + this.jobGroup + "', jobName='" + this.jobName + "', jobId='" + this.jobId + "', dashboardUrl='" + this.dashboardUrl + "'}";
    }

    public static class MonitoringDashboardLink {
        final String label;
        final String url;
        final String iconClass;

        public MonitoringDashboardLink(String label, String url, String iconClass) {
            this.label = label;
            this.url = url;
            this.iconClass = iconClass;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIconClass() {
            return this.iconClass;
        }

        public String toString() {
            return "MonitoringDashboardLink{label='" + this.label + "', url='" + this.url + "', iconClass='" + this.iconClass + "'}";
        }
    }
}

