/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Messages;
import io.jenkins.plugins.neuvector.NeuVectorBuilder;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Registry
extends AbstractDescribableImpl<Registry>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nickname;
    private String regUrl;
    private String regUsername;
    private Secret regPassword;

    @DataBoundConstructor
    public Registry(String nickname, String regUrl, String regUsername, Secret regPassword) {
        this.nickname = nickname.trim();
        this.regUrl = regUrl.trim();
        this.regUsername = regUsername.trim();
        this.regPassword = regPassword;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setRegUrl(String regUrl) {
        this.regUrl = regUrl;
    }

    public String getRegUrl() {
        return this.regUrl;
    }

    public void setRegUsername(String regUsername) {
        this.regUsername = regUsername;
    }

    public String getRegUsername() {
        return this.regUsername;
    }

    public void setRegPassword(Secret regPassword) {
        this.regPassword = regPassword;
    }

    public Secret getRegPassword() {
        return this.regPassword;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Registry> {
        private final NeuVectorBuilder.DescriptorImpl globalConfig = (NeuVectorBuilder.DescriptorImpl)Jenkins.get().getDescriptorByType(NeuVectorBuilder.DescriptorImpl.class);

        public String getDisplayName() {
            return "Add Registry";
        }

        public FormValidation doCheckNickname(@QueryParameter String nickname) {
            if (Strings.isNullOrEmpty((String)nickname) || nickname.trim().isEmpty()) {
                return FormValidation.error((String)Messages.Registry_DescriptorImpl_errors_nickname());
            }
            return FormValidation.ok();
        }

        public FormValidation doDeleteRegistry(@QueryParameter String nickname) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            List<Registry> registries = this.globalConfig.getRegistries();
            Iterator<Registry> iterator = registries.iterator();
            while (iterator.hasNext()) {
                Registry endpoint = iterator.next();
                if (!endpoint.getNickname().equals(nickname)) continue;
                iterator.remove();
                this.globalConfig.save();
            }
            return FormValidation.ok((String)"Deleted successfully");
        }

        public FormValidation doCheckRegUrl(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty() || !value.trim().matches("^(http|https)://.*$")) {
                return FormValidation.error((String)Messages.Registry_DescriptorImpl_errors_regUrl());
            }
            return FormValidation.ok();
        }

        public synchronized void save() {
            super.save();
        }
    }
}

